/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.utils.LoadbalanceAlgorithmFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.ServiceDynamicLoadbalanceEndpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.dispatch.HttpSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SoapSessionDispatcher;

public class ServiceDynamicLoadbalanceEndpointFactory
extends EndpointFactory {
    private static ServiceDynamicLoadbalanceEndpointFactory instance = new ServiceDynamicLoadbalanceEndpointFactory();
    public static final QName SERVICES_QNAME = new QName("http://ws.apache.org/ns/synapse", "services");
    public static final QName LB_CONFIG_QNAME = new QName("http://ws.apache.org/ns/synapse", "loadBalancerConfig");

    private ServiceDynamicLoadbalanceEndpointFactory() {
    }

    public static ServiceDynamicLoadbalanceEndpointFactory getInstance() {
        return instance;
    }

    @Override
    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMElement sessionElement;
        OMElement servicesEle;
        OMElement loadbalanceElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "serviceDynamicLoadbalance"));
        if (loadbalanceElement == null) {
            return null;
        }
        String configuration = loadbalanceElement.getAttributeValue(new QName("", "configuration"));
        if (configuration != null) {
            if (configuration.startsWith("$system:")) {
                configuration = System.getProperty(configuration.substring("$system:".length()));
            }
            OMXMLParserWrapper builder = null;
            try {
                builder = OMXMLBuilderFactory.createOMBuilder((InputStream)new URL(configuration).openStream());
            }
            catch (Exception e) {
                ServiceDynamicLoadbalanceEndpointFactory.handleException("Could not load ServiceDynamicLoadbalanceEndpoint configuration file " + configuration);
            }
            servicesEle = builder.getDocumentElement().getFirstChildWithName(SERVICES_QNAME);
        } else {
            OMElement lbConfigEle = loadbalanceElement.getFirstChildWithName(LB_CONFIG_QNAME);
            if (lbConfigEle == null) {
                throw new RuntimeException("loadBalancerConfig element not found as a child of serviceDynamicLoadbalance element");
            }
            servicesEle = lbConfigEle.getFirstChildWithName(SERVICES_QNAME);
        }
        if (servicesEle == null) {
            throw new RuntimeException("services element not found in serviceDynamicLoadbalance configuration");
        }
        HashMap<String, String> hostDomainMap = new HashMap<String, String>();
        Iterator iter = servicesEle.getChildrenWithLocalName("service");
        while (iter.hasNext()) {
            OMElement serviceEle = (OMElement)iter.next();
            OMElement hostsEle = serviceEle.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "hosts"));
            if (hostsEle == null) {
                throw new RuntimeException("hosts element not found as a child of service element");
            }
            ArrayList<String> hosts = new ArrayList<String>();
            Iterator hostIter = hostsEle.getChildrenWithLocalName("host");
            while (hostIter.hasNext()) {
                OMElement hostEle = (OMElement)hostIter.next();
                String host = hostEle.getText();
                if (host.trim().length() == 0) {
                    throw new RuntimeException("host cannot be null");
                }
                hosts.add(host);
            }
            OMElement domainEle = serviceEle.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "domain"));
            if (domainEle == null) {
                throw new RuntimeException("domain element not found in as a child of services");
            }
            String domain = domainEle.getText();
            if (domain.trim().length() == 0) {
                throw new RuntimeException("domain cannot be null");
            }
            for (String host : hosts) {
                if (hostDomainMap.containsKey(host)) {
                    throw new RuntimeException("host " + host + " has been already defined for " + "clustering domain " + (String)hostDomainMap.get(host));
                }
                hostDomainMap.put(host, domain);
            }
        }
        if (hostDomainMap.isEmpty()) {
            throw new RuntimeException("No service elements defined under services");
        }
        LoadbalanceAlgorithm algorithm = LoadbalanceAlgorithmFactory.createLoadbalanceAlgorithm(loadbalanceElement, null);
        ServiceDynamicLoadbalanceEndpoint loadbalanceEndpoint = new ServiceDynamicLoadbalanceEndpoint(hostDomainMap, algorithm);
        OMAttribute name = epConfig.getAttribute(new QName("", "name"));
        if (name != null) {
            loadbalanceEndpoint.setName(name.getAttributeValue());
        }
        if ((sessionElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "session"))) != null) {
            String type;
            OMElement sessionTimeout = sessionElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sessionTimeout"));
            if (sessionTimeout != null) {
                try {
                    loadbalanceEndpoint.setSessionTimeout(Long.parseLong(sessionTimeout.getText().trim()));
                }
                catch (NumberFormatException nfe) {
                    ServiceDynamicLoadbalanceEndpointFactory.handleException("Invalid session timeout value : " + sessionTimeout.getText());
                }
            }
            if ((type = sessionElement.getAttributeValue(new QName("type"))).equalsIgnoreCase("soap")) {
                SoapSessionDispatcher soapDispatcher = new SoapSessionDispatcher();
                loadbalanceEndpoint.setDispatcher(soapDispatcher);
            } else if (type.equalsIgnoreCase("http")) {
                HttpSessionDispatcher httpDispatcher = new HttpSessionDispatcher();
                loadbalanceEndpoint.setDispatcher(httpDispatcher);
            }
            loadbalanceEndpoint.setSessionAffinity(true);
        }
        loadbalanceEndpoint.setFailover(false);
        return loadbalanceEndpoint;
    }
}

