/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.xml.AnonymousListMediator;
import org.apache.synapse.core.SynapseEnvironment;

public class SwitchCase
implements ManagedLifecycle {
    private static final Log log = LogFactory.getLog(SwitchCase.class);
    private Pattern regex = null;
    private AnonymousListMediator caseMediator;

    @Override
    public void init(SynapseEnvironment se) {
        this.caseMediator.init(se);
    }

    @Override
    public void destroy() {
        this.caseMediator.destroy();
    }

    public boolean mediate(MessageContext synCtx) {
        return this.caseMediator == null || this.caseMediator.mediate(synCtx);
    }

    public AnonymousListMediator getCaseMediator() {
        return this.caseMediator;
    }

    public void setCaseMediator(AnonymousListMediator caseMediator) {
        this.caseMediator = caseMediator;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }

    public boolean matches(String value) {
        if (value == null) {
            log.warn((Object)"Provided character sequence for switch case condition is 'null'. Switch case will not be executed.");
            return false;
        }
        Matcher matcher = this.regex.matcher(value);
        if (matcher == null) {
            log.warn((Object)("Matcher for the provided character sequence and the pattern ' " + this.regex + " '" + " cannot be found. Switch case will not be executed."));
            return false;
        }
        return matcher.matches();
    }
}

