/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

public class XmlWriterUtil {
    public static final int DEFAULT_INDENTATION_SIZE = 2;
    public static final int DEFAULT_COLUMN_LINE = 80;

    public static void writeLineBreak(XMLWriter writer) {
        XmlWriterUtil.writeLineBreak(writer, 1);
    }

    public static void writeLineBreak(XMLWriter writer, int repeat) {
        for (int i = 0; i < repeat; ++i) {
            writer.writeMarkup("\n");
        }
    }

    public static void writeLineBreak(XMLWriter writer, int repeat, int indent) {
        XmlWriterUtil.writeLineBreak(writer, repeat, indent, 2);
    }

    public static void writeLineBreak(XMLWriter writer, int repeat, int indent, int indentSize) {
        XmlWriterUtil.writeLineBreak(writer, repeat);
        if (indent < 0) {
            indent = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        writer.writeText(StringUtils.repeat(" ", indent * indentSize));
    }

    public static void writeCommentLineBreak(XMLWriter writer) {
        XmlWriterUtil.writeCommentLineBreak(writer, 80);
    }

    public static void writeCommentLineBreak(XMLWriter writer, int columnSize) {
        if (columnSize < 0) {
            columnSize = 80;
        }
        writer.writeMarkup("<!-- " + StringUtils.repeat("=", columnSize - 10) + " -->\n");
    }

    public static void writeComment(XMLWriter writer, String comment) {
        if (comment == null) {
            comment = "null";
        }
        String[] words = StringUtils.split(comment, " ");
        StringBuffer line = new StringBuffer("<!-- ");
        for (int i = 0; i < words.length; ++i) {
            String[] sentences = StringUtils.split(words[i], "\n");
            if (sentences.length > 1) {
                for (int j = 0; j < sentences.length - 1; ++j) {
                    line.append(sentences[j]).append(' ');
                    line.append(StringUtils.repeat(" ", 76 - line.length())).append("-->").append('\n');
                    writer.writeMarkup(line.toString());
                    line = new StringBuffer("<!-- ");
                }
                line.append(sentences[sentences.length - 1]).append(' ');
                continue;
            }
            StringBuffer sentenceTmp = new StringBuffer(line.toString());
            sentenceTmp.append(words[i]).append(' ');
            if (sentenceTmp.length() > 76) {
                line.append(StringUtils.repeat(" ", 76 - line.length())).append("-->").append('\n');
                writer.writeMarkup(line.toString());
                line = new StringBuffer("<!-- ");
                line.append(words[i]).append(' ');
                continue;
            }
            line.append(words[i]).append(' ');
        }
        if (line.length() <= 76) {
            line.append(StringUtils.repeat(" ", 76 - line.length())).append("-->").append('\n');
        }
        writer.writeMarkup(line.toString());
    }

    public static void writeCommentText(XMLWriter writer, String comment, int indent) {
        XmlWriterUtil.writeCommentText(writer, comment, indent, 2);
    }

    public static void writeCommentText(XMLWriter writer, String comment, int indent, int indentSize) {
        if (indent < 0) {
            indent = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        XmlWriterUtil.writeLineBreak(writer, 1);
        writer.writeMarkup(StringUtils.repeat(" ", indent * indentSize));
        XmlWriterUtil.writeCommentLineBreak(writer);
        writer.writeMarkup(StringUtils.repeat(" ", indent * indentSize));
        XmlWriterUtil.writeComment(writer, comment);
        writer.writeMarkup(StringUtils.repeat(" ", indent * indentSize));
        XmlWriterUtil.writeCommentLineBreak(writer);
        XmlWriterUtil.writeLineBreak(writer, 1, indent);
    }
}

