/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import java.util.ArrayList;
import java.util.List;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingSignatureTrustEngine
implements SignatureTrustEngine {
    private final Logger log = LoggerFactory.getLogger(ChainingSignatureTrustEngine.class);
    private List<SignatureTrustEngine> engines = new ArrayList<SignatureTrustEngine>();

    public List<SignatureTrustEngine> getChain() {
        return this.engines;
    }

    @Override
    public KeyInfoCredentialResolver getKeyInfoResolver() {
        return null;
    }

    @Override
    public boolean validate(Signature token, CriteriaSet trustBasisCriteria) throws SecurityException {
        for (SignatureTrustEngine engine : this.engines) {
            if (!engine.validate(token, trustBasisCriteria)) continue;
            this.log.debug("Signature was trusted by chain member: {}", (Object)engine.getClass().getName());
            return true;
        }
        return false;
    }

    @Override
    public boolean validate(byte[] signature, byte[] content, String algorithmURI, CriteriaSet trustBasisCriteria, Credential candidateCredential) throws SecurityException {
        for (SignatureTrustEngine engine : this.engines) {
            if (!engine.validate(signature, content, algorithmURI, trustBasisCriteria, candidateCredential)) continue;
            this.log.debug("Signature was trusted by chain member: {}", (Object)engine.getClass().getName());
            return true;
        }
        return false;
    }
}

