/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.PolicyUtil;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rahas.SimpleTokenStore;
import org.apache.rahas.TokenStorage;
import org.apache.rampart.RampartConfigCallbackHandler;
import org.apache.rampart.RampartException;
import org.apache.rampart.handler.RampartUsernameTokenValidator;
import org.apache.rampart.policy.RampartPolicyBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.saml.SAMLAssertionHandler;
import org.apache.rampart.saml.SAMLAssertionHandlerFactory;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RampartMessageData {
    public static final String KEY_RAMPART_POLICY = "rampartPolicy";
    public static final String KEY_RAMPART_IN_POLICY = "rampartInPolicy";
    public static final String KEY_RAMPART_OUT_POLICY = "rampartOutPolicy";
    public static final String RAMPART_POLICY_DATA = "rampartPolicyData";
    public static final String RAMPART_STS_POLICY = "rampartStsPolicy";
    public static final String KEY_CUSTOM_ISSUED_TOKEN = "customIssuedToken";
    public static final String USERNAME = "username";
    public static final String SIGNATURE_CERT_ALIAS = "signatureCertAlias";
    public static final String KEY_WST_VERSION = "wstVersion";
    public static final String PARAM_CLIENT_SIDE = "CLIENT_SIDE";
    public static final String KEY_WSSC_VERSION = "wscVersion";
    public static final String KEY_SCT_ISSUER_POLICY = "sct-issuer-policy";
    public static final String CANCEL_REQUEST = "cancelrequest";
    public static final String SCT_ID = "sctID";
    public static final String X509_CERT = "X509Certificate";
    private MessageContext msgContext = null;
    private RampartPolicyData policyData = null;
    private WSSecHeader secHeader = null;
    private WSSConfig config = null;
    private int timeToLive = 300;
    private int timestampMaxSkew = 0;
    private String timestampId;
    private Document document;
    private TokenStorage tokenStorage;
    private int wstVersion = 2;
    private int secConvVersion = 2;
    private String issuedEncryptionTokenId;
    private String issuedSignatureTokenId;
    private Policy servicePolicy;
    private boolean isInitiator;
    private boolean sender;
    private ClassLoader customClassLoader;
    private SOAPConstants soapConstants;

    public RampartMessageData(MessageContext msgCtx, boolean sender) throws RampartException {
        this.msgContext = msgCtx;
        try {
            MessageContext outMsgCtx;
            MessageContext inMsgCtx;
            Parameter param;
            AxisService axisService;
            block29: {
                int flow;
                this.config = WSSConfig.getNewInstance();
                this.config.setValidator(WSSecurityEngine.USERNAME_TOKEN, RampartUsernameTokenValidator.class);
                axisService = msgCtx.getAxisService();
                if (axisService != null && axisService.getParameter(PARAM_CLIENT_SIDE) != null) {
                    this.isInitiator = true;
                } else {
                    boolean bl = this.isInitiator = !msgCtx.isServerSide();
                    if (this.isInitiator && axisService != null) {
                        Parameter clientSideParam = new Parameter();
                        clientSideParam.setName(PARAM_CLIENT_SIDE);
                        clientSideParam.setLocked(true);
                        msgCtx.getAxisService().addParameter(clientSideParam);
                    }
                }
                if (msgCtx.getProperty(KEY_RAMPART_POLICY) != null) {
                    this.servicePolicy = (Policy)msgCtx.getProperty(KEY_RAMPART_POLICY);
                }
                if (((flow = msgCtx.getFLOW()) == 1 || flow == 3) && msgCtx.getProperty(KEY_RAMPART_IN_POLICY) != null) {
                    this.servicePolicy = this.servicePolicy == null ? (Policy)msgCtx.getProperty(KEY_RAMPART_IN_POLICY) : this.servicePolicy.merge((Policy)msgCtx.getProperty(KEY_RAMPART_IN_POLICY));
                } else if ((flow == 2 || flow == 4) && msgCtx.getProperty(KEY_RAMPART_OUT_POLICY) != null) {
                    this.servicePolicy = this.servicePolicy == null ? (Policy)msgCtx.getProperty(KEY_RAMPART_OUT_POLICY) : this.servicePolicy.merge((Policy)msgCtx.getProperty(KEY_RAMPART_OUT_POLICY));
                }
                if (this.servicePolicy == null) {
                    try {
                        this.servicePolicy = msgCtx.getEffectivePolicy();
                    }
                    catch (NullPointerException e) {
                        if (axisService == null) break block29;
                        ArrayList policyList = new ArrayList();
                        policyList.addAll(axisService.getPolicySubject().getAttachedPolicyComponents());
                        AxisConfiguration axisConfiguration = axisService.getAxisConfiguration();
                        policyList.addAll(axisConfiguration.getPolicySubject().getAttachedPolicyComponents());
                        this.servicePolicy = PolicyUtil.getMergedPolicy(policyList, (AxisDescription)axisService);
                    }
                }
            }
            if (this.servicePolicy == null && (param = msgCtx.getParameter(KEY_RAMPART_POLICY)) != null) {
                OMElement policyElem = param.getParameterElement().getFirstElement();
                this.servicePolicy = PolicyEngine.getPolicy((OMElement)policyElem);
            }
            if (this.servicePolicy != null) {
                List it = (List)this.servicePolicy.getAlternatives().next();
                this.policyData = RampartPolicyBuilder.build(it);
                this.setWSSecurityVersions(this.policyData.getWebServiceSecurityPolicyNS());
            }
            if (this.policyData != null) {
                String wsaAction;
                RampartConfig policyDataRampartConfig;
                this.document = Axis2Util.getDocumentFromSOAPEnvelope(msgCtx.getEnvelope(), true);
                msgCtx.setEnvelope((SOAPEnvelope)this.document.getDocumentElement());
                this.soapConstants = WSSecurityUtil.getSOAPConstants((Element)this.document.getDocumentElement());
                RampartConfigCallbackHandler rampartConfigCallbackHandler = RampartUtil.getRampartConfigCallbackHandler(msgCtx, this.policyData);
                if (rampartConfigCallbackHandler != null) {
                    rampartConfigCallbackHandler.update(this.policyData.getRampartConfig());
                }
                if ((policyDataRampartConfig = this.policyData.getRampartConfig()) != null) {
                    String maxSkewString;
                    String timeToLiveString = policyDataRampartConfig.getTimestampTTL();
                    if (timeToLiveString != null && !timeToLiveString.equals("")) {
                        this.setTimeToLive(Integer.parseInt(timeToLiveString));
                    }
                    if ((maxSkewString = policyDataRampartConfig.getTimestampMaxSkew()) != null && !maxSkewString.equals("")) {
                        this.setTimestampMaxSkew(Integer.parseInt(maxSkewString));
                    }
                }
                if ("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT".equals(wsaAction = this.msgContext.getWSAAction()) || "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT".equals(wsaAction)) {
                    this.setTrustParameters();
                } else if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/SCT".equals(wsaAction) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/SCT".equals(wsaAction)) {
                    this.setTrustParameters();
                }
            }
            this.sender = sender;
            OperationContext opCtx = this.msgContext.getOperationContext();
            if (!this.isInitiator && this.sender && opCtx != null && (inMsgCtx = opCtx.getMessageContext("In")) != null && this.msgContext.getProperty("RECV_RESULTS") == null) {
                this.msgContext.setProperty("RECV_RESULTS", inMsgCtx.getProperty("RECV_RESULTS"));
                this.msgContext.setProperty(SCT_ID, inMsgCtx.getProperty(SCT_ID));
            }
            if (this.isInitiator && !this.sender && opCtx != null && (outMsgCtx = opCtx.getMessageContext("Out")) != null) {
                this.msgContext.setProperty(SCT_ID, outMsgCtx.getProperty(SCT_ID));
            }
            if (this.policyData != null && this.policyData.getRampartConfig() != null) {
                boolean timestampPrecisionInMilliseconds = this.policyData.getRampartConfig().isDefaultTimestampPrecisionInMs();
                boolean timestampStrict = this.policyData.getRampartConfig().isTimeStampStrict();
                this.config.setTimeStampStrict(timestampStrict);
                this.config.setPrecisionInMilliSeconds(timestampPrecisionInMilliseconds);
            }
            this.config.setHandleCustomPasswordTypes(true);
            if (axisService != null) {
                this.customClassLoader = axisService.getClassLoader();
            }
            if (this.sender && this.policyData != null) {
                this.secHeader = new WSSecHeader();
                this.secHeader.insertSecurityHeader(this.document);
            }
        }
        catch (AxisFault e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
        catch (WSSPolicyException e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
    }

    private void setWSSecurityVersions(String namespace) throws RampartException {
        if (namespace == null || namespace.equals("")) {
            throw new RampartException("Security policy namespace cannot be null.");
        }
        if ("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(namespace)) {
            this.wstVersion = 1;
            this.secConvVersion = 1;
        } else if ("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702".equals(namespace)) {
            this.wstVersion = 2;
            this.secConvVersion = 2;
        } else {
            throw new RampartException("Invalid namespace received, " + namespace);
        }
    }

    private void setTrustParameters() throws RampartException {
        if (this.policyData.getIssuerPolicy() == null) {
            return;
        }
        this.servicePolicy = this.policyData.getIssuerPolicy();
        RampartConfig rampartConfig = this.policyData.getRampartConfig();
        if (rampartConfig != null) {
            RampartConfig rc = new RampartConfig();
            rc.setEncrCryptoConfig(rampartConfig.getEncrCryptoConfig());
            rc.setSigCryptoConfig(rampartConfig.getSigCryptoConfig());
            rc.setDecCryptoConfig(rampartConfig.getDecCryptoConfig());
            rc.setUser(rampartConfig.getUser());
            rc.setUserCertAlias(rc.getUserCertAlias());
            rc.setEncryptionUser(rampartConfig.getEncryptionUser());
            rc.setPwCbClass(rampartConfig.getPwCbClass());
            rc.setSSLConfig(rampartConfig.getSSLConfig());
            this.servicePolicy.addAssertion((Assertion)rc);
        }
        List it = (List)this.servicePolicy.getAlternatives().next();
        try {
            this.policyData = RampartPolicyBuilder.build(it);
        }
        catch (WSSPolicyException e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getTimestampMaxSkew() {
        return this.timestampMaxSkew;
    }

    public void setTimestampMaxSkew(int timestampMaxSkew) {
        this.timestampMaxSkew = timestampMaxSkew;
    }

    public WSSConfig getConfig() {
        return this.config;
    }

    public void setConfig(WSSConfig config) {
        this.config = config;
    }

    public MessageContext getMsgContext() {
        return this.msgContext;
    }

    public RampartPolicyData getPolicyData() {
        return this.policyData;
    }

    public WSSecHeader getSecHeader() {
        return this.secHeader;
    }

    public void setSecHeader(WSSecHeader secHeader) {
        this.secHeader = secHeader;
    }

    public String getIssuedEncryptionTokenId() {
        return this.issuedEncryptionTokenId;
    }

    public void setIssuedEncryptionTokenId(String issuedEncryptionTokenId) {
        this.issuedEncryptionTokenId = issuedEncryptionTokenId;
    }

    public String getIssuedSignatureTokenId() {
        if (this.isInitiator) {
            return this.issuedSignatureTokenId;
        }
        List results = (List)this.msgContext.getProperty("RECV_RESULTS");
        for (WSHandlerResult result : results) {
            List wsSecEngineResults = result.getResults();
            for (WSSecurityEngineResult wsSecEngineResult : wsSecEngineResults) {
                Integer actInt = (Integer)wsSecEngineResult.get((Object)"action");
                if (8 != actInt) continue;
                Object assertion = wsSecEngineResult.get((Object)"saml-assertion");
                SAMLAssertionHandler samlAssertionHandler = SAMLAssertionHandlerFactory.createAssertionHandler(assertion);
                return samlAssertionHandler.getAssertionId();
            }
        }
        return null;
    }

    public void setIssuedSignatureTokenId(String issuedSignatureTokenId) {
        this.issuedSignatureTokenId = issuedSignatureTokenId;
    }

    public String getSecConvTokenId() {
        String id = null;
        if (this.isInitiator) {
            String contextIdentifierKey = RampartUtil.getContextIdentifierKey(this.msgContext);
            id = (String)RampartUtil.getContextMap(this.msgContext).get(contextIdentifierKey);
        } else {
            List results = (List)this.msgContext.getProperty("RECV_RESULTS");
            for (WSHandlerResult result : results) {
                List wsSecEngineResults = result.getResults();
                for (WSSecurityEngineResult wsSecEngineResult : wsSecEngineResults) {
                    Integer actInt = (Integer)wsSecEngineResult.get((Object)"action");
                    if (1024 != actInt) continue;
                    SecurityContextToken sct = (SecurityContextToken)wsSecEngineResult.get((Object)"security-context-token");
                    id = sct.getID();
                }
            }
        }
        if (id == null || id.length() == 0) {
            id = (String)this.msgContext.getProperty(SCT_ID);
        }
        return id;
    }

    public void setSecConvTokenId(String secConvTokenId) {
        String contextIdentifierKey = RampartUtil.getContextIdentifierKey(this.msgContext);
        RampartUtil.getContextMap(this.msgContext).put(contextIdentifierKey, secConvTokenId);
    }

    public TokenStorage getTokenStorage() throws RampartException {
        if (this.tokenStorage != null) {
            return this.tokenStorage;
        }
        TokenStorage storage = (TokenStorage)this.msgContext.getConfigurationContext().getProperty("org.apache.rahas.TokenStorage");
        if (storage != null) {
            this.tokenStorage = storage;
        } else {
            if (this.policyData.getRampartConfig() != null && this.policyData.getRampartConfig().getTokenStoreClass() != null) {
                Class stClass = null;
                String storageClass = this.policyData.getRampartConfig().getTokenStoreClass();
                try {
                    stClass = Loader.loadClass((ClassLoader)this.customClassLoader, (String)storageClass);
                }
                catch (ClassNotFoundException e) {
                    throw new RampartException("WSHandler: cannot load token storage class: " + storageClass, e);
                }
                try {
                    this.tokenStorage = (TokenStorage)stClass.newInstance();
                }
                catch (Exception e) {
                    throw new RampartException("Cannot create instance of token storage: " + storageClass, e);
                }
            }
            this.tokenStorage = new SimpleTokenStore();
            this.msgContext.getConfigurationContext().setProperty("org.apache.rahas.TokenStorage", (Object)this.tokenStorage);
        }
        return this.tokenStorage;
    }

    public void setTokenStorage(TokenStorage tokenStorage) {
        this.tokenStorage = tokenStorage;
    }

    public int getWstVersion() {
        return this.wstVersion;
    }

    public int getSecConvVersion() {
        return this.secConvVersion;
    }

    public Policy getServicePolicy() {
        return this.servicePolicy;
    }

    public String getTimestampId() {
        return this.timestampId;
    }

    public void setTimestampId(String timestampId) {
        this.timestampId = timestampId;
    }

    public boolean isInitiator() {
        return this.isInitiator;
    }

    public ClassLoader getCustomClassLoader() {
        return this.customClassLoader;
    }

    public SOAPConstants getSoapConstants() {
        return this.soapConstants;
    }
}

