/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.jaxp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.util.jaxp.SchemaResourceLSInput;
import org.apache.synapse.util.resolver.ResourceMap;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;

public class SchemaResourceResolver
implements LSResourceResolver {
    private ResourceMap resourceMap;
    private SynapseConfiguration synCfg;
    private static final Log log = LogFactory.getLog(SchemaResourceResolver.class);

    public SchemaResourceResolver(SynapseConfiguration synCfg, ResourceMap resourceMap) {
        this.resourceMap = resourceMap;
        this.synCfg = synCfg;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving Schema resource " + systemId));
        }
        if (this.resourceMap == null) {
            log.warn((Object)("Unable to resolve schema resource : \"" + systemId + "\". External schema resources not " + "defined in Validate mediator configuration"));
            return null;
        }
        InputSource inputSource = this.resourceMap.resolve(this.synCfg, systemId);
        if (inputSource == null) {
            log.warn((Object)("Unable to resolve schema resource " + systemId));
            return null;
        }
        SchemaResourceLSInput schemaResourceLSInput = new SchemaResourceLSInput();
        schemaResourceLSInput.setByteStream(inputSource.getByteStream());
        schemaResourceLSInput.setSystemId(systemId);
        schemaResourceLSInput.setPublicId(publicId);
        schemaResourceLSInput.setBaseURI(baseURI);
        return schemaResourceLSInput;
    }
}

