/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.SimpleMap;
import org.apache.synapse.util.SimpleMapImpl;

public class PayloadHelper {
    public static final String AXIOMPAYLOADNS = "http://ws.apache.org/commons/ns/payload";
    public static final QName BINARYELT = new QName("http://ws.apache.org/commons/ns/payload", "binary", "ax");
    public static final QName TEXTELT = new QName("http://ws.apache.org/commons/ns/payload", "text", "ax");
    public static final QName MAPELT = new QName("http://ws.apache.org/commons/ns/payload", "map", "ax");
    public static final int XMLPAYLOADTYPE = 0;
    public static final int BINARYPAYLOADTYPE = 1;
    public static final int TEXTPAYLOADTYPE = 2;
    public static final int MAPPAYLOADTYPE = 3;
    public static final Log log = LogFactory.getLog(PayloadHelper.class);

    public static int getPayloadType(SOAPEnvelope envelope) {
        OMElement el = PayloadHelper.getXMLPayload(envelope);
        if (el.getQName().equals(BINARYELT)) {
            return 1;
        }
        if (el.getQName().equals(TEXTELT)) {
            return 2;
        }
        if (el.getQName().equals(MAPELT)) {
            return 3;
        }
        return 0;
    }

    public static int getPayloadType(MessageContext mc) {
        if (mc.getEnvelope() == null) {
            return 0;
        }
        return PayloadHelper.getPayloadType(mc.getEnvelope());
    }

    public static OMElement getXMLPayload(SOAPEnvelope envelope) {
        SOAPBody body = envelope.getBody();
        if (body == null) {
            log.error((Object)"No body found");
            return null;
        }
        OMElement bodyEl = body.getFirstElement();
        if (bodyEl == null) {
            log.error((Object)"No body child found");
            return null;
        }
        return bodyEl;
    }

    public static void setXMLPayload(SOAPEnvelope envelope, OMElement element) {
        SOAPBody body = envelope.getBody();
        if (body == null) {
            SOAPVersion version = envelope.getVersion();
            body = version.getEnvelopeURI().equals("http://schemas.xmlsoap.org/soap/envelope/") ? OMAbstractFactory.getSOAP11Factory().createSOAPBody() : OMAbstractFactory.getSOAP12Factory().createSOAPBody();
            if (envelope.getHeader() != null) {
                envelope.getHeader().insertSiblingAfter((OMNode)body);
            } else {
                envelope.addChild((OMNode)body);
            }
        } else {
            body.removeChildren();
        }
        body.addChild((OMNode)element);
    }

    public static void setXMLPayload(MessageContext mc, OMElement element) {
        if (mc.getEnvelope() == null) {
            try {
                mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
            }
            catch (Exception e) {
                throw new SynapseException(e);
            }
        }
        PayloadHelper.setXMLPayload(mc.getEnvelope(), element);
    }

    public static DataHandler getBinaryPayload(SOAPEnvelope envelope) {
        OMElement el = PayloadHelper.getXMLPayload(envelope);
        if (el == null) {
            return null;
        }
        if (!el.getQName().equals(BINARYELT)) {
            log.error((Object)("Wrong QName" + el.getQName()));
            return null;
        }
        OMNode textNode = el.getFirstOMChild();
        if (textNode.getType() != 4) {
            log.error((Object)"Text Node not found");
            return null;
        }
        OMText text = (OMText)textNode;
        try {
            return (DataHandler)text.getDataHandler();
        }
        catch (ClassCastException ce) {
            log.error((Object)("cannot get DataHandler" + ce.getMessage()));
            return null;
        }
    }

    public static DataHandler getBinaryPayload(MessageContext mc) {
        if (mc.getEnvelope() == null) {
            log.error((Object)"null envelope");
            return null;
        }
        return PayloadHelper.getBinaryPayload(mc.getEnvelope());
    }

    public static void setBinaryPayload(SOAPEnvelope envelope, DataHandler dh) {
        OMFactory fac = envelope.getOMFactory();
        OMElement binaryElt = envelope.getOMFactory().createOMElement(BINARYELT);
        OMText text = fac.createOMText((Object)dh, true);
        binaryElt.addChild((OMNode)text);
        PayloadHelper.setXMLPayload(envelope, binaryElt);
    }

    public static void setBinaryPayload(MessageContext mc, DataHandler dh) {
        if (mc.getEnvelope() == null) {
            try {
                mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
            }
            catch (Exception e) {
                throw new SynapseException(e);
            }
        }
        PayloadHelper.setBinaryPayload(mc.getEnvelope(), dh);
    }

    public static String getTextPayload(SOAPEnvelope envelope) {
        OMElement el = PayloadHelper.getXMLPayload(envelope);
        if (el == null) {
            return null;
        }
        if (!el.getQName().equals(TEXTELT)) {
            log.error((Object)("Wrong QName " + el.getQName()));
            return null;
        }
        OMNode textNode = el.getFirstOMChild();
        if (textNode.getType() != 4) {
            log.error((Object)"Text Node not found");
            return null;
        }
        return el.getText();
    }

    public static String getTextPayload(MessageContext mc) {
        if (mc.getEnvelope() == null) {
            log.error((Object)"null envelope");
            return null;
        }
        return PayloadHelper.getTextPayload(mc.getEnvelope());
    }

    public static void setTextPayload(SOAPEnvelope envelope, String text) {
        OMFactory fac = envelope.getOMFactory();
        OMElement textElt = envelope.getOMFactory().createOMElement(TEXTELT);
        OMText textNode = fac.createOMText(text);
        textElt.addChild((OMNode)textNode);
        PayloadHelper.setXMLPayload(envelope, textElt);
    }

    public static void setTextPayload(MessageContext mc, String text) {
        if (mc.getEnvelope() == null) {
            try {
                mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
            }
            catch (Exception e) {
                throw new SynapseException(e);
            }
        }
        PayloadHelper.setTextPayload(mc.getEnvelope(), text);
    }

    public static SimpleMap getMapPayload(SOAPEnvelope envelope) {
        OMElement el = PayloadHelper.getXMLPayload(envelope);
        if (el == null) {
            return null;
        }
        if (!el.getQName().equals(MAPELT)) {
            log.error((Object)("Wrong QName" + el.getQName()));
            return null;
        }
        return new SimpleMapImpl(el);
    }

    public static SimpleMap getMapPayload(MessageContext mc) {
        if (mc.getEnvelope() == null) {
            log.error((Object)"null envelope");
            return null;
        }
        return PayloadHelper.getMapPayload(mc.getEnvelope());
    }

    public static void setMapPayload(SOAPEnvelope envelope, SimpleMap map) {
        OMElement mapElt;
        if (map instanceof SimpleMapImpl) {
            SimpleMapImpl impl = (SimpleMapImpl)map;
            mapElt = impl.getOMElement(envelope.getOMFactory());
            if (mapElt == null) {
                log.debug((Object)"null map element returned");
                return;
            }
        } else {
            throw new SynapseException("cannot handle any other instance of SimpleMap at this point TODO");
        }
        PayloadHelper.setXMLPayload(envelope, mapElt);
    }

    public static void setMapPayload(MessageContext mc, SimpleMap map) {
        if (mc.getEnvelope() == null) {
            try {
                mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
            }
            catch (Exception e) {
                throw new SynapseException(e);
            }
        }
        PayloadHelper.setMapPayload(mc.getEnvelope(), map);
    }

    public static XMLStreamReader getStAXPayload(SOAPEnvelope envelope) {
        OMElement el = PayloadHelper.getXMLPayload(envelope);
        if (el == null) {
            return null;
        }
        return el.getXMLStreamReader();
    }

    public static XMLStreamReader getStAXPayload(MessageContext mc) {
        if (mc.getEnvelope() == null) {
            log.error((Object)"null envelope");
            return null;
        }
        return PayloadHelper.getStAXPayload(mc.getEnvelope());
    }

    public static void setStAXPayload(SOAPEnvelope envelope, XMLStreamReader streamReader) {
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)envelope.getOMFactory(), (XMLStreamReader)streamReader);
        OMElement el = builder.getDocumentElement();
        PayloadHelper.setXMLPayload(envelope, el);
    }

    public static void setStAXPayload(MessageContext mc, XMLStreamReader streamReader) {
        if (mc.getEnvelope() == null) {
            try {
                mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
            }
            catch (Exception e) {
                throw new SynapseException(e);
            }
            PayloadHelper.setStAXPayload(mc.getEnvelope(), streamReader);
        }
    }
}

