/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.libraries.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.deployers.SynapseArtifactDeploymentException;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.model.LibraryArtifact;
import org.apache.synapse.libraries.model.SynapseLibrary;

public class LibDeployerUtils {
    public static final String APP_UNZIP_DIR;
    private static final Log log;

    public static Library createSynapseLibrary(String libPath) {
        LibDeployerUtils.createDir(APP_UNZIP_DIR);
        String libFilePath = LibDeployerUtils.formatPath(libPath);
        String extractPath = LibDeployerUtils.extractSynapseLib(libFilePath);
        SynapseLibrary synapseLib = LibDeployerUtils.populateDependencies(extractPath + "artifacts.xml");
        try {
            ClassLoader libLoader = Utils.getClassLoader((ClassLoader)LibDeployerUtils.class.getClassLoader(), (String)extractPath, (boolean)false);
            synapseLib.setLibClassLoader(libLoader);
        }
        catch (DeploymentException e) {
            throw new SynapseArtifactDeploymentException("Error setting up lib classpath for Synapse Library  : " + libFilePath, e);
        }
        LibDeployerUtils.searchAndResolveDependencies(extractPath, synapseLib);
        return synapseLib;
    }

    private static SynapseLibrary populateDependencies(String libXmlPath) {
        File f = new File(libXmlPath);
        if (!f.exists()) {
            throw new SynapseException("artifacts.xml file not found at : " + libXmlPath);
        }
        FileInputStream xmlInputStream = null;
        try {
            xmlInputStream = new FileInputStream(f);
            OMElement documentElement = OMXMLBuilderFactory.createOMBuilder((InputStream)xmlInputStream).getDocumentElement();
            if (documentElement == null) {
                throw new SynapseArtifactDeploymentException("Document element for artifacts.xml is null. Can't build the synapse library configuration");
            }
            Iterator artifactItr = documentElement.getChildrenWithLocalName("artifact");
            SynapseLibrary mainSynLibArtifact = null;
            mainSynLibArtifact = LibDeployerUtils.createSynapseLibraryWithDeps((OMElement)artifactItr.next());
            if (mainSynLibArtifact == null) {
                throw new SynapseArtifactDeploymentException("artifacts.xml is invalid. <artifact> element Not Found ");
            }
            SynapseLibrary synapseLibrary = mainSynLibArtifact;
            return synapseLibrary;
        }
        catch (FileNotFoundException e) {
            throw new SynapseArtifactDeploymentException("artifacts.xml File cannot be loaded from " + libXmlPath, e);
        }
        catch (OMException e) {
            throw new SynapseArtifactDeploymentException("Error while parsing the artifacts.xml file ", e);
        }
        finally {
            if (xmlInputStream != null) {
                try {
                    ((InputStream)xmlInputStream).close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing input stream.", (Throwable)e);
                }
            }
        }
    }

    private static SynapseLibrary createSynapseLibraryWithDeps(OMElement artifactEle) {
        if (artifactEle == null) {
            return null;
        }
        SynapseLibrary synLib = new SynapseLibrary(LibDeployerUtils.readAttribute(artifactEle, "name"), LibDeployerUtils.readAttribute(artifactEle, "package"));
        synLib.setDescription(LibDeployerUtils.readChildText(artifactEle, "description"));
        Iterator itr = artifactEle.getChildrenWithLocalName("dependency");
        while (itr.hasNext()) {
            OMElement depElement = (OMElement)itr.next();
            LibraryArtifact.Dependency dep = new LibraryArtifact.Dependency(LibDeployerUtils.readAttribute(depElement, "artifact"));
            synLib.addDependency(dep);
        }
        return synLib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void searchAndResolveDependencies(String rootDirPath, SynapseLibrary library) {
        ArrayList<LibraryArtifact> libraryArtifacts = new ArrayList<LibraryArtifact>();
        File extractedDir = new File(rootDirPath);
        File[] allFiles = extractedDir.listFiles();
        if (allFiles == null) {
            return;
        }
        for (File artifactDirectory : allFiles) {
            String directoryPath;
            String artifactXmlPath;
            File f;
            if (!artifactDirectory.isDirectory() || !(f = new File(artifactXmlPath = (directoryPath = LibDeployerUtils.formatPath(artifactDirectory.getAbsolutePath())) + File.separator + "artifact.xml")).exists()) continue;
            LibraryArtifact artifact = null;
            FileInputStream xmlInputStream = null;
            try {
                xmlInputStream = new FileInputStream(f);
                artifact = LibDeployerUtils.buildArtifact(library, xmlInputStream, directoryPath);
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("Error while resolving synapse lib dir :" + artifactDirectory.getName() + " artifacts.xml File cannot be loaded " + "from " + artifactXmlPath), (Throwable)e);
            }
            catch (Exception e) {
                log.warn((Object)("Error ocurred while resolving synapse lib dir :" + artifactDirectory.getName() + " for artifacts.xml path" + artifactXmlPath), (Throwable)e);
            }
            finally {
                if (xmlInputStream != null) {
                    try {
                        ((InputStream)xmlInputStream).close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while closing input stream.", (Throwable)e);
                    }
                }
            }
            if (artifact == null) {
                log.warn((Object)("Could not build lib artifact for path : " + directoryPath + " Synapse Library :" + library.getQName() + ". Continue searching for other lib artifacts"));
                continue;
            }
            libraryArtifacts.add(artifact);
        }
        boolean isDepsResolved = library.resolveDependencies(libraryArtifacts);
        if (!isDepsResolved) {
            throw new SynapseArtifactDeploymentException("Error when resolving Dependencies for lib : " + library.toString());
        }
    }

    private static LibraryArtifact buildArtifact(SynapseLibrary library, InputStream artifactXmlStream, String directoryPath) {
        LibraryArtifact artifact = null;
        try {
            OMElement artElement = OMXMLBuilderFactory.createOMBuilder((InputStream)artifactXmlStream).getDocumentElement();
            if (!"artifact".equals(artElement.getLocalName())) {
                log.error((Object)("artifact.xml is invalid. Error occurred while resolving Synapse Library : " + library.getQName()));
                return null;
            }
            artifact = LibDeployerUtils.populateLibraryArtifact(artElement, directoryPath, null, library);
        }
        catch (OMException e) {
            throw new SynapseArtifactDeploymentException("Error parsing artifact.xml for path : " + directoryPath, e);
        }
        if (artifact == null || artifact.getName() == null) {
            log.error((Object)("Invalid artifact found in Synapse Library : " + library.getQName()));
            return null;
        }
        return artifact;
    }

    private static LibraryArtifact populateLibraryArtifact(OMElement artifactEle, String artifactPath, LibraryArtifact parent, SynapseLibrary library) {
        if (artifactEle == null || artifactPath == null) {
            return null;
        }
        LibraryArtifact artifact = new LibraryArtifact(LibDeployerUtils.readAttribute(artifactEle, "name"));
        artifact.setParent(parent);
        artifact.setType(LibDeployerUtils.readAttribute(artifactEle, "type"));
        artifact.setPath(artifactPath);
        artifact.setDescription(LibDeployerUtils.readChildText(artifactEle, "description"));
        library.addArtifactDescription(artifact);
        OMElement subArtifactsElement = artifactEle.getFirstChildWithName(new QName("subArtifacts"));
        if (subArtifactsElement != null) {
            Iterator subArtItr = subArtifactsElement.getChildrenWithLocalName("artifact");
            while (subArtItr.hasNext()) {
                LibraryArtifact subArtifact = LibDeployerUtils.populateLibraryArtifact((OMElement)subArtItr.next(), artifactPath, artifact, library);
                artifact.addSubArtifact(subArtifact);
            }
        }
        Iterator fileItr = artifactEle.getChildrenWithLocalName("file");
        while (fileItr.hasNext()) {
            OMElement fileElement = (OMElement)fileItr.next();
            artifact.setupFile(fileElement.getText());
        }
        return artifact;
    }

    public static void loadLibArtifacts(SynapseImport synImport, Library library) {
        if (synImport.getLibName().equals(library.getQName().getLocalPart()) && synImport.getLibPackage().equals(library.getPackage())) {
            library.loadLibrary();
        }
    }

    public static <T> T getLibArtifact(Map<String, Library> librarySet, String key, Class<T> type) {
        for (Library synapseLibrary : librarySet.values()) {
            try {
                Object artifact = synapseLibrary.getArtifact(key);
                if (artifact == null) continue;
                return (T)artifact;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static String getQualifiedName(SynapseImport synImport) {
        return new QName(synImport.getLibPackage(), synImport.getLibName()).toString();
    }

    public static String readAttribute(OMElement element, String attName) {
        if (element == null) {
            return null;
        }
        OMAttribute temp = element.getAttribute(new QName(attName));
        if (temp != null) {
            return temp.getAttributeValue();
        }
        return null;
    }

    public static String readChildText(OMElement element, String ln) {
        return LibDeployerUtils.readChildText(element, ln, null);
    }

    public static String readChildText(OMElement element, String ln, String ns) {
        if (element == null) {
            return null;
        }
        OMElement temp = element.getFirstChildWithName(new QName(ns, ln));
        if (temp != null) {
            return temp.getText();
        }
        return null;
    }

    public static String extractSynapseLib(String libPath) throws SynapseException {
        libPath = LibDeployerUtils.formatPath(libPath);
        String fileName = libPath.substring(libPath.lastIndexOf(47) + 1);
        String dest = APP_UNZIP_DIR + File.separator + System.currentTimeMillis() + fileName + File.separator;
        LibDeployerUtils.createDir(dest);
        try {
            LibDeployerUtils.extract(libPath, dest);
        }
        catch (IOException e) {
            throw new SynapseException("Error while extracting Synapse Library : " + fileName, e);
        }
        return dest;
    }

    public static String formatPath(String path) {
        path = path.replaceAll("\\b\\s+\\b", "%20");
        return path.replace('\\', '/');
    }

    private static void extract(String sourcePath, String destPath) throws IOException {
        ZipFile zipFile = new ZipFile(sourcePath);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.getName().startsWith("META-INF/") || entry.isDirectory()) continue;
            File dest = new File(destPath, entry.getName());
            dest.getParentFile().mkdirs();
            LibDeployerUtils.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(dest)));
        }
        zipFile.close();
    }

    public static void createDir(String path) {
        File temp = new File(path);
        if (!temp.exists() && !temp.mkdir()) {
            log.error((Object)("Error while creating directory : " + path));
        }
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[40960];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static void main(String[] args) {
        new SynapseLibrary(null, null).resolveDependencies(null);
    }

    static {
        String javaTempDir = System.getProperty("java.io.tmpdir");
        APP_UNZIP_DIR = javaTempDir.endsWith(File.separator) ? javaTempDir + "libs" : javaTempDir + File.separator + "libs";
        LibDeployerUtils.createDir(APP_UNZIP_DIR);
        log = LogFactory.getLog(LibDeployerUtils.class);
    }
}

