/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorSerializer;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.ConfigurationSerializer;
import org.apache.synapse.config.xml.EntrySerializer;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.MessageProcessorSerializer;
import org.apache.synapse.config.xml.MessageStoreSerializer;
import org.apache.synapse.config.xml.ProxyServiceSerializer;
import org.apache.synapse.config.xml.RegistrySerializer;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.XMLConfigurationSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.config.xml.endpoints.TemplateSerializer;
import org.apache.synapse.config.xml.eventing.EventSourceSerializer;
import org.apache.synapse.config.xml.rest.APISerializer;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.apache.synapse.message.processors.MessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.rest.API;

public class SynapseXMLConfigurationSerializer
implements ConfigurationSerializer {
    private static final Log log = LogFactory.getLog(XMLConfigurationSerializer.class);
    private static final OMFactory fac = OMAbstractFactory.getOMFactory();
    private static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;

    @Override
    public OMElement serializeConfiguration(SynapseConfiguration synCfg) {
        OMElement definitions = fac.createOMElement("definitions", synNS);
        if (synCfg.getDescription() != null) {
            OMElement descElem = fac.createOMElement("description", synNS);
            descElem.setText(synCfg.getDescription());
            definitions.addChild((OMNode)descElem);
        }
        if (synCfg.getRegistry() != null) {
            RegistrySerializer.serializeRegistry(definitions, synCfg.getRegistry());
        }
        for (ProxyService service : synCfg.getProxyServices()) {
            ProxyServiceSerializer.serializeProxy(definitions, service);
        }
        for (SynapseEventSource eventSource : synCfg.getEventSources()) {
            EventSourceSerializer.serializeEventSource(definitions, eventSource);
        }
        HashMap<String, Entry> entries = new HashMap<String, Entry>();
        HashMap<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
        HashMap<String, SequenceMediator> sequences = new HashMap<String, SequenceMediator>();
        HashMap<String, TemplateMediator> templates = new HashMap<String, TemplateMediator>();
        HashMap<String, Template> endpointTemplates = new HashMap<String, Template>();
        for (ProxyService key : synCfg.getLocalRegistry().keySet()) {
            if ("SERVER_IP".equals(key) || "SERVER_HOST".equals(key)) continue;
            Object o = synCfg.getLocalRegistry().get(key);
            if (o instanceof TemplateMediator) {
                templates.put(((Object)key).toString(), (TemplateMediator)o);
                continue;
            }
            if (o instanceof SequenceMediator) {
                sequences.put(((Object)key).toString(), (SequenceMediator)o);
                continue;
            }
            if (o instanceof Endpoint) {
                endpoints.put(((Object)key).toString(), (Endpoint)o);
                continue;
            }
            if (o instanceof Template) {
                endpointTemplates.put(((Object)key).toString(), (Template)o);
                continue;
            }
            if (o instanceof Entry) {
                entries.put(((Object)key).toString(), (Entry)o);
                continue;
            }
            SynapseXMLConfigurationSerializer.handleException("Unknown object : " + o.getClass() + " for serialization into Synapse configuration");
        }
        SynapseXMLConfigurationSerializer.serializeEntries(definitions, entries);
        SynapseXMLConfigurationSerializer.serializeEndpoints(definitions, endpoints);
        SynapseXMLConfigurationSerializer.serializeSequences(definitions, sequences);
        SynapseXMLConfigurationSerializer.serializeMediatorTemplates(definitions, templates);
        SynapseXMLConfigurationSerializer.serializeEndpointTemplates(definitions, endpointTemplates);
        SynapseXMLConfigurationSerializer.serializeStartups(definitions, synCfg.getStartups());
        SynapseXMLConfigurationSerializer.serializeExecutors(definitions, synCfg.getPriorityExecutors());
        SynapseXMLConfigurationSerializer.serializeMessageStores(definitions, synCfg.getMessageStores());
        SynapseXMLConfigurationSerializer.serializeMessageProcessors(definitions, synCfg.getMessageProcessors());
        SynapseXMLConfigurationSerializer.serializeAPIs(definitions, synCfg.getAPIs());
        return definitions;
    }

    private static void serializeEntries(OMElement definitions, Map<String, Entry> entries) {
        for (Entry entry : entries.values()) {
            EntrySerializer.serializeEntry(entry, definitions);
        }
    }

    private static void serializeStartups(OMElement definitions, Collection startups) {
        for (Object o : startups) {
            if (!(o instanceof Startup)) continue;
            Startup s = (Startup)o;
            StartupFinder.getInstance().serializeStartup(definitions, s);
        }
    }

    private static void serializeEndpoints(OMElement definitions, Map<String, Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints.values()) {
            definitions.addChild((OMNode)EndpointSerializer.getElementFromEndpoint(endpoint));
        }
    }

    private static void serializeSequences(OMElement definitions, Map<String, SequenceMediator> sequences) {
        for (SequenceMediator seq : sequences.values()) {
            MediatorSerializerFinder.getInstance().getSerializer(seq).serializeMediator(definitions, seq);
        }
    }

    private static void serializeMediatorTemplates(OMElement definitions, Map<String, TemplateMediator> eipSequences) {
        for (TemplateMediator template : eipSequences.values()) {
            MediatorSerializerFinder.getInstance().getSerializer(template).serializeMediator(definitions, template);
        }
    }

    private static void serializeExecutors(OMElement definitions, Map<String, PriorityExecutor> executors) {
        for (PriorityExecutor exec : executors.values()) {
            PriorityExecutorSerializer.serialize((OMElement)definitions, (PriorityExecutor)exec, (String)"http://ws.apache.org/ns/synapse");
        }
    }

    private static void serializeMessageStores(OMElement definitions, Map<String, MessageStore> messageStores) {
        for (MessageStore ms : messageStores.values()) {
            MessageStoreSerializer.serializeMessageStore(definitions, ms);
        }
    }

    private static void serializeMessageProcessors(OMElement definitions, Map<String, MessageProcessor> processorMap) {
        for (MessageProcessor mp : processorMap.values()) {
            MessageProcessorSerializer.serializeMessageProcessor(definitions, mp);
        }
    }

    private static void serializeEndpointTemplates(OMElement definitions, Map<String, Template> templateMap) {
        for (Template template : templateMap.values()) {
            TemplateSerializer serializer = new TemplateSerializer();
            serializer.serializeEndpointTemplate(template, definitions);
        }
    }

    private static void serializeAPIs(OMElement definitions, Collection<API> apiSet) {
        for (API api : apiSet) {
            OMElement apiElt = APISerializer.serializeAPI(api);
            definitions.addChild((OMNode)apiElt);
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    @Override
    public QName getTagQName() {
        return XMLConfigConstants.DEFINITIONS_ELT;
    }
}

