/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.snmp;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.snmp.SynapseMIBUtils;
import org.apache.synapse.commons.snmp.SynapseMOScalar;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.TransportMappings;

class SNMPAgent
extends BaseAgent {
    private static final Log log = LogFactory.getLog(SNMPAgent.class);
    private static final String FULL_READ_VIEW = "fullReadView";
    private static final String GROUP_NAME = "synapseSNMPGroup";
    private static final String COMMUNITY_RECORD = "public2public";
    private Properties properties;
    private Set<OID> registeredOIDs = new HashSet<OID>();
    private int snmpVersion;

    public SNMPAgent(Properties properties) {
        super(new File("./logs/snmp/boot-counter.cfg"), new File("./logs/snmp/conf.cfg"), new CommandProcessor(new OctetString(MPv3.createLocalEngineID())));
        this.properties = properties;
        String version = this.getProperty("synapse.snmp.version", "snmpv1");
        if ("snmpv1".equals(version)) {
            this.snmpVersion = 0;
        } else if ("snmpv2c".equals(version)) {
            this.snmpVersion = 1;
        } else {
            log.warn((Object)("Unsupported SNMP version: " + version + " - Using defaults"));
            this.snmpVersion = 0;
        }
    }

    public void start() throws IOException {
        String context = this.getProperty("synapse.snmp.context.name", "public");
        this.init();
        this.loadConfig(1);
        this.addShutdownHook();
        this.getServer().addContext(new OctetString(context));
        this.finishInit();
        this.run();
        this.sendColdStartNotification();
    }

    protected void initTransportMappings() throws IOException {
        String host = this.getProperty("synapse.snmp.host", "127.0.0.1");
        int port = Integer.parseInt(this.getProperty("synapse.snmp.port", String.valueOf(9161)));
        String address = host + "/" + port;
        Address adr = GenericAddress.parse((String)address);
        TransportMapping tm = TransportMappings.getInstance().createTransportMapping(adr);
        this.transportMappings = new TransportMapping[]{tm};
        log.info((Object)("SNMP transport adapter initialized on udp:" + address));
    }

    protected void registerManagedObjects() {
        log.info((Object)"Initializing Synapse SNMP MIB");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectInstance> instances = mbs.queryMBeans(null, null);
        try {
            for (ObjectInstance instance : instances) {
                String oidString;
                ObjectName objectName = instance.getObjectName();
                if (!objectName.getDomain().equals("org.apache.synapse") || (oidString = SynapseMIBUtils.getOID(objectName)) == null) continue;
                MBeanInfo info = mbs.getMBeanInfo(objectName);
                MBeanAttributeInfo[] attributes = info.getAttributes();
                ArrayList<String> attributeNames = new ArrayList<String>();
                ArrayList<String> mapAttributes = new ArrayList<String>();
                for (MBeanAttributeInfo attributeInfo : attributes) {
                    attributeNames.add(attributeInfo.getName());
                    if (!Map.class.getName().equals(attributeInfo.getType())) continue;
                    mapAttributes.add(attributeInfo.getName());
                }
                Collections.sort(attributeNames);
                this.doRegister(attributeNames, mapAttributes, oidString, objectName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing the SNMP MIB", (Throwable)e);
        }
    }

    private void doRegister(List<String> attributeNames, List<String> mapAttributes, String oidString, ObjectName objectName) {
        for (int i = 0; i < attributeNames.size(); ++i) {
            String attributeName = attributeNames.get(i);
            if (mapAttributes.contains(attributeName)) continue;
            OID oid = new OID(oidString + "." + (i + 1) + ".0");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registering " + objectName + "@" + attributeName + " as OID: " + oid));
            }
            try {
                this.server.register((ManagedObject)new SynapseMOScalar(oid, objectName, attributeName, this.snmpVersion), null);
                this.registeredOIDs.add(oid);
                continue;
            }
            catch (DuplicateRegistrationException e) {
                log.error((Object)("Error while registering the OID: " + oid + " for object: " + objectName + " and attribute: " + attributeName), (Throwable)e);
            }
        }
    }

    protected void unregisterManagedObjects() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cleaning up registered OIDs");
        }
        for (OID oid : this.registeredOIDs) {
            ManagedObject mo = this.server.getManagedObject(oid, null);
            if (mo == null) continue;
            this.server.unregister(mo, null);
        }
        this.registeredOIDs.clear();
    }

    protected void addUsmUser(USM usm) {
    }

    protected void addNotificationTargets(SnmpTargetMIB snmpTargetMIB, SnmpNotificationMIB snmpNotificationMIB) {
    }

    protected void addViews(VacmMIB vacm) {
        String communityString = this.getProperty("synapse.snmp.community.name", "public");
        String securityName = this.getProperty("synapse.snmp.security.name", "cpublic");
        int securityModel = 1;
        if (this.snmpVersion == 1) {
            securityModel = 2;
        }
        vacm.addGroup(securityModel, new OctetString(securityName), new OctetString(GROUP_NAME), 3);
        vacm.addAccess(new OctetString(GROUP_NAME), new OctetString(communityString), securityModel, 1, 1, new OctetString(FULL_READ_VIEW), new OctetString(), new OctetString(), 3);
        vacm.addViewTreeFamily(new OctetString(FULL_READ_VIEW), new OID("1.3.6.1.4.1.18060.14"), new OctetString(), 1, 3);
    }

    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        String community = this.getProperty("synapse.snmp.community.name", "public");
        String securityName = this.getProperty("synapse.snmp.security.name", "cpublic");
        String context = this.getProperty("synapse.snmp.context.name", "public");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering SNMP community string: " + community + " under the " + "context: " + context));
        }
        Variable[] com2sec = new Variable[]{new OctetString(community), new OctetString(securityName), this.getAgent().getContextEngineID(), new OctetString(context), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row = communityMIB.getSnmpCommunityEntry().createRow(new OctetString(COMMUNITY_RECORD).toSubIndex(true), com2sec);
        communityMIB.getSnmpCommunityEntry().addRow(row);
    }

    private String getProperty(String name, String def) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            value = def;
        }
        return value;
    }
}

