/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyGenerator;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyYielder;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Enumerable::Enumerator"}, include={"Enumerable"})
public class RubyEnumerator
extends RubyObject {
    private IRubyObject object;
    private IRubyObject method;
    private IRubyObject[] methodArgs;
    private static ObjectAllocator ENUMERATOR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyEnumerator(runtime2, klass);
        }
    };

    public static void defineEnumerator(Ruby runtime2) {
        runtime2.getKernel().defineAnnotatedMethods(RubyEnumeratorKernel.class);
        RubyModule enm = runtime2.getClassFromPath("Enumerable");
        enm.defineAnnotatedMethods(RubyEnumeratorEnumerable.class);
        RubyClass enmr = runtime2.is1_9() ? runtime2.defineClass("Enumerator", runtime2.getObject(), ENUMERATOR_ALLOCATOR) : enm.defineClassUnder("Enumerator", runtime2.getObject(), ENUMERATOR_ALLOCATOR);
        enmr.includeModule(enm);
        enmr.defineAnnotatedMethods(RubyEnumerator.class);
        runtime2.setEnumerator(enmr);
        if (runtime2.is1_9()) {
            RubyGenerator.createGeneratorClass(runtime2);
            RubyYielder.createYielderClass(runtime2);
        }
    }

    private RubyEnumerator(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.object = this.method = runtime2.getNil();
    }

    private RubyEnumerator(Ruby runtime2, IRubyObject object, IRubyObject method2, IRubyObject[] args2) {
        super(runtime2, runtime2.getEnumerator());
        this.object = object;
        this.method = method2;
        this.methodArgs = args2;
    }

    static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2) {
        return new RubyEnumerator(runtime2, object, runtime2.fastNewSymbol(method2), IRubyObject.NULL_ARRAY);
    }

    static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2, IRubyObject arg2) {
        return new RubyEnumerator(runtime2, object, runtime2.fastNewSymbol(method2), new IRubyObject[]{arg2});
    }

    static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2, IRubyObject[] args2) {
        return new RubyEnumerator(runtime2, object, runtime2.fastNewSymbol(method2), args2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        throw context.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg2) {
        this.object = arg2;
        this.method = context.getRuntime().fastNewSymbol("each");
        this.methodArgs = NULL_ARRAY;
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        this.object = arg0;
        this.method = arg1;
        this.methodArgs = NULL_ARRAY;
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.object = arg0;
        this.method = arg1;
        this.methodArgs = new IRubyObject[]{arg2};
        return this;
    }

    @JRubyMethod(name={"initialize"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        this.object = args2[0];
        this.method = args2[1];
        this.methodArgs = new IRubyObject[args2.length - 2];
        System.arraycopy(args2, 2, this.methodArgs, 0, this.methodArgs.length);
        return this;
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext context, Block block) {
        return this.object.callMethod(context, this.method.asJavaString(), this.methodArgs, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject inspect19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isInspecting(this)) {
            return this.inspect(context, true);
        }
        try {
            runtime2.registerInspecting(this);
            IRubyObject iRubyObject = this.inspect(context, false);
            return iRubyObject;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    private IRubyObject inspect(ThreadContext context, boolean recurse) {
        Ruby runtime2 = context.getRuntime();
        ByteList bytes2 = new ByteList();
        bytes2.append((byte)35).append((byte)60);
        bytes2.append(this.getMetaClass().getName().getBytes());
        bytes2.append((byte)58).append((byte)32);
        if (recurse) {
            bytes2.append("...>".getBytes());
            return RubyString.newStringNoCopy(runtime2, bytes2).taint(context);
        }
        boolean tainted = this.isTaint();
        bytes2.append(RubyObject.inspect(context, this.object).getByteList());
        bytes2.append((byte)58);
        bytes2.append(this.method.asString().getByteList());
        if (this.methodArgs.length > 0) {
            bytes2.append((byte)40);
            for (int i = 0; i < this.methodArgs.length; ++i) {
                bytes2.append(RubyObject.inspect(context, this.methodArgs[i]).getByteList());
                if (i < this.methodArgs.length - 1) {
                    bytes2.append((byte)44).append((byte)32);
                } else {
                    bytes2.append((byte)41);
                }
                if (!this.methodArgs[i].isTaint()) continue;
                tainted = true;
            }
        }
        bytes2.append((byte)62);
        RubyString result = RubyString.newStringNoCopy(runtime2, bytes2);
        if (tainted) {
            result.setTaint(true);
        }
        return result;
    }

    public static final class RubyEnumeratorEnumerable {
        @JRubyMethod(name={"each_slice"}, frame=true, compat=CompatVersion.RUBY1_8)
        public static IRubyObject each_slice(ThreadContext context, IRubyObject self, IRubyObject arg2, final Block block) {
            final int size2 = RubyNumeric.num2int(arg2);
            final Ruby runtime2 = self.getRuntime();
            if (size2 <= 0) {
                throw runtime2.newArgumentError("invalid slice size");
            }
            final RubyArray[] result = new RubyArray[]{runtime2.newArray(size2)};
            RubyEnumerable.callEach(runtime2, context, self, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    result[0].append(largs[0]);
                    if (result[0].size() == size2) {
                        block.yield(ctx, result[0]);
                        result[0] = runtime2.newArray(size2);
                    }
                    return runtime2.getNil();
                }
            });
            if (result[0].size() > 0) {
                block.yield(context, result[0]);
            }
            return self.getRuntime().getNil();
        }

        @JRubyMethod(name={"each_slice"}, compat=CompatVersion.RUBY1_9)
        public static IRubyObject each_slice19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return block.isGiven() ? RubyEnumeratorEnumerable.each_slice(context, self, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "each_slice", arg2);
        }

        @JRubyMethod(name={"each_cons"}, frame=true, compat=CompatVersion.RUBY1_8)
        public static IRubyObject each_cons(ThreadContext context, IRubyObject self, IRubyObject arg2, final Block block) {
            final int size2 = (int)RubyNumeric.num2long(arg2);
            final Ruby runtime2 = self.getRuntime();
            if (size2 <= 0) {
                throw runtime2.newArgumentError("invalid size");
            }
            final RubyArray result = runtime2.newArray(size2);
            RubyEnumerable.callEach(runtime2, context, self, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (result.size() == size2) {
                        result.shift(ctx);
                    }
                    result.append(largs[0]);
                    if (result.size() == size2) {
                        block.yield(ctx, result.aryDup());
                    }
                    return runtime2.getNil();
                }
            });
            return runtime2.getNil();
        }

        @JRubyMethod(name={"each_cons"}, compat=CompatVersion.RUBY1_9)
        public static IRubyObject each_cons19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return block.isGiven() ? RubyEnumeratorEnumerable.each_cons(context, self, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "each_cons", arg2);
        }

        @JRubyMethod(name={"each_with_object"}, frame=true, compat=CompatVersion.RUBY1_9)
        public static IRubyObject each_with_object(ThreadContext context, IRubyObject self, final IRubyObject arg2, final Block block) {
            final Ruby runtime2 = context.getRuntime();
            if (!block.isGiven()) {
                return RubyEnumerator.enumeratorize(runtime2, self, "each_with_object", arg2);
            }
            RubyEnumerable.callEach(runtime2, context, self, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    block.call(ctx, new IRubyObject[]{runtime2.newArray(largs[0], arg2)});
                    return runtime2.getNil();
                }
            });
            return arg2;
        }

        @JRubyMethod(name={"enum_slice"}, required=1, compat=CompatVersion.RUBY1_8)
        public static IRubyObject enum_slice(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            RubyClass enumerator = self.getRuntime().getEnumerator();
            return RuntimeHelpers.invoke(context, (IRubyObject)enumerator, "new", self, (IRubyObject)self.getRuntime().fastNewSymbol("each_slice"), arg2);
        }

        @JRubyMethod(name={"enum_cons"}, required=1, compat=CompatVersion.RUBY1_8)
        public static IRubyObject enum_cons(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            RubyClass enumerator = self.getRuntime().getEnumerator();
            return RuntimeHelpers.invoke(context, (IRubyObject)enumerator, "new", self, (IRubyObject)self.getRuntime().fastNewSymbol("each_cons"), arg2);
        }

        @JRubyMethod(name={"enum_with_index"})
        public static IRubyObject each_with_index(ThreadContext context, IRubyObject self) {
            RubyClass enumerator = self.getRuntime().getEnumerator();
            return RuntimeHelpers.invoke(context, (IRubyObject)enumerator, "new", self, self.getRuntime().fastNewSymbol("each_with_index"));
        }
    }

    public static final class RubyEnumeratorKernel {
        @JRubyMethod(name={"to_enum", "enum_for"}, frame=true)
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, Block block) {
            return self.getRuntime().getEnumerator().callMethod(context, "new", self);
        }

        @JRubyMethod(name={"to_enum", "enum_for"}, frame=true)
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return RuntimeHelpers.invoke(context, (IRubyObject)self.getRuntime().getEnumerator(), "new", self, arg2);
        }

        @JRubyMethod(name={"to_enum", "enum_for"}, frame=true)
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) {
            return RuntimeHelpers.invoke(context, (IRubyObject)self.getRuntime().getEnumerator(), "new", self, arg0, arg1);
        }

        @JRubyMethod(name={"to_enum", "enum_for"}, optional=1, rest=true, frame=true)
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
            IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
            newArgs[0] = self;
            System.arraycopy(args2, 0, newArgs, 1, args2.length);
            return self.getRuntime().getEnumerator().callMethod(context, "new", newArgs);
        }
    }
}

