/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.SimpleSampler;

public class Main {
    private boolean hasPrintedUsage = false;
    private final RubyInstanceConfig config;

    public Main(RubyInstanceConfig config) {
        this.config = config;
    }

    public Main(final InputStream in, final PrintStream out, final PrintStream err) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(in);
                this.setOutput(out);
                this.setError(err);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    public static void main(String[] args2) {
        if (Platform.IS_GCJ) {
            System.err.println("Fatal: GCJ (GNU Compiler for Java) is not supported by JRuby.");
            System.exit(1);
        }
        Main main2 = new Main();
        try {
            int status2 = main2.run(args2);
            if (status2 != 0) {
                System.exit(status2);
            }
        }
        catch (RaiseException re) {
            throw re;
        }
        catch (Throwable t) {
            System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t));
            System.exit(1);
        }
    }

    public int run(String[] args2) {
        try {
            this.config.processArguments(args2);
            return this.run();
        }
        catch (MainExitException mee) {
            if (!mee.isAborted()) {
                this.config.getOutput().println(mee.getMessage());
                if (mee.isUsageError()) {
                    this.printUsage();
                }
            }
            return mee.getStatus();
        }
        catch (OutOfMemoryError oome) {
            System.gc();
            String memoryMax = SafePropertyAccessor.getProperty("jruby.memory.max");
            String message2 = "";
            if (memoryMax != null) {
                message2 = " of " + memoryMax;
            }
            this.config.getError().println("Error: Your application used more memory than the safety cap" + message2 + ".");
            this.config.getError().println("Specify -J-Xmx####m to increase it (#### = cap size in MB).");
            if (this.config.getVerbose().booleanValue()) {
                this.config.getError().println("Exception trace follows:");
                oome.printStackTrace();
            } else {
                this.config.getError().println("Specify -w for full OutOfMemoryError stack trace");
            }
            return 1;
        }
        catch (StackOverflowError soe) {
            System.gc();
            String stackMax = SafePropertyAccessor.getProperty("jruby.stack.max");
            String message3 = "";
            if (stackMax != null) {
                message3 = " of " + stackMax;
            }
            this.config.getError().println("Error: Your application used more stack memory than the safety cap" + message3 + ".");
            this.config.getError().println("Specify -J-Xss####k to increase it (#### = cap size in KB).");
            if (this.config.getVerbose().booleanValue()) {
                this.config.getError().println("Exception trace follows:");
                soe.printStackTrace();
            } else {
                this.config.getError().println("Specify -w for full StackOverflowError stack trace");
            }
            return 1;
        }
        catch (UnsupportedClassVersionError ucve) {
            this.config.getError().println("Error: Some library (perhaps JRuby) was built with a later JVM version.");
            this.config.getError().println("Please use libraries built with the version you intend to use or an earlier one.");
            if (this.config.getVerbose().booleanValue()) {
                this.config.getError().println("Exception trace follows:");
                ucve.printStackTrace();
            } else {
                this.config.getError().println("Specify -w for full UnsupportedClassVersionError stack trace");
            }
            return 1;
        }
        catch (ThreadKill kill2) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        Ruby runtime2;
        String filename2;
        InputStream in;
        block31: {
            if (this.config.isShowVersion()) {
                this.showVersion();
            }
            if (this.config.isShowCopyright()) {
                this.showCopyright();
            }
            if (!this.config.shouldRunInterpreter()) {
                if (this.config.shouldPrintUsage()) {
                    this.printUsage();
                }
                if (this.config.shouldPrintProperties()) {
                    this.printProperties();
                }
                return 0;
            }
            in = this.config.getScriptSource();
            filename2 = this.config.displayedFileName();
            String[] args2 = this.parseShebangOptions(in);
            if (args2.length > 0) {
                this.config.processArguments(args2);
            }
            runtime2 = Ruby.newInstance(this.config);
            try {
                Thread.currentThread().setContextClassLoader(runtime2.getJRubyClassLoader());
            }
            catch (SecurityException se) {
                if (!runtime2.getInstanceConfig().isVerbose()) break block31;
                this.config.getError().println("WARNING: Security restrictions disallowed setting context classloader for main thread.");
            }
        }
        if (in != null) {
            if (this.config.isShouldCheckSyntax()) {
                int status2 = 0;
                try {
                    runtime2.parseFromMain(in, filename2);
                    this.config.getOutput().println("Syntax OK for " + filename2);
                }
                catch (RaiseException re) {
                    status2 = -1;
                    if (re.getException().getMetaClass().getBaseName().equals("SyntaxError")) {
                        this.config.getOutput().println("SyntaxError in " + re.getException().message(runtime2.getCurrentContext()));
                    }
                    throw re;
                }
                if (this.config.getArgv().length > 0) {
                    for (String arg2 : this.config.getArgv()) {
                        File argFile = new File(arg2);
                        if (argFile.exists()) {
                            try {
                                runtime2.parseFromMain(new FileInputStream(argFile), arg2);
                                this.config.getOutput().println("Syntax OK for " + arg2);
                                continue;
                            }
                            catch (FileNotFoundException fnfe) {
                                status2 = -1;
                                this.config.getOutput().println("File not found: " + arg2);
                                continue;
                            }
                            catch (RaiseException re) {
                                status2 = -1;
                                if (re.getException().getMetaClass().getBaseName().equals("SyntaxError")) {
                                    this.config.getOutput().println("SyntaxError in " + re.getException().message(runtime2.getCurrentContext()));
                                    continue;
                                }
                                throw re;
                            }
                        }
                        status2 = -1;
                        this.config.getOutput().println("File not found: " + arg2);
                    }
                }
                return status2;
            }
            long now = -1L;
            try {
                if (this.config.isBenchmarking()) {
                    now = System.currentTimeMillis();
                }
                if (this.config.isSamplingEnabled()) {
                    SimpleSampler.startSampleThread();
                }
                try {
                    runtime2.runFromMain(in, filename2);
                }
                finally {
                    runtime2.tearDown();
                    if (this.config.isBenchmarking()) {
                        this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
                    }
                    if (this.config.isSamplingEnabled()) {
                        SimpleSampler.report();
                    }
                }
            }
            catch (RaiseException rj) {
                RubyException raisedException = rj.getException();
                if (runtime2.getSystemExit().isInstance(raisedException)) {
                    IRubyObject status3 = raisedException.callMethod(runtime2.getCurrentContext(), "status");
                    if (status3 != null && !status3.isNil()) {
                        return RubyNumeric.fix2int(status3);
                    }
                }
                runtime2.printError(raisedException);
                return 1;
            }
        }
        return 0;
    }

    private void showVersion() {
        this.config.getOutput().println(this.config.getVersionString());
    }

    private void showCopyright() {
        this.config.getOutput().println(this.config.getCopyrightString());
    }

    public void printUsage() {
        if (!this.hasPrintedUsage) {
            this.config.getOutput().print(this.config.getBasicUsageHelp());
            this.hasPrintedUsage = true;
        }
    }

    public void printProperties() {
        this.config.getOutput().print(this.config.getPropertyHelp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] parseShebangOptions(InputStream in) {
        BufferedReader reader = null;
        String[] result = new String[]{};
        if (in == null) {
            return result;
        }
        try {
            in.mark(1024);
            reader = new BufferedReader(new InputStreamReader(in, "iso-8859-1"), 8192);
            String firstLine = reader.readLine();
            boolean usesEnv = false;
            if (firstLine.length() > 2 && firstLine.charAt(0) == '#' && firstLine.charAt(1) == '!') {
                int i;
                String[] options2 = firstLine.substring(2).split("\\s+");
                for (i = 0; i < options2.length; ++i) {
                    String basename2;
                    if (i == 0 && options2[i].endsWith("/env")) {
                        usesEnv = true;
                        continue;
                    }
                    if (!(usesEnv && options2[i].indexOf(61) > 0 || usesEnv && options2[i].startsWith("-") || (basename2 = new File(options2[i]).getName()).indexOf("ruby") <= 0)) break;
                }
                System.arraycopy(options2, i, result, 0, options2.length - i);
            }
        }
        catch (Exception ex) {
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException ex) {}
        }
        return result;
    }
}

