/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;

class LoggingNHttpServiceHandler
implements NHttpServiceHandler {
    private final Log log;
    private final NHttpServiceHandler handler;

    public LoggingNHttpServiceHandler(Log log, NHttpServiceHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP service handler may not be null");
        }
        this.handler = handler;
        this.log = LogFactory.getLog(handler.getClass());
    }

    public void connected(NHttpServerConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Connected"));
        }
        this.handler.connected(conn);
    }

    public void closed(NHttpServerConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Closed"));
        }
        this.handler.closed(conn);
    }

    public void exception(NHttpServerConnection conn, IOException ex) {
        if (ex instanceof ConnectionClosedException || ex.getMessage().contains("Connection reset by peer") || ex.getMessage().contains("forcibly closed")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("HTTP connection " + conn + ": " + ex.getMessage() + " (Probably the keepalive connection was closed)"));
            }
        } else {
            this.log.error((Object)("HTTP connection " + conn + ": " + ex.getMessage()), (Throwable)ex);
        }
        this.handler.exception(conn, ex);
    }

    public void exception(NHttpServerConnection conn, HttpException ex) {
        this.log.error((Object)("HTTP connection " + conn + ": " + ex.getMessage()), (Throwable)ex);
        this.handler.exception(conn, ex);
    }

    public void requestReceived(NHttpServerConnection conn) {
        HttpRequest request = conn.getHttpRequest();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": " + request.getRequestLine()));
        }
        this.handler.requestReceived(conn);
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Output ready"));
        }
        this.handler.outputReady(conn, encoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Content encoder " + encoder));
        }
    }

    public void responseReady(NHttpServerConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Response ready"));
        }
        this.handler.responseReady(conn);
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Input ready"));
        }
        this.handler.inputReady(conn, decoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Content decoder " + decoder));
        }
    }

    public void timeout(NHttpServerConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Timeout"));
        }
        this.handler.timeout(conn);
    }
}

