/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.GetPropertyFunction;
import org.apache.synapse.util.xpath.Base64EncodeFunction;
import org.apache.synapse.util.xpath.ext.XpathExtensionUtil;
import org.jaxen.Function;
import org.jaxen.FunctionContext;
import org.jaxen.UnresolvableException;

public class SynapseXPathFunctionContext
implements FunctionContext {
    private final FunctionContext parent;
    private final MessageContext synCtx;

    public SynapseXPathFunctionContext(FunctionContext parent, MessageContext synCtx) {
        this.parent = parent;
        this.synCtx = synCtx;
    }

    public Function getFunction(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        if (localName != null && "get-property".equals(localName)) {
            return new GetPropertyFunction(this.synCtx);
        }
        if (localName != null && "base64Encode".equals(localName)) {
            return new Base64EncodeFunction();
        }
        Function extensionFunction = XpathExtensionUtil.getFunctionContext(this.synCtx, namespaceURI, prefix, localName);
        if (extensionFunction != null) {
            return extensionFunction;
        }
        return this.parent.getFunction(namespaceURI, prefix, localName);
    }
}

