/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.message.store.MessageStoreViewMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStoreView
implements MessageStoreViewMBean {
    private String messageStoreName;
    private MessageStore messageStore;
    private static final Log log = LogFactory.getLog(MessageStoreView.class);

    public MessageStoreView(String name, MessageStore messageStore) {
        this.messageStoreName = name;
        this.messageStore = messageStore;
    }

    @Override
    public void deleteAll() {
        this.messageStore.clear();
        log.info((Object)("All messages in Message Store" + this.messageStoreName + " were deleted"));
    }

    @Override
    public List<String> getMessageIds() {
        ArrayList<String> returnList = new ArrayList<String>();
        List<MessageContext> list = this.messageStore.getAll();
        for (MessageContext m : list) {
            returnList.add(m.getMessageID());
        }
        return returnList;
    }

    @Override
    public void delete(String messageID) {
        MessageContext m;
        if (messageID != null && (m = this.messageStore.remove(messageID)) != null) {
            log.info((Object)("Message with ID :" + messageID + " removed from the MessageStore"));
        }
    }

    @Override
    public String getEnvelope(String messageID) {
        MessageContext m;
        if (messageID != null && (m = this.messageStore.get(messageID)) != null) {
            return m.getEnvelope().toString();
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.messageStore.size();
    }
}

