/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPBody;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.xpath.SynapseXPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadFactoryMediator
extends AbstractMediator {
    private String format;
    private List<Argument> argumentList = new ArrayList<Argument>();
    private Pattern pattern = Pattern.compile("\\$(\\d)+");

    @Override
    public boolean mediate(MessageContext synCtx) {
        OMElement child;
        OMElement resultElement;
        SOAPBody soapBody = synCtx.getEnvelope().getBody();
        StringBuffer result = new StringBuffer();
        this.transformPayload(result, synCtx);
        try {
            resultElement = AXIOMUtil.stringToOM((String)result.toString());
        }
        catch (XMLStreamException e) {
            this.handleException("Unable to create a valid XML payload. Invalid format/arguments are provided in the payloadFactory mediator configuration", synCtx);
            return false;
        }
        Iterator itr = soapBody.getChildElements();
        while (itr.hasNext()) {
            child = (OMElement)itr.next();
            child.detach();
        }
        itr = resultElement.getChildElements();
        while (itr.hasNext()) {
            child = (OMElement)itr.next();
            soapBody.addChild((OMNode)child);
        }
        return true;
    }

    private void transformPayload(StringBuffer result, MessageContext synCtx) {
        Object[] argValues = this.getArgValues(synCtx);
        Matcher matcher = this.pattern.matcher("<dummy>" + this.format + "</dummy>");
        while (matcher.find()) {
            String matchSeq = matcher.group();
            int argIndex = Integer.parseInt(matchSeq.substring(1));
            matcher.appendReplacement(result, argValues[argIndex - 1].toString());
        }
        matcher.appendTail(result);
    }

    private Object[] getArgValues(MessageContext synCtx) {
        Object[] argValues = new Object[this.argumentList.size()];
        for (int i = 0; i < this.argumentList.size(); ++i) {
            Argument arg = this.argumentList.get(i);
            if (arg.getValue() != null) {
                argValues[i] = arg.getValue();
                continue;
            }
            if (arg.getExpression() != null) {
                String value = arg.getExpression().stringValueOf(synCtx);
                if (value != null) {
                    argValues[i] = value;
                    continue;
                }
                argValues[i] = "";
                continue;
            }
            this.handleException("Unexpected argument type detected in the payloadFactory mediator configuration", synCtx);
        }
        return argValues;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void addArgument(Argument arg) {
        this.argumentList.add(arg);
    }

    public List<Argument> getArgumentList() {
        return this.argumentList;
    }

    public static class Argument {
        private String value;
        private SynapseXPath expression;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public SynapseXPath getExpression() {
            return this.expression;
        }

        public void setExpression(SynapseXPath expression) {
            this.expression = expression;
        }
    }
}

