/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadbalanceEndpoint
extends AbstractEndpoint {
    private boolean failover = true;
    private LoadbalanceAlgorithm algorithm = null;
    private AlgorithmContext algorithmContext = null;
    private List<Member> activeMembers = null;
    private List<Member> inactiveMembers = null;

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        ConfigurationContext cc = ((Axis2SynapseEnvironment)synapseEnvironment).getAxis2ConfigurationContext();
        if (!this.initialized) {
            super.init(synapseEnvironment);
            if (this.algorithmContext == null) {
                this.algorithmContext = new AlgorithmContext(this.isClusteringEnabled, cc, this.getName());
            }
            if (this.algorithm != null && this.algorithm instanceof ManagedLifecycle) {
                ManagedLifecycle lifecycle = (ManagedLifecycle)((Object)this.algorithm);
                lifecycle.init(synapseEnvironment);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.algorithm != null && this.algorithm instanceof ManagedLifecycle) {
            ManagedLifecycle lifecycle = (ManagedLifecycle)((Object)this.algorithm);
            lifecycle.destroy();
        }
    }

    @Override
    public void send(MessageContext synCtx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending using Load-balance " + this.toString()));
        }
        Endpoint endpoint = null;
        if (this.activeMembers == null) {
            endpoint = this.getNextChild(synCtx);
        }
        this.evaluateProperties(synCtx);
        if (endpoint != null) {
            if (synCtx.getProperty("last_endpoint") == null) {
                if (this.failover) {
                    synCtx.getEnvelope().build();
                }
            } else if (this.metricsMBean != null) {
                this.metricsMBean.reportSendingFault(303100);
            }
            synCtx.pushFaultHandler(this);
            endpoint.send(synCtx);
        } else if (this.activeMembers != null && !this.activeMembers.isEmpty()) {
            EndpointReference to = synCtx.getTo();
            LoadbalanceFaultHandler faultHandler = new LoadbalanceFaultHandler(to);
            if (this.failover) {
                synCtx.pushFaultHandler(faultHandler);
            }
            this.sendToApplicationMember(synCtx, to, faultHandler);
        } else {
            String msg = "Loadbalance endpoint : " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " - no ready child endpoints";
            this.log.warn((Object)msg);
            this.informFailure(synCtx, 303000, msg);
        }
    }

    private void sendToApplicationMember(MessageContext synCtx, EndpointReference to, LoadbalanceFaultHandler faultHandler) {
        org.apache.axis2.context.MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String transport = axis2MsgCtx.getTransportIn().getName();
        this.algorithm.setApplicationMembers(this.activeMembers);
        Member currentMember = this.algorithm.getNextApplicationMember(this.algorithmContext);
        faultHandler.setCurrentMember(currentMember);
        if (currentMember != null) {
            if (transport.equals("http") || transport.equals("https")) {
                String address = to.getAddress();
                if (address.indexOf(":") != -1) {
                    try {
                        address = new URL(address).getPath();
                    }
                    catch (MalformedURLException e) {
                        String msg = "URL " + address + " is malformed";
                        this.log.error((Object)msg, (Throwable)e);
                        throw new SynapseException(msg, e);
                    }
                }
                EndpointReference epr = new EndpointReference(transport + "://" + currentMember.getHostName() + ":" + ("http".equals(transport) ? currentMember.getHttpPort() : currentMember.getHttpsPort()) + address);
                synCtx.setTo(epr);
                if (this.failover) {
                    synCtx.getEnvelope().build();
                }
                AddressEndpoint endpoint = new AddressEndpoint();
                EndpointDefinition definition = new EndpointDefinition();
                endpoint.setDefinition(definition);
                endpoint.init(synCtx.getEnvironment());
                endpoint.send(synCtx);
            } else {
                this.log.error((Object)("Cannot load balance for non-HTTP/S transport " + transport));
            }
        } else {
            synCtx.getFaultStack().pop();
            String msg = "No application members available";
            this.log.error((Object)msg);
            throw new SynapseException(msg);
        }
    }

    @Override
    public boolean readyToSend() {
        for (Endpoint endpoint : this.getChildren()) {
            if (!endpoint.readyToSend()) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Load-balance " + this.toString() + " has at least one endpoint at ready state"));
            }
            return true;
        }
        this.log.warn((Object)("Load-balance " + this.toString() + " has no endpoints at ready state to process message"));
        return false;
    }

    @Override
    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        this.logOnChildEndpointFail(endpoint, synMessageContext);
        if (this.failover) {
            if (!((AbstractEndpoint)endpoint).isRetryDisabled(synMessageContext)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(this + " Retry Attempt for Request with [Message ID : " + synMessageContext.getMessageID() + "], [To : " + synMessageContext.getTo() + "]"));
                }
                this.send(synMessageContext);
            } else {
                String msg = "Loadbalance endpoint : " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " - one of the child endpoints encounterd a non-retry error, " + "not sending message to another endpoint";
                this.log.warn((Object)msg);
                this.informFailure(synMessageContext, 303000, msg);
            }
        } else {
            FaultHandler o = synMessageContext.getFaultStack().pop();
            if (o != null) {
                o.handleFault(synMessageContext);
            }
        }
    }

    public boolean isFailover() {
        return this.failover;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public LoadbalanceAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(LoadbalanceAlgorithm algorithm) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Load-balance " + this.toString() + " will be using the algorithm " + algorithm.getName() + " for load distribution"));
        }
        this.algorithm = algorithm;
    }

    protected Endpoint getNextChild(MessageContext synCtx) {
        return this.algorithm.getNextEndpoint(synCtx, this.algorithmContext);
    }

    public void setMembers(List<Member> members) {
        this.activeMembers = members;
        this.inactiveMembers = new ArrayList<Member>();
    }

    public List<Member> getMembers() {
        return this.activeMembers;
    }

    public void startApplicationMembershipTimer() {
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)new MemberActivatorTask(), 1000L, 500L);
    }

    private class MemberActivatorTask
    extends TimerTask {
        private MemberActivatorTask() {
        }

        public void run() {
            try {
                for (Member member : LoadbalanceEndpoint.this.inactiveMembers) {
                    if (!this.canConnect(member)) continue;
                    LoadbalanceEndpoint.this.inactiveMembers.remove(member);
                    LoadbalanceEndpoint.this.activeMembers.add(member);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean canConnect(Member member) {
            if (LoadbalanceEndpoint.this.log.isDebugEnabled()) {
                LoadbalanceEndpoint.this.log.debug((Object)("Trying to connect to member " + member.getHostName() + "..."));
            }
            for (int retries = 30; retries > 0; --retries) {
                try {
                    InetAddress addr = InetAddress.getByName(member.getHostName());
                    int httpPort = member.getHttpPort();
                    if (LoadbalanceEndpoint.this.log.isDebugEnabled()) {
                        LoadbalanceEndpoint.this.log.debug((Object)("HTTP Port=" + httpPort));
                    }
                    if (httpPort != -1) {
                        InetSocketAddress httpSockaddr = new InetSocketAddress(addr, httpPort);
                        new Socket().connect(httpSockaddr, 10000);
                    }
                    int httpsPort = member.getHttpsPort();
                    if (LoadbalanceEndpoint.this.log.isDebugEnabled()) {
                        LoadbalanceEndpoint.this.log.debug((Object)("HTTPS Port=" + httpPort));
                    }
                    if (httpsPort != -1) {
                        InetSocketAddress httpsSockaddr = new InetSocketAddress(addr, httpsPort);
                        new Socket().connect(httpsSockaddr, 10000);
                    }
                    return true;
                }
                catch (IOException e) {
                    String msg;
                    if (LoadbalanceEndpoint.this.log.isDebugEnabled()) {
                        LoadbalanceEndpoint.this.log.debug((Object)"", (Throwable)e);
                    }
                    if ((msg = e.getMessage()).indexOf("Connection refused") != -1 || msg.indexOf("connect timed out") != -1) continue;
                    LoadbalanceEndpoint.this.log.error((Object)("Cannot connect to member " + member), (Throwable)e);
                    continue;
                }
            }
            return false;
        }
    }

    private class LoadbalanceFaultHandler
    extends FaultHandler {
        private EndpointReference to;
        private Member currentMember;

        public void setCurrentMember(Member currentMember) {
            this.currentMember = currentMember;
        }

        private LoadbalanceFaultHandler(EndpointReference to) {
            this.to = to;
        }

        public void onFault(MessageContext synCtx) {
            if (this.currentMember == null) {
                return;
            }
            synCtx.pushFaultHandler(this);
            LoadbalanceEndpoint.this.activeMembers.remove(this.currentMember);
            LoadbalanceEndpoint.this.inactiveMembers.add(this.currentMember);
            LoadbalanceEndpoint.this.sendToApplicationMember(synCtx, this.to, this);
        }
    }
}

