/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.Map;
import java.util.Stack;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.aspects.statistics.StatisticsCleaner;
import org.apache.synapse.aspects.statistics.StatisticsCollector;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.core.axis2.AsyncCallback;
import org.apache.synapse.endpoints.dispatch.SALSessions;

public class TimeoutHandler
extends TimerTask {
    private static final Log log = LogFactory.getLog(TimeoutHandler.class);
    private final Map callbackStore;
    private final Object lock = new Object();
    private boolean alreadyExecuting = false;
    private long globalTimeout = 86400000L;
    private static final String SEND_TIMEOUT_MESSAGE = "Send timeout";
    private StatisticsCleaner statisticsCleaner;
    private ServerContextInformation contextInfo = null;

    public TimeoutHandler(Map callbacks, ServerContextInformation contextInfo) {
        this.callbackStore = callbacks;
        this.contextInfo = contextInfo;
        this.globalTimeout = SynapseConfigUtils.getGlobalTimeoutInterval();
        log.info((Object)("This engine will expire all callbacks after : " + this.globalTimeout / 1000L + " seconds, irrespective of the timeout action," + " after the specified or optional timeout"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.alreadyExecuting) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.alreadyExecuting = true;
            try {
                this.processCallbacks();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alreadyExecuting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCallbacks() {
        StatisticsCollector collector;
        if (this.statisticsCleaner == null && (collector = SynapseConfigUtils.getStatisticsCollector(this.contextInfo)) != null) {
            this.statisticsCleaner = new StatisticsCleaner(collector);
        }
        if (this.statisticsCleaner != null) {
            this.statisticsCleaner.clean();
        }
        SALSessions.getInstance().clearSessions();
        Map map = this.callbackStore;
        synchronized (map) {
            if (this.callbackStore.size() > 0) {
                long currentTime = this.currentTime();
                for (Object key : this.callbackStore.keySet()) {
                    AsyncCallback callback = (AsyncCallback)this.callbackStore.get(key);
                    if (callback == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("There is no callback for key :" + key));
                        continue;
                    }
                    if (callback.getTimeOutAction() != 100) {
                        if (callback.getTimeOutOn() > currentTime) continue;
                        this.callbackStore.remove(key);
                        if (callback.getTimeOutAction() != 102) continue;
                        MessageContext msgContext = callback.getSynapseOutMsgCtx();
                        msgContext.setProperty("ERROR_CODE", 504);
                        msgContext.setProperty("ERROR_MESSAGE", SEND_TIMEOUT_MESSAGE);
                        Stack<FaultHandler> faultStack = msgContext.getFaultStack();
                        for (int j = 0; j < faultStack.size(); ++j) {
                            FaultHandler o = faultStack.pop();
                            if (!(o instanceof FaultHandler)) continue;
                            o.handleFault(msgContext);
                        }
                        continue;
                    }
                    if (currentTime <= this.globalTimeout + callback.getTimeOutOn()) continue;
                    log.warn((Object)("Expiring message ID : " + key + "; dropping message after " + "global timeout of : " + this.globalTimeout / 1000L + " seconds"));
                    this.callbackStore.remove(key);
                }
            }
        }
    }

    private long currentTime() {
        return System.currentTimeMillis();
    }
}

