/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorSerializer;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.base.SequenceMediator;

public class SequenceMediatorSerializer
extends AbstractListMediatorSerializer {
    public OMElement serializeAnonymousSequence(OMElement parent, SequenceMediator mediator) {
        OMElement sequence = fac.createOMElement("sequence", synNS);
        if (mediator.getErrorHandler() != null) {
            sequence.addAttribute(fac.createOMAttribute("onError", nullNS, mediator.getErrorHandler()));
        }
        SequenceMediatorSerializer.saveTracingState(sequence, mediator);
        if (mediator.getDescription() != null) {
            OMElement descriptionElem = fac.createOMElement(DESCRIPTION_Q);
            descriptionElem.setText(mediator.getDescription());
            sequence.addChild((OMNode)descriptionElem);
        }
        this.serializeChildren(sequence, mediator.getList());
        if (parent != null) {
            parent.addChild((OMNode)sequence);
        }
        return sequence;
    }

    public OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof SequenceMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        SequenceMediator mediator = (SequenceMediator)m;
        OMElement sequence = fac.createOMElement("sequence", synNS);
        if (mediator.isDynamic()) {
            sequence.addAttribute(fac.createOMAttribute("name", nullNS, mediator.getName()));
            sequence.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getRegistryKey()));
        } else if (mediator.getKey() != null) {
            ValueSerializer keySerializer = new ValueSerializer();
            keySerializer.serializeValue(mediator.getKey(), "key", sequence);
        } else if (mediator.getName() != null) {
            sequence.addAttribute(fac.createOMAttribute("name", nullNS, mediator.getName()));
            if (mediator.getErrorHandler() != null) {
                sequence.addAttribute(fac.createOMAttribute("onError", nullNS, mediator.getErrorHandler()));
            }
            SequenceMediatorSerializer.saveTracingState(sequence, mediator);
            this.serializeChildren(sequence, mediator.getList());
        }
        return sequence;
    }

    public String getMediatorClassName() {
        return SequenceMediator.class.getName();
    }
}

