/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.state;

import java.util.ArrayList;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.StateManager;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Replicator {
    private static final Log log = LogFactory.getLog(Replicator.class);

    public static void replicate(MessageContext msgContext) throws ClusteringFault {
        ServiceContext serviceContext;
        ServiceGroupContext sgContext;
        if (!Replicator.canReplicate(msgContext)) {
            return;
        }
        log.debug((Object)("Going to replicate state stored in ConfigurationContext, ServiceGroupContext, ServiceContext associated with " + msgContext + "..."));
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        StateManager stateManager = Replicator.getContextManager(msgContext);
        ArrayList<AbstractContext> contexts = new ArrayList<AbstractContext>();
        if (!configurationContext.getPropertyDifferences().isEmpty()) {
            contexts.add(configurationContext);
        }
        if ((sgContext = msgContext.getServiceGroupContext()) != null && !sgContext.getPropertyDifferences().isEmpty()) {
            contexts.add(sgContext);
        }
        if ((serviceContext = msgContext.getServiceContext()) != null && !serviceContext.getPropertyDifferences().isEmpty()) {
            contexts.add(serviceContext);
        }
        if (!contexts.isEmpty()) {
            AbstractContext[] contextArray = contexts.toArray(new AbstractContext[contexts.size()]);
            stateManager.updateContexts(contextArray);
        }
    }

    public static void replicate(AbstractContext abstractContext) throws ClusteringFault {
        if (!Replicator.canReplicate(abstractContext)) {
            return;
        }
        log.debug((Object)("Going to replicate state in " + abstractContext + "..."));
        StateManager stateManager = Replicator.getContextManager(abstractContext);
        if (!abstractContext.getPropertyDifferences().isEmpty()) {
            stateManager.updateContext(abstractContext);
        }
    }

    public static void replicate(AbstractContext abstractContext, String[] propertyNames) throws ClusteringFault {
        if (!Replicator.canReplicate(abstractContext)) {
            return;
        }
        log.debug((Object)("Going to replicate selected properties in " + abstractContext + "..."));
        StateManager stateManager = Replicator.getContextManager(abstractContext);
        stateManager.updateContext(abstractContext, propertyNames);
    }

    private static ClusteringAgent getClusterManager(AbstractContext abstractContext) {
        return abstractContext.getRootContext().getAxisConfiguration().getClusteringAgent();
    }

    private static StateManager getContextManager(AbstractContext abstractContext) {
        return Replicator.getClusterManager(abstractContext).getStateManager();
    }

    private static boolean canReplicate(AbstractContext abstractContext) {
        ClusteringAgent clusteringAgent = abstractContext.getRootContext().getAxisConfiguration().getClusteringAgent();
        boolean canReplicate = false;
        if (clusteringAgent != null && clusteringAgent.getStateManager() != null) {
            canReplicate = clusteringAgent.getStateManager().isContextClusterable(abstractContext);
        }
        return canReplicate;
    }

    private static boolean canReplicate(MessageContext messageContext) {
        ClusteringAgent clusteringAgent = messageContext.getRootContext().getAxisConfiguration().getClusteringAgent();
        return clusteringAgent != null && clusteringAgent.getStateManager() != null;
    }
}

