/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.joda.time.DateTime;
import org.opensaml.saml2.common.SAML2Helper;
import org.opensaml.saml2.metadata.provider.AbstractObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemMetadataProvider
extends AbstractObservableMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(FilesystemMetadataProvider.class);
    private File metadataFile;
    private boolean maintainExpiredMetadata;
    private long lastUpdate;
    private XMLObject cachedMetadata;

    public FilesystemMetadataProvider(File metadata) throws MetadataProviderException {
        if (metadata == null) {
            throw new MetadataProviderException("Give metadata file may not be null");
        }
        if (!metadata.exists()) {
            throw new MetadataProviderException("Give metadata file, " + metadata.getAbsolutePath() + " does not exist");
        }
        if (!metadata.isFile()) {
            throw new MetadataProviderException("Give metadata file, " + metadata.getAbsolutePath() + " is not a file");
        }
        if (!metadata.canRead()) {
            throw new MetadataProviderException("Give metadata file, " + metadata.getAbsolutePath() + " is not readable");
        }
        this.metadataFile = metadata;
        this.maintainExpiredMetadata = true;
        this.lastUpdate = -1L;
    }

    public void initialize() throws MetadataProviderException {
        this.refreshMetadata();
    }

    public boolean maintainExpiredMetadata() {
        return this.maintainExpiredMetadata;
    }

    public void setMaintainExpiredMetadata(boolean maintain) {
        this.maintainExpiredMetadata = maintain;
    }

    public XMLObject getMetadata() throws MetadataProviderException {
        if (this.lastUpdate < this.metadataFile.lastModified()) {
            this.refreshMetadata();
        }
        return this.cachedMetadata;
    }

    private synchronized void refreshMetadata() throws MetadataProviderException {
        long metadataFileLastModified = this.metadataFile.lastModified();
        if (this.lastUpdate >= metadataFileLastModified) {
            return;
        }
        this.log.debug("Refreshing metadata from file {}", (Object)this.metadataFile);
        try {
            XMLObject metadata = this.unmarshallMetadata(new FileInputStream(this.metadataFile));
            DateTime expirationTime = SAML2Helper.getEarliestExpiration(metadata);
            if (expirationTime != null && !this.maintainExpiredMetadata() && expirationTime.isBeforeNow()) {
                this.log.debug("Metadata from file {} is expired and provider is configured not to retain expired metadata.", (Object)this.metadataFile);
                this.cachedMetadata = null;
            } else {
                this.filterMetadata(metadata);
                this.releaseMetadataDOM(metadata);
                this.cachedMetadata = metadata;
            }
            this.lastUpdate = metadataFileLastModified;
            this.emitChangeEvent();
        }
        catch (FileNotFoundException e) {
            String errorMsg = "Unable to read metadata file";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, e);
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, (Exception)((Object)e));
        }
        catch (FilterException e) {
            String errorMsg = "Unable to filter metadata";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, e);
        }
    }
}

