/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IndexedEndpoint;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthnResponseEndpointSelector
extends BasicEndpointSelector {
    private final Logger log = LoggerFactory.getLogger(AuthnResponseEndpointSelector.class);

    @Override
    public Endpoint selectEndpoint() {
        if (this.getEntityRoleMetadata() == null) {
            this.log.debug("Unable to select endpoint, no entity role metadata available.");
            return null;
        }
        List<Endpoint> endpoints = this.getEntityRoleMetadata().getEndpoints(this.getEndpointType());
        if (endpoints == null || endpoints.size() == 0) {
            return null;
        }
        Endpoint endpoint = null;
        if (this.getSamlRequest() != null) {
            AuthnRequest request = (AuthnRequest)this.getSamlRequest();
            if ((endpoints = this.filterEndpointsByProtocolBinding(endpoints)) == null || endpoints.isEmpty()) {
                return null;
            }
            if (request.getAssertionConsumerServiceIndex() != null) {
                this.log.debug("Selecting endpoint by ACS index for request {} from entity {}", (Object)request.getID(), (Object)this.getEntityMetadata().getEntityID());
                endpoint = this.selectEndpointByACSIndex(request, endpoints);
            } else if (request.getAssertionConsumerServiceURL() != null) {
                this.log.debug("Selecting endpoint by ACS URL for request {} from entity {}", (Object)request.getID(), (Object)this.getEntityMetadata().getEntityID());
                endpoint = this.selectEndpointByACSURL(request, endpoints);
            }
        }
        if (endpoint == null) {
            endpoint = endpoints.get(0) instanceof IndexedEndpoint ? this.selectIndexedEndpoint(endpoints) : this.selectNonIndexedEndpoint(endpoints);
        }
        return endpoint;
    }

    @Override
    protected List<? extends Endpoint> filterEndpointsByProtocolBinding(List<? extends Endpoint> endpoints) {
        this.log.debug("Filtering peer endpoints.  Supported peer endpoint bindings: {}", this.getSupportedIssuerBindings());
        AuthnRequest request = (AuthnRequest)this.getSamlRequest();
        boolean filterByRequestBinding = false;
        String acsBinding = DatatypeHelper.safeTrimOrNullString((String)request.getProtocolBinding());
        if (acsBinding != null && request.getAssertionConsumerServiceIndex() != null) {
            filterByRequestBinding = true;
        }
        ArrayList<? extends Endpoint> filteredEndpoints = new ArrayList<Endpoint>(endpoints);
        Iterator endpointItr = filteredEndpoints.iterator();
        while (endpointItr.hasNext()) {
            Endpoint endpoint = (Endpoint)endpointItr.next();
            if (!this.getSupportedIssuerBindings().contains(endpoint.getBinding())) {
                this.log.debug("Removing endpoint {} because its binding {} is not supported", (Object)endpoint.getLocation(), (Object)endpoint.getBinding());
                endpointItr.remove();
                continue;
            }
            if (!filterByRequestBinding || endpoint.getBinding().equals(acsBinding)) continue;
            this.log.debug("Removing endpoint {} because its binding {} does not match request's requested binding", (Object)endpoint.getLocation(), (Object)endpoint.getBinding());
            endpointItr.remove();
        }
        return filteredEndpoints;
    }

    protected Endpoint selectEndpointByACSIndex(AuthnRequest request, List<IndexedEndpoint> endpoints) {
        Integer acsIndex = request.getAssertionConsumerServiceIndex();
        for (IndexedEndpoint endpoint : endpoints) {
            if (endpoint == null || !this.getSupportedIssuerBindings().contains(endpoint.getBinding()) || endpoint.getIndex() == null || !endpoint.getIndex().equals(acsIndex)) continue;
            return endpoint;
        }
        return null;
    }

    protected Endpoint selectEndpointByACSURL(AuthnRequest request, List<IndexedEndpoint> endpoints) {
        String acsBinding = DatatypeHelper.safeTrimOrNullString((String)request.getProtocolBinding());
        if (acsBinding == null) {
            return null;
        }
        for (IndexedEndpoint endpoint : endpoints) {
            if (!this.getSupportedIssuerBindings().contains(endpoint.getBinding()) || !endpoint.getBinding().equals(acsBinding) || (endpoint.getLocation() == null || !endpoint.getLocation().equals(request.getAssertionConsumerServiceURL())) && (endpoint.getResponseLocation() == null || !endpoint.getResponseLocation().equals(request.getAssertionConsumerServiceURL()))) continue;
            return endpoint;
        }
        return null;
    }
}

