/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.synapse.util.concurrent.SynapseThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynapseThreadPool
extends ThreadPoolExecutor {
    public static final int SYNAPSE_CORE_THREADS = 20;
    public static final int SYNAPSE_MAX_THREADS = 100;
    public static final int SYNAPSE_KEEP_ALIVE = 5;
    public static final int SYNAPSE_THREAD_QLEN = -1;
    public static final String SYNAPSE_THREAD_GROUP = "synapse-thread-group";
    public static final String SYNAPSE_THREAD_ID_PREFIX = "SynapseWorker";
    public static final String SYN_THREAD_CORE = "synapse.threads.core";
    public static final String SYN_THREAD_MAX = "synapse.threads.max";
    public static final String SYN_THREAD_ALIVE = "synapse.threads.keepalive";
    public static final String SYN_THREAD_QLEN = "synapse.threads.qlen";
    public static final String SYN_THREAD_GROUP = "synapse.threads.group";
    public static final String SYN_THREAD_IDPREFIX = "synapse.threads.idprefix";

    public SynapseThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new SynapseThreadFactory(new ThreadGroup(SYNAPSE_THREAD_GROUP), SYNAPSE_THREAD_ID_PREFIX));
    }

    public SynapseThreadPool() {
        this(20, 100, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public SynapseThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, int qlen, String threadGroup, String threadIdPrefix) {
        super(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, qlen > 0 ? new LinkedBlockingQueue<Runnable>(qlen) : new LinkedBlockingQueue(), new SynapseThreadFactory(new ThreadGroup(threadGroup), threadIdPrefix));
    }
}

