/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;

public class SendMediator
extends AbstractMediator
implements ManagedLifecycle {
    private Endpoint endpoint = null;
    private Value receivingSequence = null;

    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        synLog.traceOrDebug("Start : Send mediator");
        if (synLog.isTraceTraceEnabled()) {
            synLog.traceTrace("Message : " + synCtx.getEnvelope());
        }
        if (this.receivingSequence != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Receiving sequence is set to: " + this.receivingSequence);
            }
            synCtx.setProperty("RECEIVING_SEQUENCE", this.receivingSequence.evaluateValue(synCtx));
        }
        if (this.endpoint == null) {
            if (synLog.isTraceOrDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Sending ").append(synCtx.isResponse() ? "response" : "request").append(" message using implicit message properties..");
                sb.append("\nSending To: ").append(synCtx.getTo() != null ? synCtx.getTo().getAddress() : "null");
                sb.append("\nSOAPAction: ").append(synCtx.getWSAAction() != null ? synCtx.getWSAAction() : "null");
                synLog.traceOrDebug(sb.toString());
            }
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Envelope : " + synCtx.getEnvelope());
            }
            synCtx.getEnvironment().send(null, synCtx);
        } else {
            this.endpoint.send(synCtx);
        }
        synLog.traceOrDebug("End : Send mediator");
        return true;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Value getReceivingSequence() {
        return this.receivingSequence;
    }

    public void setReceivingSequence(Value receivingSequence) {
        this.receivingSequence = receivingSequence;
    }

    public void init(SynapseEnvironment synapseEnvironment) {
        if (this.endpoint != null) {
            this.endpoint.init(synapseEnvironment);
        }
    }

    public void destroy() {
        if (this.endpoint != null) {
            this.endpoint.destroy();
        }
    }
}

