/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.Calendar;
import java.util.Date;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.EndpointView;
import org.apache.synapse.util.Replicator;

public class EndpointContext {
    private static final Log log = LogFactory.getLog(EndpointContext.class);
    private static final String KEY_PREFIX = "synapse.endpoint.";
    private static final String STATE = ".state";
    private static final String NEXT_RETRY_TIME = ".next_retry_time";
    private static final String REMAINING_RETRIES = ".remaining_retries";
    private static final String LAST_SUSPEND_DURATION = ".last_suspend_duration";
    public static final int ST_ACTIVE = 1;
    public static final int ST_TIMEOUT = 2;
    public static final int ST_SUSPENDED = 3;
    public static final int ST_OFF = 4;
    private int localState = 1;
    private long localNextRetryTime = -1L;
    private int localRemainingRetries = -1;
    private long localLastSuspendDuration = -1L;
    private boolean isClustered = false;
    private String endpointName = "AnonymousEndpoint";
    private ConfigurationContext cfgCtx = null;
    private EndpointDefinition definition = null;
    private EndpointView metricsBean = null;
    private final String STATE_KEY;
    private final String NEXT_RETRY_TIME_KEY;
    private final String REMAINING_RETRIES_KEY;
    private final String LAST_SUSPEND_DURATION_KEY;

    public EndpointContext(String endpointName, EndpointDefinition endpointDefinition, boolean clustered, ConfigurationContext cfgCtx, EndpointView metricsBean) {
        if (clustered) {
            if (endpointName == null && endpointDefinition != null && !endpointDefinition.isReplicationDisabled()) {
                this.handleException("For proper clustered mode operation, all endpoints should be uniquely named");
            }
            this.isClustered = true;
            this.cfgCtx = cfgCtx;
        }
        this.definition = endpointDefinition;
        if (endpointName != null) {
            this.endpointName = endpointName;
        } else if (endpointDefinition != null) {
            this.endpointName = endpointDefinition.toString();
        }
        this.metricsBean = metricsBean;
        this.STATE_KEY = KEY_PREFIX + endpointName + STATE;
        this.NEXT_RETRY_TIME_KEY = KEY_PREFIX + endpointName + NEXT_RETRY_TIME;
        this.REMAINING_RETRIES_KEY = KEY_PREFIX + endpointName + REMAINING_RETRIES;
        this.LAST_SUSPEND_DURATION_KEY = KEY_PREFIX + endpointName + LAST_SUSPEND_DURATION;
        if (this.isClustered && (endpointDefinition == null || !endpointDefinition.isReplicationDisabled())) {
            cfgCtx.setNonReplicableProperty(this.STATE_KEY, (Object)1);
        }
    }

    private void recordStatistics(int state) {
        if (this.metricsBean == null) {
            return;
        }
        switch (state) {
            case 1: {
                this.metricsBean.resetConsecutiveSuspensions();
                this.metricsBean.resetConsecutiveTimeouts();
                this.metricsBean.setSuspendedAt(null);
                this.metricsBean.setTimedoutAt(null);
                break;
            }
            case 2: {
                this.metricsBean.resetConsecutiveSuspensions();
                this.metricsBean.incrementTimeouts();
                if (this.localState == 2) break;
                this.metricsBean.setTimedoutAt(Calendar.getInstance().getTime());
                this.metricsBean.setSuspendedAt(null);
                break;
            }
            case 3: {
                this.metricsBean.resetConsecutiveTimeouts();
                this.metricsBean.incrementSuspensions();
                if (this.localState == 3) break;
                this.metricsBean.setSuspendedAt(Calendar.getInstance().getTime());
                this.metricsBean.setTimedoutAt(null);
            }
        }
    }

    private void setState(int state) {
        this.recordStatistics(state);
        if (this.isClustered) {
            Replicator.setAndReplicateState(this.STATE_KEY, state, this.cfgCtx);
            if (this.definition == null) {
                return;
            }
            switch (state) {
                case 1: {
                    Replicator.setAndReplicateState(this.REMAINING_RETRIES_KEY, this.definition.getRetriesOnTimeoutBeforeSuspend(), this.cfgCtx);
                    Replicator.setAndReplicateState(this.LAST_SUSPEND_DURATION_KEY, null, this.cfgCtx);
                    break;
                }
                case 2: {
                    Integer retries = (Integer)this.cfgCtx.getPropertyNonReplicable(this.REMAINING_RETRIES_KEY);
                    if (retries == null) {
                        retries = this.definition.getRetriesOnTimeoutBeforeSuspend();
                    }
                    if (retries <= 0) {
                        log.info((Object)("Endpoint : " + this.endpointName + " has been marked for SUSPENSION," + " but no further retries remain. Thus it will be SUSPENDED."));
                        this.setState(3);
                        break;
                    }
                    Replicator.setAndReplicateState(this.REMAINING_RETRIES_KEY, retries - 1, this.cfgCtx);
                    long nextRetry = System.currentTimeMillis() + (long)this.definition.getRetryDurationOnTimeout();
                    Replicator.setAndReplicateState(this.NEXT_RETRY_TIME_KEY, nextRetry, this.cfgCtx);
                    log.warn((Object)("Endpoint : " + this.endpointName + " is marked as TIMEOUT and " + "will be retried : " + (retries - 1) + " more time/s after : " + new Date(nextRetry) + " until its marked SUSPENDED for failure"));
                    break;
                }
                case 3: {
                    this.computeNextRetryTimeForSuspended();
                    break;
                }
                case 4: {
                    Replicator.setAndReplicateState(this.REMAINING_RETRIES_KEY, this.definition == null ? -1 : this.definition.getRetriesOnTimeoutBeforeSuspend(), this.cfgCtx);
                    Replicator.setAndReplicateState(this.LAST_SUSPEND_DURATION_KEY, null, this.cfgCtx);
                }
            }
        } else {
            this.localState = state;
            if (this.definition == null) {
                return;
            }
            switch (state) {
                case 1: {
                    this.localRemainingRetries = this.definition.getRetriesOnTimeoutBeforeSuspend();
                    this.localLastSuspendDuration = -1L;
                    break;
                }
                case 2: {
                    int retries = this.localRemainingRetries;
                    if (retries == -1) {
                        retries = this.definition.getRetriesOnTimeoutBeforeSuspend();
                    }
                    if (retries <= 0) {
                        log.info((Object)("Endpoint : " + this.endpointName + " has been marked for SUSPENSION, " + "but no further retries remain. Thus it will be SUSPENDED."));
                        this.setState(3);
                        break;
                    }
                    this.localRemainingRetries = retries - 1;
                    this.localNextRetryTime = System.currentTimeMillis() + (long)this.definition.getRetryDurationOnTimeout();
                    log.warn((Object)("Endpoint : " + this.endpointName + " is marked as TIMEOUT and " + "will be retried : " + this.localRemainingRetries + " more time/s " + "after : " + new Date(this.localNextRetryTime) + " until its marked SUSPENDED for failure"));
                    break;
                }
                case 3: {
                    this.computeNextRetryTimeForSuspended();
                    break;
                }
                case 4: {
                    this.localRemainingRetries = this.definition == null ? -1 : this.definition.getRetriesOnTimeoutBeforeSuspend();
                    this.localLastSuspendDuration = -1L;
                }
            }
        }
    }

    public void onSuccess() {
        if (this.isClustered) {
            Integer state = (Integer)this.cfgCtx.getPropertyNonReplicable(this.STATE_KEY);
            if (state != null && state != 1 && state != 4) {
                log.info((Object)("Endpoint : " + this.endpointName + " currently " + this.getStateAsString() + " will now be marked active since it processed its last message"));
                this.setState(1);
            }
        } else if (this.localState != 1 && this.localState != 4) {
            log.info((Object)("Endpoint : " + this.endpointName + " currently " + this.getStateAsString() + " will now be marked active since it processed its last message"));
            this.setState(1);
        }
    }

    public void onFault() {
        log.warn((Object)("Endpoint : " + this.endpointName + " will be marked SUSPENDED as it failed"));
        this.setState(3);
    }

    public void onTimeout() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint : " + this.endpointName + " will be marked for " + "SUSPENSION due to the occurrence of one of the configured errors"));
        }
        this.setState(2);
    }

    private void computeNextRetryTimeForSuspended() {
        long nextSuspendDuration;
        boolean notYetSuspended = true;
        long lastSuspendDuration = this.definition.getInitialSuspendDuration();
        if (this.isClustered) {
            Long lastDuration = (Long)this.cfgCtx.getPropertyNonReplicable(this.LAST_SUSPEND_DURATION_KEY);
            if (lastDuration != null) {
                lastSuspendDuration = lastDuration;
                notYetSuspended = false;
            }
        } else if (this.localLastSuspendDuration > 0L) {
            lastSuspendDuration = this.localLastSuspendDuration;
            notYetSuspended = false;
        }
        long l = nextSuspendDuration = notYetSuspended ? this.definition.getInitialSuspendDuration() : (long)((float)lastSuspendDuration * this.definition.getSuspendProgressionFactor());
        if (nextSuspendDuration > this.definition.getSuspendMaximumDuration()) {
            nextSuspendDuration = this.definition.getSuspendMaximumDuration();
        } else if (nextSuspendDuration < 0L) {
            nextSuspendDuration = 30000L;
        }
        long nextRetryTime = System.currentTimeMillis() + nextSuspendDuration;
        if (this.isClustered) {
            Replicator.setAndReplicateState(this.LAST_SUSPEND_DURATION_KEY, nextSuspendDuration, this.cfgCtx);
            Replicator.setAndReplicateState(this.NEXT_RETRY_TIME_KEY, nextRetryTime, this.cfgCtx);
        } else {
            this.localLastSuspendDuration = nextSuspendDuration;
            this.localNextRetryTime = nextRetryTime;
        }
        log.warn((Object)("Suspending endpoint : " + this.endpointName + (notYetSuspended ? " -" : " - last suspend duration was : " + lastSuspendDuration + "ms and") + " current suspend duration is : " + nextSuspendDuration + "ms - " + "Next retry after : " + new Date(nextRetryTime)));
    }

    public boolean readyToSend() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking if endpoint : " + this.endpointName + " currently at state " + this.getStateAsString() + " can be used now?"));
        }
        if (this.isClustered) {
            Integer state = (Integer)this.cfgCtx.getPropertyNonReplicable(this.STATE_KEY);
            Integer remainingRetries = (Integer)this.cfgCtx.getPropertyNonReplicable(this.REMAINING_RETRIES_KEY);
            Long nextRetryTime = (Long)this.cfgCtx.getPropertyNonReplicable(this.NEXT_RETRY_TIME_KEY);
            if (state == null) {
                return true;
            }
            if (state == 1) {
                return true;
            }
            if (state == 4) {
                return false;
            }
            if (System.currentTimeMillis() >= nextRetryTime) {
                if (state == 2) {
                    Integer n = remainingRetries;
                    Integer n2 = remainingRetries = Integer.valueOf(remainingRetries - 1);
                    Replicator.setAndReplicateState(this.REMAINING_RETRIES_KEY, remainingRetries, this.cfgCtx);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Endpoint : " + this.endpointName + " which is currently in " + "timeout state is ready to be retried. Remaining retries " + "before suspension : " + remainingRetries));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Endpoint : " + this.endpointName + " which is currently " + "SUSPENDED, is ready to be retried now"));
                }
                return true;
            }
        } else {
            if (this.localState == 1) {
                return true;
            }
            if (this.localState == 4) {
                return false;
            }
            if (System.currentTimeMillis() >= this.localNextRetryTime) {
                if (this.localState == 2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Endpoint : " + this.endpointName + " which is currently in timeout " + "state is ready to be retried. Remaining retries before " + "suspension : " + this.localRemainingRetries));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Endpoint : " + this.endpointName + " which is currently SUSPENDED," + " is ready to be retried now"));
                }
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint : " + this.endpointName + " not ready and is currently : " + this.getStateAsString() + ". Next retry will be after : " + new Date(this.localNextRetryTime)));
        }
        return false;
    }

    public void switchOff() {
        log.info((Object)("Manually switching off endpoint : " + this.endpointName));
        this.setState(4);
    }

    public void switchOn() {
        log.info((Object)("Manually activating endpoint : " + this.endpointName));
        this.setState(1);
    }

    public boolean isState(int s) {
        if (this.isClustered) {
            Integer state = (Integer)this.cfgCtx.getPropertyNonReplicable(this.STATE_KEY);
            return state == null || state == s;
        }
        return this.localState == s;
    }

    private String getStateAsString() {
        Integer state = this.localState;
        if (this.isClustered && (state = (Integer)this.cfgCtx.getPropertyNonReplicable(this.STATE_KEY)) == null) {
            return "ACTIVE";
        }
        switch (state) {
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "TIMEOUT";
            }
            case 3: {
                return "SUSPENDED";
            }
            case 4: {
                return "MAINTNENCE";
            }
        }
        return "UNKNOWN";
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ Name : ").append(this.endpointName).append(" ] [ State : ").append(this.getStateAsString()).append(" ]");
        return sb.toString();
    }
}

