/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.builtin.RMSequenceMediator;
import org.jaxen.JaxenException;

public class RMSequenceMediatorFactory
extends AbstractMediatorFactory {
    private static final QName SEQUENCE_Q = new QName("http://ws.apache.org/ns/synapse", "RMSequence");
    private static final QName ATT_CORR = new QName("correlation");
    private static final QName ATT_LASTMSG = new QName("last-message");
    private static final QName ATT_VERSION = new QName("version");
    private static final QName ATT_SINGLE = new QName("single");

    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        RMSequenceMediator sequenceMediator = new RMSequenceMediator();
        OMAttribute correlation = elem.getAttribute(ATT_CORR);
        OMAttribute lastMessage = elem.getAttribute(ATT_LASTMSG);
        OMAttribute single = elem.getAttribute(ATT_SINGLE);
        OMAttribute version = elem.getAttribute(ATT_VERSION);
        if (single == null && correlation == null) {
            String msg = "The 'single' attribute value of true or a 'correlation' attribute is required for the configuration of a RMSequence mediator";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        if (correlation != null) {
            if (correlation.getAttributeValue() != null && correlation.getAttributeValue().trim().length() == 0) {
                String msg = "Invalid attribute value specified for correlation";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            try {
                sequenceMediator.setCorrelation(SynapseXPathFactory.getSynapseXPath(elem, ATT_CORR));
            }
            catch (JaxenException e) {
                String msg = "Invalid XPath expression for attribute correlation : " + correlation.getAttributeValue();
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
        }
        if (single != null) {
            sequenceMediator.setSingle(Boolean.valueOf(single.getAttributeValue()));
        }
        if (sequenceMediator.isSingle() && sequenceMediator.getCorrelation() != null) {
            String msg = "Invalid RMSequence mediator. A RMSequence can't have both a single attribute value of true and a correlation attribute specified.";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        if (!sequenceMediator.isSingle() && sequenceMediator.getCorrelation() == null) {
            String msg = "Invalid RMSequence mediator. A RMSequence must have a single attribute value of true or a correlation attribute specified.";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        if (lastMessage != null) {
            if (lastMessage.getAttributeValue() != null && lastMessage.getAttributeValue().trim().length() == 0) {
                String msg = "Invalid attribute value specified for last-message";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            try {
                sequenceMediator.setLastMessage(SynapseXPathFactory.getSynapseXPath(elem, ATT_LASTMSG));
            }
            catch (JaxenException e) {
                String msg = "Invalid XPath expression for attribute last-message : " + lastMessage.getAttributeValue();
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
        }
        if (sequenceMediator.isSingle() && sequenceMediator.getLastMessage() != null) {
            String msg = "Invalid RMSequence mediator. A RMSequence can't have both a single attribute value of true and a last-message attribute specified.";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        if (version != null) {
            if (!"1.0".equals(version.getAttributeValue()) && !"1.1".equals(version.getAttributeValue())) {
                String msg = "Only '1.0' or '1.1' values are allowed for attribute version for a RMSequence mediator, Unsupported version " + version.getAttributeValue();
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            sequenceMediator.setVersion(version.getAttributeValue());
        }
        this.processAuditStatus(sequenceMediator, elem);
        return sequenceMediator;
    }

    public QName getTagQName() {
        return SEQUENCE_Q;
    }
}

