/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.config.xml.IEntryFactory;

public class EntryFactory
implements XMLToObjectMapper {
    private static Log log = LogFactory.getLog(EntryFactory.class);
    private static final QName DESCRIPTION_Q = new QName("http://ws.apache.org/ns/synapse", "description");

    public static Entry createEntry(OMElement elem, Properties properties) {
        String src;
        OMAttribute key;
        String customFactory = SynapsePropertiesLoader.getPropertyValue("synapse.entry.factory", "");
        if (customFactory != null && !"".equals(customFactory)) {
            try {
                Class<?> c = Class.forName(customFactory);
                Object o = c.newInstance();
                if (o instanceof IEntryFactory) {
                    return ((IEntryFactory)o).createEntry(elem);
                }
            }
            catch (ClassNotFoundException e) {
                EntryFactory.handleException("Class specified by the synapse.entry.factory synapse property not found: " + customFactory, e);
            }
            catch (InstantiationException e) {
                EntryFactory.handleException("Class specified by the synapse.entry.factory synapse property cannot be instantiated: " + customFactory, e);
            }
            catch (IllegalAccessException e) {
                EntryFactory.handleException("Class specified by the synapse.entry.factory synapse property cannot be accessed: " + customFactory, e);
            }
        }
        if ((key = elem.getAttribute(new QName("", "key"))) == null) {
            EntryFactory.handleException("The 'key' attribute is required for a local registry entry");
            return null;
        }
        Entry entry = new Entry(key.getAttributeValue());
        OMElement descriptionElem = elem.getFirstChildWithName(DESCRIPTION_Q);
        if (descriptionElem != null) {
            entry.setDescription(descriptionElem.getText());
            descriptionElem.detach();
        }
        if ((src = elem.getAttributeValue(new QName("", "src"))) != null) {
            try {
                entry.setSrc(new URL(src.trim()));
                entry.setType(2);
                entry.setValue(SynapseConfigUtils.getObject(entry.getSrc(), properties));
            }
            catch (MalformedURLException e) {
                EntryFactory.handleException("The entry with key : " + key + " refers to an invalid URL");
            }
        } else {
            OMNode nodeValue = elem.getFirstOMChild();
            OMElement elemValue = elem.getFirstElement();
            if (elemValue != null) {
                entry.setType(1);
                entry.setValue(elemValue);
            } else if (nodeValue != null && nodeValue instanceof OMText) {
                entry.setType(0);
                entry.setValue(elem.getText());
            }
        }
        return entry;
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public Object getObjectFromOMNode(OMNode om, Properties properties) {
        if (om instanceof OMElement) {
            return EntryFactory.createEntry((OMElement)om, properties);
        }
        EntryFactory.handleException("Invalid XML configuration for an Entry. OMElement expected");
        return null;
    }
}

