/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.format.BinaryBuilder;
import org.apache.axis2.format.PlainTextBuilder;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.JmxAdapter;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseController;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.datasource.DataSourceInformationRepository;
import org.apache.synapse.commons.datasource.DataSourceRepositoryHolder;
import org.apache.synapse.commons.jmx.JmxInformation;
import org.apache.synapse.commons.jmx.JmxInformationFactory;
import org.apache.synapse.commons.util.RMIRegistryController;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapseConfigurationBuilder;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2TransportHelper;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.core.axis2.SynapseDispatcher;
import org.apache.synapse.core.axis2.SynapseMessageReceiver;
import org.apache.synapse.core.axis2.SynapseMustUnderstandHandler;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.securevault.secret.SecretCallbackHandler;
import org.apache.synapse.securevault.secret.handler.SharedSecretCallbackHandlerCache;
import org.apache.synapse.task.SynapseTaskManager;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.apache.synapse.task.TaskScheduler;
import org.apache.synapse.util.xpath.ext.SynapseXpathFunctionContextProvider;
import org.apache.synapse.util.xpath.ext.SynapseXpathVariableResolver;
import org.apache.synapse.util.xpath.ext.XpathExtensionUtil;

public class Axis2SynapseController
implements SynapseController {
    private static final Log log = LogFactory.getLog(Axis2SynapseController.class);
    private static final String JMX_AGENT_NAME = "jmx.agent.name";
    private ListenerManager listenerManager;
    private ConfigurationContext configurationContext;
    protected SynapseConfiguration synapseConfiguration;
    protected SynapseEnvironment synapseEnvironment;
    private boolean initialized;
    protected ServerConfigurationInformation serverConfigurationInformation;
    protected ServerContextInformation serverContextInformation;
    private JmxAdapter jmxAdapter;
    private TaskDescriptionRepository taskDescriptionRepository;
    private TaskScheduler taskScheduler;

    public void init(ServerConfigurationInformation serverConfigurationInformation, ServerContextInformation serverContextInformation) {
        log.info((Object)("Initializing Synapse at : " + new Date()));
        if (serverConfigurationInformation == null) {
            throw new IllegalArgumentException("ServerConfigurationInformation cannot be null");
        }
        if (serverContextInformation == null) {
            throw new IllegalArgumentException("ServerContextInformation cannot be null");
        }
        this.serverConfigurationInformation = serverConfigurationInformation;
        this.serverContextInformation = serverContextInformation;
        if (System.getProperty(JMX_AGENT_NAME) == null) {
            System.setProperty(JMX_AGENT_NAME, "org.apache.synapse");
        }
        if (serverContextInformation.getServerContext() == null || serverConfigurationInformation.isCreateNewInstance()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing Synapse in a new axis2 server environment instance");
            }
            this.createNewInstance(serverConfigurationInformation);
        } else {
            Object context = serverContextInformation.getServerContext();
            if (context instanceof ConfigurationContext) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Initializing Synapse in an already existing axis2 server environment instance");
                }
                this.configurationContext = (ConfigurationContext)context;
                this.configurationContext.setProperty("addressing.validateAction", (Object)Boolean.FALSE);
            } else {
                this.handleFatal("Synapse startup initialization failed : Provided server context is invalid, expected an Axis2 ConfigurationContext instance");
            }
        }
        serverContextInformation.setServerContext(this.configurationContext);
        Parameter serverContextParameter = new Parameter("synapse.server.context.info", (Object)serverContextInformation);
        Parameter serverConfigParameter = new Parameter("synapse.server.config.info", (Object)serverConfigurationInformation);
        try {
            this.configurationContext.getAxisConfiguration().addParameter(serverContextParameter);
            this.configurationContext.getAxisConfiguration().addParameter(serverConfigParameter);
        }
        catch (AxisFault ignored) {
            log.fatal((Object)"Error adding the parameter to the Axis Configuration");
        }
        Object repo = serverContextInformation.getProperty("task_description_repository");
        Object taskScheduler = serverContextInformation.getProperty("task_scheduler");
        if (repo != null && repo instanceof TaskDescriptionRepository) {
            this.taskDescriptionRepository = (TaskDescriptionRepository)repo;
        }
        if (taskScheduler != null && taskScheduler instanceof TaskScheduler) {
            this.taskScheduler = (TaskScheduler)taskScheduler;
        }
        this.addDefaultBuildersAndFormatters(this.configurationContext.getAxisConfiguration());
        this.deployMediatorExtensions();
        this.initDataSourceHelper(serverContextInformation);
        this.initSharedSecretCallbackHandlerCache(serverContextInformation);
        this.initialized = true;
    }

    private void initXpathExtensions() {
        Axis2SynapseEnvironment axis2SynapseEnvironment = (Axis2SynapseEnvironment)this.synapseEnvironment;
        List<SynapseXpathFunctionContextProvider> functionExtensions = XpathExtensionUtil.getRegisteredFunctionExtensions();
        for (SynapseXpathFunctionContextProvider functionExtension : functionExtensions) {
            axis2SynapseEnvironment.setXpathFunctionExtensions(functionExtension);
        }
        List<SynapseXpathVariableResolver> variableExtensions = XpathExtensionUtil.getRegisteredVariableExtensions();
        for (SynapseXpathVariableResolver variableExtension : variableExtensions) {
            axis2SynapseEnvironment.setXpathVariableExtensions(variableExtension);
        }
    }

    public void destroy() {
        try {
            if (this.serverConfigurationInformation.isCreateNewInstance()) {
                if (this.listenerManager != null) {
                    this.listenerManager.destroy();
                }
                this.stopJmxAdapter();
                RMIRegistryController.getInstance().shutDown();
                if (this.configurationContext != null) {
                    this.configurationContext.terminate();
                }
            }
            this.initialized = false;
        }
        catch (Exception e) {
            log.error((Object)"Error stopping the Axis2 Based Server Environment", (Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void start() {
        if (this.configurationContext != null) {
            List inflowPhases = this.configurationContext.getAxisConfiguration().getInFlowPhases();
            for (Phase inPhase : inflowPhases) {
                if (!"Dispatch".equals(inPhase.getPhaseName())) continue;
                try {
                    inPhase.addHandler(this.prepareSynapseDispatcher());
                    inPhase.addHandler(this.prepareMustUnderstandHandler());
                }
                catch (PhaseException e) {
                    this.handleFatal("Couldn't start Synapse, Cannot add the required Synapse handlers", e);
                }
            }
        } else {
            this.handleFatal("Couldn't start Synapse, ConfigurationContext not found");
        }
        if (this.serverConfigurationInformation.isCreateNewInstance()) {
            if (this.listenerManager != null) {
                this.listenerManager.start();
            } else {
                this.handleFatal("Couldn't start Synapse, ListenerManager not found");
            }
            if (this.jmxAdapter != null && this.jmxAdapter.isRunning()) {
                log.info((Object)("Management using JMX available via: " + this.jmxAdapter.getJmxInformation().getJmxUrl()));
            }
        }
    }

    public void startMaintenance() {
        log.info((Object)"Putting transport listeners, senders and tasks into maintenance mode..");
        Axis2TransportHelper transportHelper = new Axis2TransportHelper(this.configurationContext);
        transportHelper.pauseListeners();
        transportHelper.pauseSenders();
        SynapseTaskManager synapseTaskManager = this.synapseEnvironment.getTaskManager();
        if (synapseTaskManager.isInitialized()) {
            synapseTaskManager.pauseAll();
        }
        log.info((Object)"Entered maintenance mode");
    }

    public void endMaintenance() {
        log.info((Object)"Resuming transport listeners, senders and tasks from maintenance mode...");
        Axis2TransportHelper transportHelper = new Axis2TransportHelper(this.configurationContext);
        transportHelper.resumeListeners();
        transportHelper.resumeSenders();
        SynapseTaskManager synapseTaskManager = this.synapseEnvironment.getTaskManager();
        if (synapseTaskManager.isInitialized()) {
            synapseTaskManager.resumeAll();
        }
        log.info((Object)"Resumed normal operation from maintenance mode");
    }

    public void stop() {
        try {
            SynapseTaskManager synapseTaskManager = this.synapseEnvironment.getTaskManager();
            if (synapseTaskManager.isInitialized()) {
                synapseTaskManager.cleanup();
            }
            if (this.listenerManager != null) {
                this.listenerManager.stop();
            }
            if (this.configurationContext != null) {
                List inflowPhases = this.configurationContext.getAxisConfiguration().getInFlowPhases();
                for (Phase inPhase : inflowPhases) {
                    if (!"Dispatch".equals(inPhase.getPhaseName())) continue;
                    ArrayList<HandlerDescription> synapseHandlers = new ArrayList<HandlerDescription>();
                    for (Handler handler : inPhase.getHandlers()) {
                        if (!"SynapseDispatcher".equals(handler.getName()) && !"SynapseMustUnderstandHandler".equals(handler.getName())) continue;
                        synapseHandlers.add(handler.getHandlerDesc());
                    }
                    for (HandlerDescription handlerMD : synapseHandlers) {
                        inPhase.removeHandler(handlerMD);
                    }
                }
            } else {
                this.handleException("Couldn't detach the Synapse handlers, ConfigurationContext not found.");
            }
            if (this.serverConfigurationInformation.isCreateNewInstance() && this.configurationContext != null && this.configurationContext.getAxisConfiguration() != null) {
                HashMap serviceMap = this.configurationContext.getAxisConfiguration().getServices();
                for (AxisService svc : serviceMap.values()) {
                    svc.setActive(false);
                }
                HashMap moduleMap = this.configurationContext.getAxisConfiguration().getModules();
                for (AxisModule mod : moduleMap.values()) {
                    if (mod.getModule() == null || "synapse".equals(mod.getName())) continue;
                    mod.getModule().shutdown(this.configurationContext);
                }
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error stopping the Axis2 Environment");
        }
    }

    public SynapseEnvironment createSynapseEnvironment() {
        try {
            this.deploySynapseService();
            this.deployProxyServices();
            this.deployEventSources();
        }
        catch (AxisFault axisFault) {
            log.fatal((Object)"Synapse startup failed...", (Throwable)axisFault);
            throw new SynapseException("Synapse startup failed", axisFault);
        }
        this.synapseEnvironment = new Axis2SynapseEnvironment(this.configurationContext, this.synapseConfiguration, this.serverContextInformation);
        MessageContextCreatorForAxis2.setSynEnv(this.synapseEnvironment);
        Parameter synapseEnvironmentParameter = new Parameter("synapse.env", (Object)this.synapseEnvironment);
        try {
            this.configurationContext.getAxisConfiguration().addParameter(synapseEnvironmentParameter);
        }
        catch (AxisFault e) {
            this.handleFatal("Could not set parameter 'synapse.env' to the Axis2 configuration : " + e.getMessage(), e);
        }
        this.synapseEnvironment.getTaskManager().init(this.taskDescriptionRepository, this.taskScheduler);
        this.synapseConfiguration.init(this.synapseEnvironment);
        this.synapseEnvironment.setInitialized(true);
        this.initXpathExtensions();
        return this.synapseEnvironment;
    }

    public void destroySynapseEnvironment() {
        if (this.synapseEnvironment != null) {
            try {
                this.undeploySynapseService();
                this.undeployProxyServices();
                this.undeployEventSources();
            }
            catch (AxisFault e) {
                this.handleFatal("Error while shutting down the Synapse environment", e);
            }
            this.synapseEnvironment.setInitialized(false);
        }
    }

    public SynapseConfiguration createSynapseConfiguration() {
        String synapseXMLLocation = this.serverConfigurationInformation.getSynapseXMLLocation();
        Properties properties = SynapsePropertiesLoader.loadSynapseProperties();
        if (this.serverConfigurationInformation.getResolveRoot() != null) {
            properties.put("resolve.root", this.serverConfigurationInformation.getResolveRoot());
        }
        if (this.serverConfigurationInformation.getSynapseHome() != null) {
            properties.put("synapse.home", this.serverConfigurationInformation.getSynapseHome());
        }
        if (synapseXMLLocation != null) {
            this.synapseConfiguration = SynapseConfigurationBuilder.getConfiguration(synapseXMLLocation, properties);
        } else {
            log.warn((Object)"System property or init-parameter 'synapse.xml' is not specified. Using default configuration..");
            this.synapseConfiguration = SynapseConfigurationBuilder.getDefaultConfiguration();
        }
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.synapseConfiguration.setProperty(key, properties.getProperty(key));
        }
        this.synapseConfiguration.setAxisConfiguration(this.configurationContext.getAxisConfiguration());
        MessageContextCreatorForAxis2.setSynConfig(this.synapseConfiguration);
        Parameter synapseConfigurationParameter = new Parameter("synapse.config", (Object)this.synapseConfiguration);
        try {
            this.configurationContext.getAxisConfiguration().addParameter(synapseConfigurationParameter);
        }
        catch (AxisFault e) {
            this.handleFatal("Could not set parameters 'synapse.config' to the Axis2 configuration : " + e.getMessage(), e);
        }
        this.addServerIPAndHostEntries();
        return this.synapseConfiguration;
    }

    public void destroySynapseConfiguration() {
        if (this.synapseConfiguration != null) {
            this.synapseConfiguration.destroy();
            this.synapseConfiguration = null;
        }
    }

    public boolean waitUntilSafeToStop(long waitIntervalMillis, long endTime) {
        boolean safeToStop = false;
        boolean forcefulStop = false;
        Axis2TransportHelper transportHelper = new Axis2TransportHelper(this.configurationContext);
        while (!safeToStop && !forcefulStop) {
            int activeConnections;
            int pendingSenderThreads;
            int pendingListenerThreads = transportHelper.getPendingListenerThreadCount();
            if (pendingListenerThreads > 0) {
                log.info((Object)("Waiting for: " + pendingListenerThreads + " listener threads to complete"));
            }
            if ((pendingSenderThreads = transportHelper.getPendingSenderThreadCount()) > 0) {
                log.info((Object)("Waiting for: " + pendingSenderThreads + " listener threads to complete"));
            }
            if ((activeConnections = transportHelper.getActiveConnectionsCount()) > 0) {
                log.info((Object)("Waiting for: " + activeConnections + " active connections to be closed.."));
            }
            int pendingTransportThreads = pendingListenerThreads + pendingSenderThreads;
            int pendingCallbacks = this.serverContextInformation.getCallbackCount();
            if (pendingCallbacks > 0) {
                log.info((Object)("Waiting for: " + pendingCallbacks + " callbacks/replies.."));
            }
            int runningTasks = 0;
            SynapseTaskManager synapseTaskManager = this.synapseEnvironment.getTaskManager();
            if (synapseTaskManager.isInitialized() && (runningTasks = synapseTaskManager.getTaskScheduler().getRunningTaskCount()) > 0) {
                log.info((Object)("Waiting for : " + runningTasks + " tasks to complete.."));
            }
            boolean bl = safeToStop = pendingTransportThreads + pendingCallbacks + runningTasks == 0;
            if (safeToStop) {
                log.info((Object)"All transport threads and tasks are idle and no pending callbacks..");
                continue;
            }
            if (System.currentTimeMillis() < endTime) {
                log.info((Object)("Waiting for a maximum of another " + (endTime - System.currentTimeMillis()) / 1000L + " seconds until transport threads and tasks become idle, " + "active connections to get closed," + " and callbacks to be completed.."));
                try {
                    Thread.sleep(waitIntervalMillis);
                }
                catch (InterruptedException ignore) {}
                continue;
            }
            forcefulStop = true;
        }
        return !forcefulStop;
    }

    public Object getContext() {
        return this.configurationContext;
    }

    private void createNewInstance(ServerConfigurationInformation serverConfigurationInformation) {
        try {
            this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)serverConfigurationInformation.getAxis2RepoLocation(), (String)serverConfigurationInformation.getAxis2Xml());
            this.configurationContext.setProperty("addressing.validateAction", (Object)Boolean.FALSE);
            this.startJmxAdapter();
            this.listenerManager = this.configurationContext.getListenerManager();
            if (this.listenerManager == null) {
                this.listenerManager = new ListenerManager();
                this.listenerManager.init(this.configurationContext);
            }
            this.listenerManager.setShutdownHookRequired(false);
        }
        catch (Throwable t) {
            this.handleFatal("Failed to create a new Axis2 instance...", t);
        }
    }

    private void deploySynapseService() throws AxisFault {
        log.info((Object)"Deploying the Synapse service...");
        AxisConfiguration axisCfg = this.configurationContext.getAxisConfiguration();
        AxisService synapseService = new AxisService("__SynapseService");
        InOutAxisOperation mediateOperation = new InOutAxisOperation(SynapseConstants.SYNAPSE_OPERATION_NAME);
        mediateOperation.setMessageReceiver((MessageReceiver)new SynapseMessageReceiver());
        synapseService.addOperation((AxisOperation)mediateOperation);
        ArrayList<String> transports = new ArrayList<String>();
        transports.add("http");
        transports.add("https");
        synapseService.setExposedTransports(transports);
        AxisServiceGroup synapseServiceGroup = new AxisServiceGroup(axisCfg);
        synapseServiceGroup.setServiceGroupName("__SynapseService");
        synapseServiceGroup.addParameter("hiddenService", (Object)"true");
        synapseServiceGroup.addService(synapseService);
        axisCfg.addServiceGroup(synapseServiceGroup);
    }

    private void undeploySynapseService() throws AxisFault {
        log.info((Object)"Undeploying the Synapse service...");
        this.configurationContext.getAxisConfiguration().removeService("__SynapseService");
    }

    private void deployProxyServices() {
        boolean failSafeProxyEnabled = SynapseConfigUtils.isFailSafeEnabled("proxyservices");
        log.info((Object)"Deploying Proxy services...");
        String thisServerName = this.serverConfigurationInformation.getServerName();
        if ((thisServerName == null || "".equals(thisServerName)) && ((thisServerName = this.serverConfigurationInformation.getHostName()) == null || "".equals(thisServerName))) {
            thisServerName = "localhost";
        }
        for (ProxyService proxy : this.synapseConfiguration.getProxyServices()) {
            List pinnedServers = proxy.getPinnedServers();
            if (pinnedServers != null && !pinnedServers.isEmpty() && !pinnedServers.contains(thisServerName)) {
                log.info((Object)("Server name not in pinned servers list. Not deploying Proxy service : " + proxy.getName()));
                continue;
            }
            try {
                AxisService proxyService = proxy.buildAxisService(this.synapseConfiguration, this.configurationContext.getAxisConfiguration());
                if (proxyService != null) {
                    log.info((Object)("Deployed Proxy service : " + proxy.getName()));
                    if (proxy.isStartOnLoad()) continue;
                    proxy.stop(this.synapseConfiguration);
                    continue;
                }
                log.warn((Object)("The proxy service " + proxy.getName() + " will NOT be available"));
            }
            catch (SynapseException e) {
                if (failSafeProxyEnabled) {
                    log.warn((Object)("The proxy service " + proxy.getName() + " cannot be deployed - " + "Continue in Proxy Service fail-safe mode."));
                    continue;
                }
                this.handleException("The proxy service " + proxy.getName() + " : Deployment Error");
            }
        }
    }

    private void undeployProxyServices() throws AxisFault {
        log.info((Object)"Undeploying Proxy services...");
        for (ProxyService proxy : this.synapseConfiguration.getProxyServices()) {
            this.configurationContext.getAxisConfiguration().removeService(proxy.getName());
        }
    }

    private void deployMediatorExtensions() {
        log.info((Object)"Loading mediator extensions...");
        AxisConfigurator configurator = this.configurationContext.getAxisConfiguration().getConfigurator();
        if (configurator instanceof DeploymentEngine) {
            ((DeploymentEngine)configurator).getRepoListener().checkServices();
        } else {
            log.warn((Object)"Unable to access the repository listener. Custom extensions will not get loaded now!");
        }
    }

    private void deployEventSources() throws AxisFault {
        log.info((Object)"Deploying EventSources...");
        for (SynapseEventSource eventSource : this.synapseConfiguration.getEventSources()) {
            eventSource.buildService(this.configurationContext.getAxisConfiguration());
        }
    }

    private void undeployEventSources() throws AxisFault {
        log.info((Object)"Undeploying EventSources...");
        for (SynapseEventSource eventSource : this.synapseConfiguration.getEventSources()) {
            this.configurationContext.getAxisConfiguration().removeService(eventSource.getName());
        }
    }

    private void initDataSourceHelper(ServerContextInformation serverContextInformation) {
        DataSourceRepositoryHolder repositoryHolder = DataSourceRepositoryHolder.getInstance();
        Properties synapseProperties = SynapsePropertiesLoader.reloadSynapseProperties();
        Object repo = serverContextInformation.getProperty("DataSourceInformationRepository");
        if (repo instanceof DataSourceInformationRepository) {
            repositoryHolder.init((DataSourceInformationRepository)repo, synapseProperties);
        } else {
            repositoryHolder.init(null, synapseProperties);
        }
    }

    private void initSharedSecretCallbackHandlerCache(ServerContextInformation information) {
        SharedSecretCallbackHandlerCache cache = SharedSecretCallbackHandlerCache.getInstance();
        Object handler = information.getProperty("SharedSecretCallbackHandler");
        if (handler instanceof SecretCallbackHandler) {
            cache.setSecretCallbackHandler((SecretCallbackHandler)handler);
        }
    }

    private void addDefaultBuildersAndFormatters(AxisConfiguration axisConf) {
        if (axisConf.getMessageBuilder("text/plain") == null) {
            axisConf.addMessageBuilder("text/plain", (Builder)new PlainTextBuilder());
        }
        if (axisConf.getMessageBuilder("application/octet-stream") == null) {
            axisConf.addMessageBuilder("application/octet-stream", (Builder)new BinaryBuilder());
        }
    }

    private void addServerIPAndHostEntries() {
        Entry entry;
        String hostName = this.serverConfigurationInformation.getHostName();
        String ipAddress = this.serverConfigurationInformation.getIpAddress();
        if (hostName != null && !"".equals(hostName)) {
            entry = new Entry("SERVER_HOST");
            entry.setValue(hostName);
            this.synapseConfiguration.addEntry("SERVER_HOST", entry);
        }
        if (ipAddress != null && !"".equals(ipAddress)) {
            Parameter bindAddressParam;
            TransportInDescription transportInDescription;
            HashMap transportInConfigMap;
            entry = new Entry("SERVER_IP");
            entry.setValue(ipAddress);
            if (this.synapseConfiguration.getAxisConfiguration().getTransportsIn() != null && (transportInConfigMap = this.synapseConfiguration.getAxisConfiguration().getTransportsIn()) != null && (transportInDescription = (TransportInDescription)transportInConfigMap.get("http")) != null && (bindAddressParam = transportInDescription.getParameter("bind-address")) != null) {
                entry.setValue(bindAddressParam.getValue());
            }
            this.synapseConfiguration.addEntry("SERVER_IP", entry);
        }
    }

    private HandlerDescription prepareSynapseDispatcher() {
        HandlerDescription handlerMD = new HandlerDescription("SynapseDispatcher");
        PhaseRule rule = new PhaseRule("Dispatch");
        rule.setAfter("SOAPMessageBodyBasedDispatcher");
        handlerMD.setRules(rule);
        SynapseDispatcher synapseDispatcher = new SynapseDispatcher();
        synapseDispatcher.initDispatcher();
        handlerMD.setHandler((Handler)synapseDispatcher);
        return handlerMD;
    }

    private HandlerDescription prepareMustUnderstandHandler() {
        HandlerDescription handlerMD = new HandlerDescription("SynapseMustUnderstandHandler");
        PhaseRule rule = new PhaseRule("Dispatch");
        rule.setAfter("SynapseDispatcher");
        handlerMD.setRules(rule);
        SynapseMustUnderstandHandler synapseMustUnderstandHandler = new SynapseMustUnderstandHandler();
        synapseMustUnderstandHandler.init(handlerMD);
        handlerMD.setHandler((Handler)synapseMustUnderstandHandler);
        return handlerMD;
    }

    private void startJmxAdapter() {
        Properties synapseProperties = SynapsePropertiesLoader.loadSynapseProperties();
        JmxInformation jmxInformation = JmxInformationFactory.createJmxInformation((Properties)synapseProperties, (String)this.serverConfigurationInformation.getHostName());
        if (jmxInformation.getJndiPort() != -1) {
            this.jmxAdapter = new JmxAdapter(jmxInformation);
            this.jmxAdapter.start();
        }
    }

    private void stopJmxAdapter() {
        if (this.jmxAdapter != null) {
            this.jmxAdapter.stop();
        }
    }

    private void handleFatal(String msg, Throwable e) {
        log.fatal((Object)msg, e);
        throw new SynapseException(msg, e);
    }

    private void handleFatal(String msg) {
        log.fatal((Object)msg);
        throw new SynapseException(msg);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

