/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatorContext {
    private String url;
    private Map<String, String> headers;
    private Map<String, String> params;
    private MessageContext messageContext;
    private Map<String, Object> properties;

    public EvaluatorContext(String url, Map<String, String> headers) {
        this.url = url;
        this.headers = headers;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getParam(String name) throws UnsupportedEncodingException {
        if (this.params == null) {
            String queryString;
            this.params = new HashMap<String, String>();
            int i = this.url.indexOf("?");
            if (i > -1 && (queryString = this.url.substring(i + 1)) != null && !queryString.equals("")) {
                String[] httpParams = queryString.split("&");
                if (httpParams == null || httpParams.length == 0) {
                    return "";
                }
                for (String param : httpParams) {
                    String[] temp = param.split("=");
                    if (temp == null || temp.length < 2) continue;
                    this.params.put(temp[0], URIEncoderDecoder.decode((String)temp[1]));
                }
            }
        }
        return this.params.get(name);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    public Object getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

