/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource;

import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.commons.datasource.DBPoolViewMBean;

public class DBPoolView
implements DBPoolViewMBean {
    private int numActive = 0;
    private int numIdle = 0;
    private final Map<String, Long> connectionsUsage = new HashMap<String, Long>();
    private String name;

    public DBPoolView(String name) {
        this.name = name;
    }

    public int getNumActive() {
        return this.numActive;
    }

    public void setNumActive(int numActive) {
        this.numActive = numActive;
    }

    public int getNumIdle() {
        return this.numIdle;
    }

    public void setNumIdle(int numIdle) {
        this.numIdle = numIdle;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void updateConnectionUsage(String connectionID) {
        if (connectionID != null && !"".equals(connectionID)) {
            Long currentUsage = this.connectionsUsage.get(connectionID);
            if (currentUsage != null) {
                currentUsage = currentUsage + 1L;
                this.connectionsUsage.put(connectionID, currentUsage);
            } else {
                this.connectionsUsage.put(connectionID, 1L);
            }
        }
    }

    public Map getConnectionUsage() {
        return this.connectionsUsage;
    }

    public void reset() {
        this.numActive = 0;
        this.numIdle = 0;
        this.connectionsUsage.clear();
    }
}

