/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.nhttp.util.GzipMessageFormatterDecorator;

public class MessageFormatterDecoratorFactory {
    private static final Log log = LogFactory.getLog(MessageFormatterDecoratorFactory.class);
    private static final String GZIP_CODEC = "gzip";

    public static MessageFormatter createMessageFormatterDecorator(MessageContext msgContext) {
        if (msgContext == null) {
            throw new IllegalArgumentException("Message Context cannot be null");
        }
        try {
            Map headers;
            String encode;
            MessageFormatter formatter = TransportUtils.getMessageFormatter((MessageContext)msgContext);
            Object o = msgContext.getProperty("TRANSPORT_HEADERS");
            if (o != null && o instanceof Map && (encode = (String)(headers = (Map)o).get("Content-Encoding")) != null && GZIP_CODEC.equals(encode)) {
                formatter = new GzipMessageFormatterDecorator(formatter);
            }
            return formatter;
        }
        catch (AxisFault axisFault) {
            String msg = "Cannot find a suitable MessageFormatter : " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            return null;
        }
    }
}

