/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.synapse.transport.nhttp.AccessLogger;
import org.apache.synapse.transport.nhttp.util.AccessTimeUtil;

public class Access {
    private static Log log = LogFactory.getLog(Access.class);
    protected AccessLogElement[] logElements = null;
    protected String pattern = "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"";
    private static AccessLogger accessLogger;
    private static ConcurrentLinkedQueue<HttpRequest> requestQueue;
    private static ConcurrentLinkedQueue<HttpResponse> responseQueue;
    private static final int LOG_FREQUENCY_IN_SECONDS = 30;

    public Access(Log log, AccessLogger accessLogger) {
        Access.log = log;
        Access.accessLogger = accessLogger;
        requestQueue = new ConcurrentLinkedQueue();
        responseQueue = new ConcurrentLinkedQueue();
        this.logElements = this.createLogElements();
        this.logAccesses();
    }

    public void addAccessToQueue(HttpRequest request) {
        requestQueue.add(request);
    }

    public void addAccessToQueue(HttpResponse response) {
        responseQueue.add(response);
    }

    public void logAccesses() {
        LogRequests logRequests = new LogRequests();
        LogResponses logResponses = new LogResponses();
        Timer requestTimer = new Timer();
        Timer responseTimer = new Timer();
        long retryIn = 30000L;
        requestTimer.schedule((TimerTask)logRequests, 0L, retryIn);
        responseTimer.schedule((TimerTask)logResponses, 0L, retryIn);
    }

    public void log(HttpRequest request, HttpResponse response) {
        Date date = AccessTimeUtil.getDate();
        StringBuilder result = new StringBuilder(128);
        for (AccessLogElement logElement : this.logElements) {
            logElement.addElement(result, date, request, response);
        }
        String logString = result.toString();
        log.debug((Object)logString);
        accessLogger.log(logString);
    }

    protected static String getHeaderValues(HttpMessage message, String name) {
        int length = 0;
        Header[] header = new Header[]{};
        StringBuffer headerValue = new StringBuffer();
        try {
            header = message.getHeaders(name);
            length = header.length;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (length == 0) {
            return "-";
        }
        if (length == 1) {
            return header[0].getValue();
        }
        headerValue.append(header[0].getValue());
        for (int i = 1; i < length; ++i) {
            headerValue.append(" - ").append(header[i].getValue());
        }
        return headerValue.toString();
    }

    public static String getHostElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Host");
    }

    public static String getLogicalUserNameElement(HttpMessage message) {
        if (message != null) {
            return "-";
        }
        return "";
    }

    public static String getUserNameElement(HttpMessage message) {
        return Access.getHeaderValues(message, "From");
    }

    public static String getCookieElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Cookie");
    }

    public static String getRefererElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Referer");
    }

    public static String getUserAgentElement(HttpMessage message) {
        return Access.getHeaderValues(message, "User-Agent");
    }

    public static String getAcceptElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Accept");
    }

    public static String getAcceptLanguageElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Accept-Language");
    }

    public static String getAcceptEncodingElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Accept-Encoding");
    }

    public static String getAcceptCharSetElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Accept-Charset");
    }

    public static String getConnectionElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Connection");
    }

    public static String getContentTypeElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Content-Type");
    }

    public static String getKeepAliveElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Keep-Alive");
    }

    public static String getTransferEncodingElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Transfer-Encoding");
    }

    public static String getContentEncodingElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Content-Encoding");
    }

    public static String getVaryElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Vary");
    }

    public static String getServerElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Server");
    }

    protected AccessLogElement[] createLogElements() {
        ArrayList<AccessLogElement> list = new ArrayList<AccessLogElement>();
        boolean replace = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.pattern.length(); ++i) {
            char ch = this.pattern.charAt(i);
            if (replace) {
                if ('{' == ch) {
                    int j;
                    StringBuilder name = new StringBuilder();
                    for (j = i + 1; j < this.pattern.length() && '}' != this.pattern.charAt(j); ++j) {
                        name.append(this.pattern.charAt(j));
                    }
                    if (j + 1 < this.pattern.length()) {
                        list.add(this.createAccessLogElement(name.toString(), this.pattern.charAt(++j)));
                        i = j;
                    } else {
                        list.add(this.createAccessLogElement(ch));
                    }
                } else {
                    list.add(this.createAccessLogElement(ch));
                }
                replace = false;
                continue;
            }
            if (ch == '%') {
                replace = true;
                list.add(new StringElement(buf.toString()));
                buf = new StringBuilder();
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            list.add(new StringElement(buf.toString()));
        }
        return list.toArray(new AccessLogElement[list.size()]);
    }

    private AccessLogElement createAccessLogElement(String header, char pattern) {
        switch (pattern) {
            case 'i': {
                return new HeaderElement(header);
            }
            case 'o': {
                return new ResponseHeaderElement(header);
            }
            case 'R': {
                return new RequestAttributeElement();
            }
        }
        return new StringElement("???");
    }

    private AccessLogElement createAccessLogElement(char pattern) {
        switch (pattern) {
            case 'A': {
                return new LocalAddrElement();
            }
            case 'a': {
                return new UserAgentElement();
            }
            case 'b': {
                return new ByteSentElement(true);
            }
            case 'B': {
                return new ByteSentElement(false);
            }
            case 'c': {
                return new CookieElement();
            }
            case 'C': {
                return new AcceptElement();
            }
            case 'e': {
                return new AcceptEncodingElement();
            }
            case 'E': {
                return new TransferEncodingElement();
            }
            case 'f': {
                return new RefererElement();
            }
            case 'h': {
                return new HostElement();
            }
            case 'k': {
                return new KeepAliveElement();
            }
            case 'l': {
                return new LogicalUserNameElement();
            }
            case 'L': {
                return new AcceptLanguageElement();
            }
            case 'm': {
                return new MethodElement();
            }
            case 'n': {
                return new ContentEncodingElement();
            }
            case 'r': {
                return new RequestElement();
            }
            case 'S': {
                return new AcceptCharSetElement();
            }
            case 's': {
                return new HttpStatusCodeElement();
            }
            case 'T': {
                return new ContentTypeElement();
            }
            case 't': {
                return new DateAndTimeElement();
            }
            case 'u': {
                return new UserElement();
            }
            case 'U': {
                return new RequestURIElement();
            }
            case 'V': {
                return new VaryElement();
            }
            case 'v': {
                return new LocalServerNameElement();
            }
            case 'x': {
                return new ConnectionElement();
            }
            case 'Z': {
                return new ServerElement();
            }
        }
        return new StringElement("???" + pattern + "???");
    }

    protected static class RequestAttributeElement
    implements AccessLogElement {
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            String value = request != null ? request.getLastHeader(buf.toString()) : "??";
            if (value != null) {
                if (value instanceof String) {
                    buf.append(value);
                } else {
                    buf.append(value.toString());
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected static class ResponseHeaderElement
    implements AccessLogElement {
        private String header;

        public ResponseHeaderElement(String header) {
            this.header = header;
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            if (null != response) {
                buf.append(Access.getHeaderValues((HttpMessage)response, this.header));
            }
            buf.append("-");
        }
    }

    protected static class ServerElement
    implements AccessLogElement {
        protected ServerElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getServerElement((HttpMessage)request));
        }
    }

    protected static class VaryElement
    implements AccessLogElement {
        protected VaryElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getVaryElement((HttpMessage)request));
        }
    }

    protected static class ContentEncodingElement
    implements AccessLogElement {
        protected ContentEncodingElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getContentEncodingElement((HttpMessage)request));
        }
    }

    protected static class TransferEncodingElement
    implements AccessLogElement {
        protected TransferEncodingElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getTransferEncodingElement((HttpMessage)request));
        }
    }

    protected static class KeepAliveElement
    implements AccessLogElement {
        protected KeepAliveElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getKeepAliveElement((HttpMessage)request));
        }
    }

    protected static class ContentTypeElement
    implements AccessLogElement {
        protected ContentTypeElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getContentTypeElement((HttpMessage)request));
        }
    }

    protected static class ConnectionElement
    implements AccessLogElement {
        protected ConnectionElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getConnectionElement((HttpMessage)request));
        }
    }

    protected static class AcceptCharSetElement
    implements AccessLogElement {
        protected AcceptCharSetElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getAcceptCharSetElement((HttpMessage)request));
        }
    }

    protected static class AcceptEncodingElement
    implements AccessLogElement {
        protected AcceptEncodingElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getAcceptEncodingElement((HttpMessage)request));
        }
    }

    protected static class AcceptLanguageElement
    implements AccessLogElement {
        protected AcceptLanguageElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getAcceptLanguageElement((HttpMessage)request));
        }
    }

    protected static class AcceptElement
    implements AccessLogElement {
        protected AcceptElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getAcceptElement((HttpMessage)request));
        }
    }

    protected static class UserAgentElement
    implements AccessLogElement {
        protected UserAgentElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getUserAgentElement((HttpMessage)request));
        }
    }

    protected static class RefererElement
    implements AccessLogElement {
        protected RefererElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getRefererElement((HttpMessage)request));
        }
    }

    protected static class CookieElement
    implements AccessLogElement {
        protected CookieElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getCookieElement((HttpMessage)request));
        }
    }

    protected static class HeaderElement
    implements AccessLogElement {
        private String header;

        public HeaderElement(String header) {
            this.header = header;
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            try {
                String value = Access.getHeaderValues((HttpMessage)request, this.header);
                if (value == null) {
                    buf.append('-');
                } else {
                    buf.append(value);
                }
            }
            catch (Exception e) {
                buf.append('-');
            }
        }
    }

    protected static class StringElement
    implements AccessLogElement {
        private String str;

        public StringElement(String str) {
            this.str = str;
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(this.str);
        }
    }

    protected static class LocalServerNameElement
    implements AccessLogElement {
        protected LocalServerNameElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getHeaderValues((HttpMessage)request, "server"));
        }
    }

    protected static class RequestURIElement
    implements AccessLogElement {
        protected RequestURIElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            if (request != null) {
                buf.append(request.getRequestLine().getUri());
            } else {
                buf.append('-');
            }
        }
    }

    protected static class MethodElement
    implements AccessLogElement {
        protected MethodElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            if (request != null) {
                buf.append(request.getRequestLine().getMethod());
            }
        }
    }

    protected static class ByteSentElement
    implements AccessLogElement {
        private boolean conversion;

        public ByteSentElement(boolean conversion) {
            this.conversion = conversion;
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            try {
                long length = response.getEntity().getContentLength();
                if (length <= 0L && this.conversion) {
                    buf.append('-');
                } else {
                    buf.append(length);
                }
            }
            catch (Exception e) {
                buf.append('-');
            }
        }
    }

    protected static class HttpStatusCodeElement
    implements AccessLogElement {
        protected HttpStatusCodeElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            if (response != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                buf.append(statusCode);
            } else {
                buf.append('-');
            }
        }
    }

    protected static class RequestElement
    implements AccessLogElement {
        protected RequestElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            if (request != null) {
                String requestLine = request.getRequestLine().toString();
                buf.append(requestLine);
            } else {
                buf.append("- - ");
            }
        }
    }

    protected class DateAndTimeElement
    implements AccessLogElement {
        protected DateAndTimeElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            String currentDate = "";
            if (request != null) {
                currentDate = Access.getHeaderValues((HttpMessage)request, "Date");
            } else if (response != null) {
                currentDate = Access.getHeaderValues((HttpMessage)response, "Date");
            }
            buf.append(currentDate);
        }
    }

    protected static class UserElement
    implements AccessLogElement {
        protected UserElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            String userElement = "";
            try {
                userElement = Access.getUserNameElement((HttpMessage)request);
            }
            catch (Exception e) {
                // empty catch block
            }
            buf.append(userElement);
        }
    }

    protected static class LogicalUserNameElement
    implements AccessLogElement {
        protected LogicalUserNameElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            String logicalUserName = "";
            try {
                logicalUserName = Access.getLogicalUserNameElement((HttpMessage)request);
            }
            catch (Exception e) {
                // empty catch block
            }
            buf.append(logicalUserName);
        }
    }

    protected static class HostElement
    implements AccessLogElement {
        protected HostElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            String host = "";
            try {
                host = Access.getHostElement((HttpMessage)request);
            }
            catch (Exception e) {
                // empty catch block
            }
            buf.append(host);
        }
    }

    protected static class LocalAddrElement
    implements AccessLogElement {
        private static final String LOCAL_ADDR_VALUE;

        protected LocalAddrElement() {
        }

        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(LOCAL_ADDR_VALUE);
        }

        static {
            String init;
            try {
                init = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable e) {
                AccessTimeUtil.handleThrowable(e);
                init = "127.0.0.1";
            }
            LOCAL_ADDR_VALUE = init;
        }
    }

    protected static interface AccessLogElement {
        public void addElement(StringBuilder var1, Date var2, HttpRequest var3, HttpResponse var4);
    }

    private class LogResponses
    extends TimerTask {
        private LogResponses() {
        }

        public void run() {
            while (!responseQueue.isEmpty()) {
                HttpResponse res = (HttpResponse)responseQueue.poll();
                Access.this.log(null, res);
            }
        }
    }

    private class LogRequests
    extends TimerTask {
        private LogRequests() {
        }

        public void run() {
            while (!requestQueue.isEmpty()) {
                HttpRequest req = (HttpRequest)requestQueue.poll();
                Access.this.log(req, null);
            }
        }
    }
}

