/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.policy;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.description.PolicySubject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.All;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.wso2.caching.CacheConfiguration;
import org.wso2.caching.CachingConstants;
import org.wso2.caching.CachingException;
import org.wso2.caching.digest.DigestGenerator;

public class CachingPolicyProcessor {
    private static Log log = LogFactory.getLog(CachingPolicyProcessor.class);

    public static CacheConfiguration processCachingPolicy(PolicySubject policySubject) throws CachingException {
        if (policySubject.getAttachedPolicyComponents().size() != 0) {
            CacheConfiguration cacheConfig = new CacheConfiguration();
            Collection topLevelAssertionList = policySubject.getAttachedPolicyComponents();
            CachingPolicyProcessor.handlePolicyComponents(cacheConfig, topLevelAssertionList);
            return cacheConfig;
        }
        return null;
    }

    private static void handlePolicyComponents(CacheConfiguration cacheConfig, Collection topLevelAssertionList) throws CachingException {
        for (Object topLevelAssertionObject : topLevelAssertionList) {
            XmlPrimtiveAssertion topLevelXmlPrimtiveAssertion;
            QName qName;
            if (topLevelAssertionObject instanceof Policy) {
                Policy policy = (Policy)topLevelAssertionObject;
                List policyComponents = policy.getPolicyComponents();
                CachingPolicyProcessor.handlePolicyComponents(cacheConfig, policyComponents);
                continue;
            }
            if (!(topLevelAssertionObject instanceof XmlPrimtiveAssertion) || !(qName = (topLevelXmlPrimtiveAssertion = (XmlPrimtiveAssertion)topLevelAssertionObject).getName()).equals(CachingConstants.CACHING_ASSERTION_QNAME)) continue;
            Policy cachingPolicyComponent = PolicyEngine.getPolicy((OMElement)topLevelXmlPrimtiveAssertion.getValue());
            List assertionList = cachingPolicyComponent.getPolicyComponents();
            for (Object aConfigDataAssertionObject : assertionList) {
                if (!(aConfigDataAssertionObject instanceof Policy)) continue;
                Policy cachingPolicy = (Policy)aConfigDataAssertionObject;
                List childAssertionsList = cachingPolicy.getPolicyComponents();
                for (Object configData : childAssertionsList) {
                    if (configData instanceof All) {
                        All all = (All)configData;
                        List configDataList = all.getPolicyComponents();
                        for (Object configDtaObject : configDataList) {
                            if (configDtaObject instanceof XmlPrimtiveAssertion) {
                                XmlPrimtiveAssertion cachingPrimtiveAssertion = (XmlPrimtiveAssertion)configDtaObject;
                                if (cachingPrimtiveAssertion.getName().equals(CachingConstants.CACHING_XML_IDENTIFIER_QNAME)) {
                                    String value = cachingPrimtiveAssertion.getValue().getText();
                                    try {
                                        DigestGenerator digestGenerator = (DigestGenerator)Class.forName(value).newInstance();
                                        cacheConfig.setDigestGenerator(digestGenerator);
                                    }
                                    catch (ClassNotFoundException e) {
                                        CachingPolicyProcessor.handleException("Unable to find the DigestGenerator implementation \"" + value + "\"", e);
                                    }
                                    catch (IllegalAccessException e) {
                                        CachingPolicyProcessor.handleException("Unable to load the DigestGenerator implementation \"" + value + "\"", e);
                                    }
                                    catch (InstantiationException e) {
                                        CachingPolicyProcessor.handleException("Unable to instantiate the DigestGenerator implementation \"" + value + "\"", e);
                                    }
                                }
                                if (cachingPrimtiveAssertion.getName().equals(CachingConstants.CACHE_EXPIRATION_TIME_QNAME) && cachingPrimtiveAssertion.getValue() != null) {
                                    long expireTime = Long.parseLong(cachingPrimtiveAssertion.getValue().getText());
                                    cacheConfig.setTimeout(expireTime);
                                }
                                if (cachingPrimtiveAssertion.getName().equals(CachingConstants.MAX_MESSAGE_SIZE_QNAME) && cachingPrimtiveAssertion.getValue() != null) {
                                    int maxMessageSize = Integer.parseInt(cachingPrimtiveAssertion.getValue().getText());
                                    cacheConfig.setMaxMessageSize(maxMessageSize);
                                }
                                if (!cachingPrimtiveAssertion.getName().equals(CachingConstants.MAX_CACHE_SIZE_QNAME) || cachingPrimtiveAssertion.getValue() == null) continue;
                                int maxCacheSize = Integer.parseInt(cachingPrimtiveAssertion.getValue().getText());
                                cacheConfig.setMaxCacheSize(maxCacheSize);
                                continue;
                            }
                            CachingPolicyProcessor.handleException("Unexpected caching policy assertion for the caching module");
                        }
                        continue;
                    }
                    CachingPolicyProcessor.handleException("Unexpected caching policy, \"wsp:All\" expected");
                }
            }
        }
    }

    private static void handleException(String message, Throwable cause) throws CachingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)message, cause);
        }
        throw new CachingException(message, cause);
    }

    private static void handleException(String message) throws CachingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
        throw new CachingException(message);
    }
}

