/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bsf;

import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.mediators.bsf.ScriptMediator;

public class ScriptMediatorSerializer
extends AbstractMediatorSerializer {
    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof ScriptMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        ScriptMediator scriptMediator = (ScriptMediator)m;
        OMElement script = fac.createOMElement("script", synNS);
        String language = scriptMediator.getLanguage();
        String key = scriptMediator.getKey();
        String function = scriptMediator.getFunction();
        if (key != null) {
            script.addAttribute(fac.createOMAttribute("language", nullNS, language));
            script.addAttribute(fac.createOMAttribute("key", nullNS, key));
            if (!function.equals("mediate")) {
                script.addAttribute(fac.createOMAttribute("function", nullNS, function));
            }
        } else {
            script.addAttribute(fac.createOMAttribute("language", nullNS, language));
            OMTextImpl textData = (OMTextImpl)fac.createOMText(scriptMediator.getScriptSrc().trim());
            textData.setType(12);
            script.addChild((OMNode)textData);
        }
        Map<String, Object> includeMap = scriptMediator.getIncludeMap();
        for (String includeKey : includeMap.keySet()) {
            if (includeKey == null || includeKey.length() == 0) continue;
            OMElement includeKeyElement = fac.createOMElement("include", synNS);
            includeKeyElement.addAttribute(fac.createOMAttribute("key", nullNS, includeKey));
            script.addChild((OMNode)includeKeyElement);
        }
        ScriptMediatorSerializer.saveTracingState((OMElement)script, (Mediator)scriptMediator);
        return script;
    }

    public String getMediatorClassName() {
        return ScriptMediator.class.getName();
    }
}

