/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.base.AbstractTransportListener;
import org.apache.axis2.transport.base.ProtocolEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransportListenerEx<E extends ProtocolEndpoint>
extends AbstractTransportListener {
    private List<E> endpoints = new ArrayList();

    @Override
    public void init(ConfigurationContext cfgCtx, TransportInDescription transportIn) throws AxisFault {
        super.init(cfgCtx, transportIn);
        E endpoint = this.createEndpoint();
        ((ProtocolEndpoint)endpoint).init(this, null);
        if (((ProtocolEndpoint)endpoint).loadConfiguration((ParameterInclude)transportIn)) {
            this.startEndpoint(endpoint);
            this.endpoints.add(endpoint);
        }
    }

    @Override
    public void destroy() {
        ArrayList<ProtocolEndpoint> endpointsToStop = new ArrayList<ProtocolEndpoint>();
        for (ProtocolEndpoint endpoint : this.endpoints) {
            if (endpoint.getService() != null) continue;
            endpointsToStop.add(endpoint);
        }
        for (ProtocolEndpoint endpoint : endpointsToStop) {
            this.stopEndpoint(endpoint);
            this.endpoints.remove(endpoint);
        }
        super.destroy();
    }

    @Override
    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        if (serviceName.indexOf(47) != -1) {
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        if (serviceName.indexOf(46) != -1) {
            serviceName = serviceName.substring(0, serviceName.indexOf(46));
        }
        for (ProtocolEndpoint endpoint : this.endpoints) {
            AxisService service = endpoint.getService();
            if (service == null || !service.getName().equals(serviceName)) continue;
            return endpoint.getEndpointReferences(ip);
        }
        return null;
    }

    public final Collection<E> getEndpoints() {
        return Collections.unmodifiableCollection(this.endpoints);
    }

    protected abstract E createEndpoint();

    @Override
    protected final void startListeningForService(AxisService service) throws AxisFault {
        E endpoint = this.createEndpoint();
        ((ProtocolEndpoint)endpoint).init(this, service);
        if (!((ProtocolEndpoint)endpoint).loadConfiguration((ParameterInclude)service)) {
            throw new AxisFault("Service doesn't have configuration information for transport " + this.getTransportName());
        }
        this.startEndpoint(endpoint);
        this.endpoints.add(endpoint);
    }

    protected abstract void startEndpoint(E var1) throws AxisFault;

    @Override
    protected final void stopListeningForService(AxisService service) {
        for (ProtocolEndpoint endpoint : this.endpoints) {
            if (service != endpoint.getService()) continue;
            this.stopEndpoint(endpoint);
            this.endpoints.remove(endpoint);
            return;
        }
        this.log.error((Object)("Unable to stop service : " + service.getName() + " - unable to find the corresponding protocol endpoint"));
    }

    protected abstract void stopEndpoint(E var1);
}

