/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.executors.queues;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Condition;
import org.apache.synapse.commons.executors.InternalQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeQueue<E>
extends AbstractQueue<E>
implements InternalQueue<E> {
    private int priority;
    private Condition notFullCond;
    private E[] array;
    private int capacity;
    private int count = 0;
    private int head = 0;
    private int tail = 0;

    public FixedSizeQueue(int priority, int capacity) {
        this.priority = priority;
        this.capacity = capacity;
        this.array = new Object[capacity];
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int p) {
        this.priority = p;
    }

    @Override
    public Condition getNotFullCond() {
        return this.notFullCond;
    }

    @Override
    public void setNotFullCond(Condition notFullCond) {
        this.notFullCond = notFullCond;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public String toString() {
        return super.toString() + this.priority;
    }

    @Override
    public boolean offer(E e) {
        if (this.count == this.array.length) {
            return false;
        }
        this.insert(e);
        return true;
    }

    @Override
    public E poll() {
        if (this.count == 0) {
            return null;
        }
        return this.get();
    }

    @Override
    public E peek() {
        return this.count == 0 ? null : (E)this.array[this.head];
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.count;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        int n;
        E[] items = this.array;
        int i = this.head;
        int max = this.count;
        for (n = 0; n < max; ++n) {
            c.add(items[i]);
            items[i] = null;
            i = this.increment(i);
        }
        if (n > 0) {
            this.count = 0;
            this.tail = 0;
            this.head = 0;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int n;
        int max;
        E[] items = this.array;
        int i = this.head;
        int n2 = max = maxElements < this.count ? maxElements : this.count;
        for (n = 0; n < max; ++n) {
            c.add(items[i]);
            items[i] = null;
            i = this.increment(i);
        }
        if (n > 0) {
            this.count -= n;
            this.head = i;
        }
        return n;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean contains(Object o) {
        for (E e : this.array) {
            if (!e.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        boolean found = false;
        int i = this.head;
        int iterations = 0;
        while (iterations++ < this.count) {
            if (!found && this.array[i].equals(o)) {
                found = true;
            }
            if (found) {
                int j = this.increment(i);
                this.array[i] = this.array[j];
            }
            i = this.increment(i);
        }
        if (found) {
            --this.count;
            this.tail = this.decrement(this.tail);
        }
        return found;
    }

    private int decrement(int n) {
        return n == 0 ? this.array.length - 1 : n;
    }

    private int increment(int n) {
        return ++n == this.array.length ? 0 : n;
    }

    private void insert(E e) {
        this.array[this.tail] = e;
        this.tail = this.increment(this.tail);
        ++this.count;
    }

    private E get() {
        E e = this.array[this.head];
        this.array[this.head] = null;
        this.head = this.increment(this.head);
        --this.count;
        return e;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr<E>
    implements Iterator<E> {
        int index;

        private Itr() {
            this.index = FixedSizeQueue.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.index != FixedSizeQueue.this.tail;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)FixedSizeQueue.this.array[this.index++];
        }

        @Override
        public void remove() {
            while (this.index != FixedSizeQueue.this.tail) {
                int j = FixedSizeQueue.this.increment(this.index);
                ((FixedSizeQueue)FixedSizeQueue.this).array[this.index] = FixedSizeQueue.this.array[j];
                this.index = j;
            }
        }
    }
}

