/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.executors;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.executors.BeforeExecuteHandler;
import org.apache.synapse.commons.executors.Importance;
import org.apache.synapse.commons.executors.MultiPriorityBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityExecutor {
    private final Log log = LogFactory.getLog(PriorityExecutor.class);
    private ThreadPoolExecutor executor;
    private String name = null;
    private int core = 20;
    private int max = 100;
    private int keepAlive = 5;
    private BeforeExecuteHandler beforeExecuteHandler;
    private MultiPriorityBlockingQueue<Runnable> queue;
    private String fileName;

    public void execute(Runnable task, int priority) {
        Worker w = new Worker(task, priority);
        if (this.beforeExecuteHandler != null) {
            this.beforeExecuteHandler.beforeExecute(w);
        }
        this.executor.execute(w);
    }

    public void init() {
        if (this.queue == null) {
            throw new IllegalStateException("Queue should be specified before initializing");
        }
        this.executor = new ThreadPoolExecutor(this.core, this.max, (long)this.keepAlive, TimeUnit.SECONDS, this.queue, (ThreadFactory)new NativeThreadFactory(new ThreadGroup("executor-group"), "priority-worker" + (this.name != null ? "-" + this.name : "")));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Started the thread pool executor with threads, core = " + this.core + " max = " + this.max + ", keep-alive = " + this.keepAlive));
        }
    }

    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Shutting down priority executor" + (this.name != null ? ": " + this.name : "")));
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Failed to Shut down Executor");
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setBeforeExecuteHandler(BeforeExecuteHandler beforeExecuteHandler) {
        this.beforeExecuteHandler = beforeExecuteHandler;
    }

    public BeforeExecuteHandler getBeforeExecuteHandler() {
        return this.beforeExecuteHandler;
    }

    public void setQueue(MultiPriorityBlockingQueue<Runnable> queue) {
        this.queue = queue;
    }

    public MultiPriorityBlockingQueue<Runnable> getQueue() {
        return this.queue;
    }

    public int getCore() {
        return this.core;
    }

    public int getMax() {
        return this.max;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public void setCore(int core) {
        this.core = core;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setKeepAlive(int keepAlive) {
        this.keepAlive = keepAlive;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private class Worker
    implements Runnable,
    Importance {
        private Runnable runnable = null;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private int priority = 1;

        private Worker(Runnable runnable, int priority) {
            this.priority = priority;
            this.runnable = runnable;
        }

        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable e) {
                PriorityExecutor.this.log.error((Object)"Unhandled exception", e);
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int p) {
            this.priority = p;
        }

        public void setProperty(String name, Object value) {
            this.properties.put(name, value);
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }
    }
}

