/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators.source;

import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.impl.llom.OMDocumentImpl;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.synapse.commons.evaluators.EvaluatorContext;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.source.SourceTextRetriever;
import org.jaxen.JaxenException;

public class SOAPEnvelopeTextRetriever
implements SourceTextRetriever {
    private String source;
    private AXIOMXPath compiledXPath;

    public SOAPEnvelopeTextRetriever(String source) {
        this.source = source;
    }

    public String getSourceText(EvaluatorContext context) throws EvaluatorException {
        Object result;
        SOAPEnvelope envelope = context.getMessageContext().getEnvelope();
        try {
            if (this.compiledXPath == null) {
                this.compiledXPath = new AXIOMXPath(this.source);
            }
            result = this.compiledXPath.evaluate((Object)envelope);
        }
        catch (JaxenException e) {
            throw new EvaluatorException("Error while parsing the XPath expression: " + this.source, e);
        }
        if (result instanceof List) {
            List list = (List)result;
            if (list.size() == 1 && list.get(0) == null) {
                return null;
            }
            StringBuffer textValue = new StringBuffer();
            for (Object o : list) {
                if (o instanceof OMTextImpl) {
                    textValue.append(((OMTextImpl)o).getText());
                    continue;
                }
                if (o instanceof OMElementImpl) {
                    String s = ((OMElementImpl)o).getText();
                    if (s.trim().length() == 0) {
                        s = o.toString();
                    }
                    textValue.append(s);
                    continue;
                }
                if (o instanceof OMDocumentImpl) {
                    textValue.append(((OMDocumentImpl)o).getOMDocumentElement().toString());
                    continue;
                }
                if (!(o instanceof OMAttribute)) continue;
                textValue.append(((OMAttribute)o).getAttributeValue());
            }
            return textValue.toString();
        }
        return result.toString();
    }

    public String getSource() {
        return this.source;
    }
}

