/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftps;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;

public class FtpsClientFactory {
    private FtpsClientFactory() {
    }

    public static FTPSClient createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (username == null) {
            username = "anonymous".toCharArray();
        }
        if (password == null) {
            password = "anonymous".toCharArray();
        }
        try {
            FTPFileEntryParserFactory myFactory;
            FTPSClient client;
            if (FtpsFileSystemConfigBuilder.getInstance().getFtpsType(fileSystemOptions).equals("explicit")) {
                client = new FTPSClient();
            } else if (FtpsFileSystemConfigBuilder.getInstance().getFtpsType(fileSystemOptions).equals("implicit")) {
                client = new FTPSClient(true);
            } else {
                throw new FileSystemException("Invalid FTPS type of " + FtpsFileSystemConfigBuilder.getInstance().getFtpsType(fileSystemOptions) + " specified. Must be 'implicit' or 'explicit'");
            }
            String key = FtpsFileSystemConfigBuilder.getInstance().getEntryParser(fileSystemOptions);
            if (key != null) {
                String[] shortMonthNames;
                String serverTimeZoneId;
                String recentDateFormat;
                String defaultDateFormat;
                FTPClientConfig config = new FTPClientConfig(key);
                String serverLanguageCode = FtpsFileSystemConfigBuilder.getInstance().getServerLanguageCode(fileSystemOptions);
                if (serverLanguageCode != null) {
                    config.setServerLanguageCode(serverLanguageCode);
                }
                if ((defaultDateFormat = FtpsFileSystemConfigBuilder.getInstance().getDefaultDateFormat(fileSystemOptions)) != null) {
                    config.setDefaultDateFormatStr(defaultDateFormat);
                }
                if ((recentDateFormat = FtpsFileSystemConfigBuilder.getInstance().getRecentDateFormat(fileSystemOptions)) != null) {
                    config.setRecentDateFormatStr(recentDateFormat);
                }
                if ((serverTimeZoneId = FtpsFileSystemConfigBuilder.getInstance().getServerTimeZoneId(fileSystemOptions)) != null) {
                    config.setServerTimeZoneId(serverTimeZoneId);
                }
                if ((shortMonthNames = FtpsFileSystemConfigBuilder.getInstance().getShortMonthNames(fileSystemOptions)) != null) {
                    StringBuffer shortMonthNamesStr = new StringBuffer(40);
                    for (int i = 0; i < shortMonthNames.length; ++i) {
                        if (shortMonthNamesStr.length() > 0) {
                            shortMonthNamesStr.append("|");
                        }
                        shortMonthNamesStr.append(shortMonthNames[i]);
                    }
                    config.setShortMonthNames(shortMonthNamesStr.toString());
                }
                client.configure(config);
            }
            if ((myFactory = FtpsFileSystemConfigBuilder.getInstance().getEntryParserFactory(fileSystemOptions)) != null) {
                client.setParserFactory(myFactory);
            }
            try {
                client.connect(hostname, port);
                int reply = client.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    throw new FileSystemException("vfs.provider.ftp/connect-rejected.error", hostname);
                }
                if (!client.login(UserAuthenticatorUtils.toString(username), UserAuthenticatorUtils.toString(password))) {
                    throw new FileSystemException("vfs.provider.ftp/login.error", new Object[]{hostname, UserAuthenticatorUtils.toString(username)}, null);
                }
                if (!client.setFileType(2)) {
                    throw new FileSystemException("vfs.provider.ftp/set-binary.error", hostname);
                }
                Integer dataTimeout = FtpsFileSystemConfigBuilder.getInstance().getDataTimeout(fileSystemOptions);
                if (dataTimeout != null) {
                    client.setDataTimeout(dataTimeout.intValue());
                }
                Boolean userDirIsRoot = FtpsFileSystemConfigBuilder.getInstance().getUserDirIsRoot(fileSystemOptions);
                if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue() || client.changeWorkingDirectory(workingDirectory))) {
                    throw new FileSystemException("vfs.provider.ftp/change-work-directory.error", workingDirectory);
                }
                Boolean passiveMode = FtpsFileSystemConfigBuilder.getInstance().getPassiveMode(fileSystemOptions);
                if (passiveMode != null && passiveMode.booleanValue()) {
                    client.enterLocalPassiveMode();
                }
            }
            catch (IOException e) {
                if (client.isConnected()) {
                    client.disconnect();
                }
                throw e;
            }
            return client;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.ftp/connect.error", new Object[]{hostname}, (Throwable)exc);
        }
    }
}

