/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.operations.FileOperation;
import org.apache.commons.vfs.operations.FileOperationProvider;

public abstract class AbstractFileOperationProvider
implements FileOperationProvider {
    private Collection operations = new ArrayList();

    public final void collectOperations(Collection operationsList, FileObject file) throws FileSystemException {
        this.doCollectOperations(this.operations, operationsList, file);
    }

    protected abstract void doCollectOperations(Collection var1, Collection var2, FileObject var3) throws FileSystemException;

    public final FileOperation getOperation(FileObject file, Class operationClass) throws FileSystemException {
        Class implementation = this.lookupOperation(operationClass);
        FileOperation operationInstance = this.instantiateOperation(file, implementation);
        return operationInstance;
    }

    protected abstract FileOperation instantiateOperation(FileObject var1, Class var2) throws FileSystemException;

    protected final Class lookupOperation(Class operationClass) throws FileSystemException {
        if (!FileOperation.class.isAssignableFrom(operationClass)) {
            throw new FileSystemException("vfs.operation/wrong-type.error", operationClass);
        }
        Class foundClass = null;
        Iterator iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            Class operation = (Class)iterator.next();
            if (!operationClass.isAssignableFrom(operation)) continue;
            foundClass = operation;
            break;
        }
        if (foundClass == null) {
            throw new FileSystemException("vfs.operation/not-found.error", operationClass);
        }
        return foundClass;
    }

    protected final void addOperation(Class operationClass) throws FileSystemException {
        if (!FileOperation.class.isAssignableFrom(operationClass)) {
            throw new FileSystemException("vfs.operation/cant-register.error", operationClass);
        }
        this.operations.add(operationClass);
    }
}

