/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.CacheStrategy;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.FilesCache;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.cache.SoftRefFilesCache;
import org.apache.commons.vfs.impl.DecoratedFileObject;
import org.apache.commons.vfs.impl.DefaultVfsComponentContext;
import org.apache.commons.vfs.impl.FileContentInfoFilenameFactory;
import org.apache.commons.vfs.impl.FileTypeMap;
import org.apache.commons.vfs.impl.URLStreamHandlerProxy;
import org.apache.commons.vfs.impl.VirtualFileProvider;
import org.apache.commons.vfs.operations.FileOperationProvider;
import org.apache.commons.vfs.provider.AbstractFileName;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.FileReplicator;
import org.apache.commons.vfs.provider.LocalFileProvider;
import org.apache.commons.vfs.provider.TemporaryFileStore;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponent;

public class DefaultFileSystemManager
implements FileSystemManager {
    private LocalFileProvider localFileProvider;
    private FileProvider defaultProvider;
    private FileReplicator fileReplicator;
    private final Map providers = new HashMap();
    private final ArrayList components = new ArrayList();
    private FileObject baseFile;
    private FilesCache filesCache;
    private CacheStrategy fileCacheStrategy;
    private Class fileObjectDecorator;
    private Constructor fileObjectDecoratorConst;
    private FileContentInfoFactory fileContentInfoFactory;
    private Log log = LogFactory.getLog(this.getClass());
    private final DefaultVfsComponentContext context = new DefaultVfsComponentContext(this);
    private TemporaryFileStore tempFileStore;
    private final FileTypeMap map = new FileTypeMap();
    private final VirtualFileProvider vfsProvider = new VirtualFileProvider();
    private boolean init;
    private final Map operationProviders = new HashMap();

    protected Log getLogger() {
        return this.log;
    }

    public void addProvider(String urlScheme, FileProvider provider) throws FileSystemException {
        this.addProvider(new String[]{urlScheme}, provider);
    }

    public void addProvider(String[] urlSchemes, FileProvider provider) throws FileSystemException {
        String scheme;
        int i;
        for (i = 0; i < urlSchemes.length; ++i) {
            scheme = urlSchemes[i];
            if (!this.providers.containsKey(scheme)) continue;
            throw new FileSystemException("vfs.impl/multiple-providers-for-scheme.error", scheme);
        }
        this.setupComponent(provider);
        for (i = 0; i < urlSchemes.length; ++i) {
            scheme = urlSchemes[i];
            this.providers.put(scheme, provider);
        }
        if (provider instanceof LocalFileProvider && this.localFileProvider == null) {
            this.localFileProvider = (LocalFileProvider)provider;
        }
    }

    public boolean hasProvider(String scheme) {
        return this.providers.containsKey(scheme);
    }

    public void addExtensionMap(String extension, String scheme) {
        this.map.addExtension(extension, scheme);
    }

    public void addMimeTypeMap(String mimeType, String scheme) {
        this.map.addMimeType(mimeType, scheme);
    }

    public void setDefaultProvider(FileProvider provider) throws FileSystemException {
        this.setupComponent(provider);
        this.defaultProvider = provider;
    }

    public FilesCache getFilesCache() {
        return this.filesCache;
    }

    public void setFilesCache(FilesCache filesCache) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.filesCache = filesCache;
    }

    public void setCacheStrategy(CacheStrategy fileCacheStrategy) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileCacheStrategy = fileCacheStrategy;
    }

    public CacheStrategy getCacheStrategy() {
        return this.fileCacheStrategy;
    }

    public Class getFileObjectDecorator() {
        return this.fileObjectDecorator;
    }

    public Constructor getFileObjectDecoratorConst() {
        return this.fileObjectDecoratorConst;
    }

    public void setFileObjectDecorator(Class fileObjectDecorator) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        if (!DecoratedFileObject.class.isAssignableFrom(fileObjectDecorator)) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", fileObjectDecorator.getName());
        }
        try {
            this.fileObjectDecoratorConst = fileObjectDecorator.getConstructor(FileObject.class);
        }
        catch (NoSuchMethodException e) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", fileObjectDecorator.getName(), (Throwable)e);
        }
        this.fileObjectDecorator = fileObjectDecorator;
    }

    public FileContentInfoFactory getFileContentInfoFactory() {
        return this.fileContentInfoFactory;
    }

    public void setFileContentInfoFactory(FileContentInfoFactory fileContentInfoFactory) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    public void setReplicator(FileReplicator replicator) throws FileSystemException {
        this.setupComponent(replicator);
        this.fileReplicator = replicator;
    }

    public void setTemporaryFileStore(TemporaryFileStore tempFileStore) throws FileSystemException {
        this.setupComponent(tempFileStore);
        this.tempFileStore = tempFileStore;
    }

    public void setLogger(Log log) {
        this.log = log;
    }

    private void setupComponent(Object component) throws FileSystemException {
        if (!this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.setLogger(this.getLogger());
                vfsComponent.setContext(this.context);
                vfsComponent.init();
            }
            this.components.add(component);
        }
    }

    private void closeComponent(Object component) {
        if (component != null && this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.close();
            }
            this.components.remove(component);
        }
    }

    public FileReplicator getReplicator() throws FileSystemException {
        if (this.fileReplicator == null) {
            throw new FileSystemException("vfs.impl/no-replicator.error");
        }
        return this.fileReplicator;
    }

    public TemporaryFileStore getTemporaryFileStore() throws FileSystemException {
        if (this.tempFileStore == null) {
            throw new FileSystemException("vfs.impl/no-temp-file-store.error");
        }
        return this.tempFileStore;
    }

    public void init() throws FileSystemException {
        if (this.filesCache == null) {
            this.filesCache = new SoftRefFilesCache();
        }
        if (this.fileContentInfoFactory == null) {
            this.fileContentInfoFactory = new FileContentInfoFilenameFactory();
        }
        if (this.fileCacheStrategy == null) {
            this.fileCacheStrategy = CacheStrategy.ON_RESOLVE;
        }
        this.setupComponent(this.filesCache);
        this.setupComponent(this.vfsProvider);
        this.init = true;
    }

    public void close() {
        if (!this.init) {
            return;
        }
        Iterator iterator = this.providers.values().iterator();
        while (iterator.hasNext()) {
            Object provider = iterator.next();
            this.closeComponent(provider);
        }
        this.closeComponent(this.defaultProvider);
        this.closeComponent(this.fileReplicator);
        this.closeComponent(this.tempFileStore);
        this.components.clear();
        this.providers.clear();
        this.filesCache.close();
        this.localFileProvider = null;
        this.defaultProvider = null;
        this.fileReplicator = null;
        this.tempFileStore = null;
        this.init = false;
    }

    public void freeUnusedResources() {
        if (!this.init) {
            return;
        }
        Iterator iterator = this.providers.values().iterator();
        while (iterator.hasNext()) {
            AbstractFileProvider provider = (AbstractFileProvider)iterator.next();
            provider.freeUnusedResources();
        }
    }

    public void setBaseFile(FileObject baseFile) throws FileSystemException {
        this.baseFile = baseFile;
    }

    public void setBaseFile(File baseFile) throws FileSystemException {
        this.baseFile = this.getLocalFileProvider().findLocalFile(baseFile);
    }

    public FileObject getBaseFile() throws FileSystemException {
        return this.baseFile;
    }

    public FileObject resolveFile(String uri) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), uri);
    }

    public FileObject resolveFile(String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), uri, fileSystemOptions);
    }

    public FileObject resolveFile(File baseFile, String uri) throws FileSystemException {
        FileObject baseFileObj = this.getLocalFileProvider().findLocalFile(baseFile);
        return this.resolveFile(baseFileObj, uri);
    }

    public FileObject resolveFile(FileObject baseFile, String uri) throws FileSystemException {
        return this.resolveFile(baseFile, uri, baseFile == null ? null : baseFile.getFileSystem().getFileSystemOptions());
    }

    public FileObject resolveFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileProvider provider;
        FileObject realBaseFile = baseFile != null && VFS.isUriStyle() && baseFile.getName().getType() == FileType.FILE ? baseFile.getParent() : baseFile;
        UriParser.checkUriEncoding(uri);
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = UriParser.extractScheme(uri);
        if (scheme != null && (provider = (FileProvider)this.providers.get(scheme)) != null) {
            return provider.findFile(realBaseFile, uri, fileSystemOptions);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(uri)) {
            return this.localFileProvider.findLocalFile(uri);
        }
        if (scheme != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{scheme, uri});
            }
            return this.defaultProvider.findFile(realBaseFile, uri, fileSystemOptions);
        }
        if (realBaseFile == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", uri);
        }
        return realBaseFile.resolveFile(uri);
    }

    public FileName resolveName(FileName root, String path) throws FileSystemException {
        return this.resolveName(root, path, NameScope.FILE_SYSTEM);
    }

    public FileName resolveName(FileName base, String name, NameScope scope) throws FileSystemException {
        String fullPath;
        FileName realBase = base != null && VFS.isUriStyle() && base.getType() == FileType.FILE ? base.getParent() : base;
        StringBuffer buffer = new StringBuffer(name);
        UriParser.fixSeparators(buffer);
        String scheme = UriParser.extractScheme(buffer.toString());
        if (name.length() == 0 || scheme == null && buffer.charAt(0) != '/') {
            if (!VFS.isUriStyle()) {
                buffer.insert(0, '/');
            }
            buffer.insert(0, realBase.getPath());
        }
        FileType fileType = UriParser.normalisePath(buffer);
        String resolvedPath = buffer.toString();
        if (!AbstractFileName.checkName(realBase.getPath(), resolvedPath, scope)) {
            throw new FileSystemException("vfs.provider/invalid-descendent-name.error", name);
        }
        if (scheme != null) {
            fullPath = resolvedPath;
        } else {
            scheme = realBase.getScheme();
            fullPath = realBase.getRootURI() + resolvedPath;
        }
        FileProvider provider = (FileProvider)this.providers.get(scheme);
        if (provider != null) {
            return provider.parseUri(realBase, fullPath);
        }
        if (scheme != null && this.defaultProvider != null) {
            return this.defaultProvider.parseUri(realBase, fullPath);
        }
        return ((AbstractFileName)realBase).createName(resolvedPath, fileType);
    }

    public FileName resolveURI(String uri) throws FileSystemException {
        FileProvider provider;
        UriParser.checkUriEncoding(uri);
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = UriParser.extractScheme(uri);
        if (scheme != null && (provider = (FileProvider)this.providers.get(scheme)) != null) {
            return provider.parseUri(null, uri);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(uri)) {
            return this.localFileProvider.parseUri(null, uri);
        }
        if (scheme != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{scheme, uri});
            }
            return this.defaultProvider.parseUri(null, uri);
        }
        if (this.baseFile == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", uri);
        }
        return this.resolveName(this.baseFile.getName(), uri, NameScope.FILE_SYSTEM);
    }

    public FileObject toFileObject(File file) throws FileSystemException {
        return this.getLocalFileProvider().findLocalFile(file);
    }

    public FileObject createFileSystem(String scheme, FileObject file) throws FileSystemException {
        FileProvider provider = (FileProvider)this.providers.get(scheme);
        if (provider == null) {
            throw new FileSystemException("vfs.impl/unknown-provider.error", new Object[]{scheme, file});
        }
        return provider.createFileSystem(scheme, file, file.getFileSystem().getFileSystemOptions());
    }

    public FileObject createFileSystem(FileObject file) throws FileSystemException {
        String scheme = this.map.getScheme(file);
        if (scheme == null) {
            throw new FileSystemException("vfs.impl/no-provider-for-file.error", file);
        }
        return this.createFileSystem(scheme, file);
    }

    public boolean canCreateFileSystem(FileObject file) throws FileSystemException {
        return this.map.getScheme(file) != null;
    }

    public FileObject createVirtualFileSystem(FileObject rootFile) throws FileSystemException {
        return this.vfsProvider.createFileSystem(rootFile);
    }

    public FileObject createVirtualFileSystem(String rootUri) throws FileSystemException {
        return this.vfsProvider.createFileSystem(rootUri);
    }

    private LocalFileProvider getLocalFileProvider() throws FileSystemException {
        if (this.localFileProvider == null) {
            throw new FileSystemException("vfs.impl/no-local-file-provider.error");
        }
        return this.localFileProvider;
    }

    public URLStreamHandlerFactory getURLStreamHandlerFactory() {
        return new VfsStreamHandlerFactory();
    }

    public void closeFileSystem(FileSystem filesystem) {
        this.getFilesCache().clear(filesystem);
        this._closeFileSystem(filesystem);
    }

    public void _closeFileSystem(FileSystem filesystem) {
        FileProvider provider = (FileProvider)this.providers.get(filesystem.getRootName().getScheme());
        if (provider != null) {
            ((AbstractFileProvider)provider).closeFileSystem(filesystem);
        }
    }

    public String[] getSchemes() {
        String[] schemes = new String[this.providers.size()];
        this.providers.keySet().toArray(schemes);
        return schemes;
    }

    public Collection getProviderCapabilities(String scheme) throws FileSystemException {
        FileProvider provider = (FileProvider)this.providers.get(scheme);
        if (provider == null) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{scheme});
        }
        return provider.getCapabilities();
    }

    public FileSystemConfigBuilder getFileSystemConfigBuilder(String scheme) throws FileSystemException {
        FileProvider provider = (FileProvider)this.providers.get(scheme);
        if (provider == null) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{scheme});
        }
        return provider.getConfigBuilder();
    }

    public void addOperationProvider(String scheme, FileOperationProvider operationProvider) throws FileSystemException {
        this.addOperationProvider(new String[]{scheme}, operationProvider);
    }

    public void addOperationProvider(String[] schemes, FileOperationProvider operationProvider) throws FileSystemException {
        for (int i = 0; i < schemes.length; ++i) {
            List<FileOperationProvider> providers;
            String scheme = schemes[i];
            if (!this.operationProviders.containsKey(scheme)) {
                providers = new ArrayList();
                this.operationProviders.put(scheme, providers);
            }
            if ((providers = (List)this.operationProviders.get(scheme)).contains(operationProvider)) {
                throw new FileSystemException("vfs.operation/operation-provider-already-added.error", scheme);
            }
            this.setupComponent(operationProvider);
            providers.add(operationProvider);
        }
    }

    public FileOperationProvider[] getOperationProviders(String scheme) throws FileSystemException {
        List providers = (List)this.operationProviders.get(scheme);
        if (providers == null || providers.size() == 0) {
            return null;
        }
        return providers.toArray(new FileOperationProvider[0]);
    }

    final class VfsStreamHandlerFactory
    implements URLStreamHandlerFactory {
        VfsStreamHandlerFactory() {
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            FileProvider provider = (FileProvider)DefaultFileSystemManager.this.providers.get(protocol);
            if (provider != null) {
                return new DefaultURLStreamHandler(DefaultFileSystemManager.this.context);
            }
            return new URLStreamHandlerProxy();
        }
    }
}

