/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSMessageReceiver;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTaskManager {
    private static final Log log = LogFactory.getLog(ServiceTaskManager.class);
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_PAUSED = 2;
    private static final int STATE_SHUTTING_DOWN = 3;
    private static final int STATE_FAILURE = 4;
    private String serviceName;
    private String connFactoryJNDIName;
    private String destinationJNDIName;
    private String userTransactionJNDIName = "java:comp/UserTransaction";
    private int destinationType = 0;
    private String messageSelector = null;
    private int transactionality = 0;
    private boolean sessionTransacted = true;
    private int sessionAckMode = 1;
    private boolean subscriptionDurable = false;
    private String durableSubscriberName = null;
    private boolean pubSubNoLocal = false;
    private int concurrentConsumers = 1;
    private int maxConcurrentConsumers = 1;
    private int idleTaskExecutionLimit = 10;
    private int maxMessagesPerTask = -1;
    private int receiveTimeout = 1000;
    private int cacheLevel = 5;
    private boolean cacheUserTransaction = true;
    private UserTransaction sharedUserTransaction = null;
    private boolean jmsSpec11 = true;
    private int initialReconnectDuration = 10000;
    private double reconnectionProgressionFactor = 2.0;
    private long maxReconnectDuration = 3600000L;
    private Hashtable<String, String> jmsProperties = new Hashtable();
    private Context context = null;
    private ConnectionFactory conFactory = null;
    private Destination destination = null;
    private final List<MessageListenerTask> pollingTasks = Collections.synchronizedList(new ArrayList());
    private JMSMessageReceiver jmsMessageReceiver = null;
    private volatile int serviceTaskManagerState = 0;
    private volatile int activeTaskCount = 0;
    private WorkerPool workerPool = null;
    private Connection sharedConnection = null;

    public synchronized void start() {
        if (this.serviceTaskManagerState == 2) {
            log.info((Object)"Attempt to re-start paused TaskManager is ignored. Please use resume instead");
            return;
        }
        if (!this.pollingTasks.isEmpty()) {
            this.stop();
        }
        if (this.cacheLevel == 5) {
            this.cacheLevel = this.transactionality == 0 ? 3 : 0;
        }
        switch (this.cacheLevel) {
            case 0: {
                log.debug((Object)("No JMS resources will be cached/shared between poller worker tasks of service : " + this.serviceName));
                break;
            }
            case 1: {
                log.debug((Object)"Only the JMS Connection will be cached and shared between *all* poller task invocations");
                break;
            }
            case 2: {
                log.debug((Object)"The JMS Connection and Session will be cached and shared between successive poller task invocations");
                break;
            }
            case 3: {
                log.debug((Object)"The JMS Connection, Session and MessageConsumer will be cached and shared between successive poller task invocations");
                break;
            }
            default: {
                this.handleException("Invalid cache level : " + this.cacheLevel + " for service : " + this.serviceName);
            }
        }
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            this.workerPool.execute((Runnable)new MessageListenerTask());
        }
        this.serviceTaskManagerState = 1;
        log.info((Object)("Task manager for service : " + this.serviceName + " [re-]initialized"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping ServiceTaskManager for service : " + this.serviceName));
        }
        if (this.serviceTaskManagerState != 4) {
            this.serviceTaskManagerState = 3;
        }
        List<MessageListenerTask> list = this.pollingTasks;
        synchronized (list) {
            for (MessageListenerTask lstTask : this.pollingTasks) {
                lstTask.requestShutdown();
            }
        }
        for (int i = 0; i < 5 && this.activeTaskCount != 0; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.sharedConnection != null) {
            try {
                try {
                    this.sharedConnection.stop();
                }
                catch (JMSException e) {
                    this.logError("Error stopping shared Connection", (Exception)((Object)e));
                    Object var6_9 = null;
                    this.sharedConnection = null;
                }
                Object var6_8 = null;
                this.sharedConnection = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.sharedConnection = null;
                throw throwable;
            }
        }
        if (this.activeTaskCount > 0) {
            log.warn((Object)("Unable to shutdown all polling tasks of service : " + this.serviceName));
        }
        if (this.serviceTaskManagerState != 4) {
            this.serviceTaskManagerState = 0;
        }
        log.info((Object)("Task manager for service : " + this.serviceName + " shutdown"));
    }

    public synchronized void pause() {
        for (MessageListenerTask lstTask : this.pollingTasks) {
            lstTask.pause();
        }
        if (this.sharedConnection != null) {
            try {
                this.sharedConnection.stop();
            }
            catch (JMSException e) {
                this.logError("Error pausing shared Connection", (Exception)((Object)e));
            }
        }
    }

    public synchronized void resume() {
        for (MessageListenerTask lstTask : this.pollingTasks) {
            lstTask.resume();
        }
        if (this.sharedConnection != null) {
            try {
                this.sharedConnection.start();
            }
            catch (JMSException e) {
                this.logError("Error resuming shared Connection", (Exception)((Object)e));
            }
        }
    }

    private void scheduleNewTaskIfAppropriate() {
        if (this.serviceTaskManagerState == 1 && this.pollingTasks.size() < this.getMaxConcurrentConsumers() && this.getIdleTaskCount() == 0) {
            this.workerPool.execute((Runnable)new MessageListenerTask());
        }
    }

    private int getIdleTaskCount() {
        int count = 0;
        for (MessageListenerTask lstTask : this.pollingTasks) {
            if (!lstTask.isTaskIdle()) continue;
            ++count;
        }
        return count;
    }

    private int getConnectedTaskCount() {
        int count = 0;
        for (MessageListenerTask lstTask : this.pollingTasks) {
            if (!lstTask.isConnected()) continue;
            ++count;
        }
        return count;
    }

    private Context getInitialContext() throws NamingException {
        if (this.context == null) {
            this.context = new InitialContext(this.jmsProperties);
        }
        return this.context;
    }

    private Destination getDestination(Session session) {
        if (this.destination == null) {
            try {
                this.context = this.getInitialContext();
                this.destination = JMSUtils.lookupDestination(this.context, this.getDestinationJNDIName(), JMSUtils.getDestinationTypeAsString(this.destinationType));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JMS Destination with JNDI name : " + this.getDestinationJNDIName() + " found for service " + this.serviceName));
                }
            }
            catch (NamingException e) {
                try {
                    switch (this.destinationType) {
                        case 1: {
                            this.destination = session.createQueue(this.getDestinationJNDIName());
                            break;
                        }
                        case 2: {
                            this.destination = session.createTopic(this.getDestinationJNDIName());
                            break;
                        }
                        default: {
                            this.handleException("Error looking up JMS destination : " + this.getDestinationJNDIName() + " using JNDI properties : " + this.jmsProperties, e);
                            break;
                        }
                    }
                }
                catch (JMSException j) {
                    this.handleException("Error looking up JMS destination and auto creating JMS destination : " + this.getDestinationJNDIName() + " using JNDI properties : " + this.jmsProperties, e);
                }
            }
        }
        return this.destination;
    }

    private UserTransaction getUserTransaction() {
        if (!this.cacheUserTransaction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Acquiring a new UserTransaction for service : " + this.serviceName));
            }
            try {
                this.context = this.getInitialContext();
                return JMSUtils.lookup(this.context, UserTransaction.class, this.getUserTransactionJNDIName());
            }
            catch (NamingException e) {
                this.handleException("Error looking up UserTransaction : " + this.getUserTransactionJNDIName() + " using JNDI properties : " + this.jmsProperties, e);
            }
        }
        if (this.sharedUserTransaction == null) {
            try {
                this.context = this.getInitialContext();
                this.sharedUserTransaction = JMSUtils.lookup(this.context, UserTransaction.class, this.getUserTransactionJNDIName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Acquired shared UserTransaction for service : " + this.serviceName));
                }
            }
            catch (NamingException e) {
                this.handleException("Error looking up UserTransaction : " + this.getUserTransactionJNDIName() + " using JNDI properties : " + this.jmsProperties, e);
            }
        }
        return this.sharedUserTransaction;
    }

    private boolean isSTMActive() {
        return this.serviceTaskManagerState == 1;
    }

    private Boolean isQueue() {
        if (this.destinationType == 0) {
            return null;
        }
        return this.destinationType == 1;
    }

    private void logError(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new AxisJMSException(msg, e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new AxisJMSException(msg);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getConnFactoryJNDIName() {
        return this.connFactoryJNDIName;
    }

    public void setConnFactoryJNDIName(String connFactoryJNDIName) {
        this.connFactoryJNDIName = connFactoryJNDIName;
    }

    public String getDestinationJNDIName() {
        return this.destinationJNDIName;
    }

    public void setDestinationJNDIName(String destinationJNDIName) {
        this.destinationJNDIName = destinationJNDIName;
    }

    public int getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(int destinationType) {
        this.destinationType = destinationType;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public int getTransactionality() {
        return this.transactionality;
    }

    public void setTransactionality(int transactionality) {
        this.transactionality = transactionality;
        this.sessionTransacted = transactionality == 1;
    }

    public boolean isSessionTransacted() {
        return this.sessionTransacted;
    }

    public void setSessionTransacted(Boolean sessionTransacted) {
        if (sessionTransacted != null) {
            this.sessionTransacted = sessionTransacted;
            if (sessionTransacted.booleanValue()) {
                this.transactionality = 1;
            }
        }
    }

    public int getSessionAckMode() {
        return this.sessionAckMode;
    }

    public void setSessionAckMode(int sessionAckMode) {
        this.sessionAckMode = sessionAckMode;
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionDurable(Boolean subscriptionDurable) {
        if (subscriptionDurable != null) {
            this.subscriptionDurable = subscriptionDurable;
        }
    }

    public String getDurableSubscriberName() {
        return this.durableSubscriberName;
    }

    public void setDurableSubscriberName(String durableSubscriberName) {
        this.durableSubscriberName = durableSubscriberName;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(Boolean pubSubNoLocal) {
        if (pubSubNoLocal != null) {
            this.pubSubNoLocal = pubSubNoLocal;
        }
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public int getIdleTaskExecutionLimit() {
        return this.idleTaskExecutionLimit;
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.idleTaskExecutionLimit = idleTaskExecutionLimit;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public int getInitialReconnectDuration() {
        return this.initialReconnectDuration;
    }

    public void setInitialReconnectDuration(int initialReconnectDuration) {
        this.initialReconnectDuration = initialReconnectDuration;
    }

    public double getReconnectionProgressionFactor() {
        return this.reconnectionProgressionFactor;
    }

    public void setReconnectionProgressionFactor(double reconnectionProgressionFactor) {
        this.reconnectionProgressionFactor = reconnectionProgressionFactor;
    }

    public long getMaxReconnectDuration() {
        return this.maxReconnectDuration;
    }

    public void setMaxReconnectDuration(long maxReconnectDuration) {
        this.maxReconnectDuration = maxReconnectDuration;
    }

    public int getMaxMessagesPerTask() {
        return this.maxMessagesPerTask;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public String getUserTransactionJNDIName() {
        return this.userTransactionJNDIName;
    }

    public void setUserTransactionJNDIName(String userTransactionJNDIName) {
        if (userTransactionJNDIName != null) {
            this.userTransactionJNDIName = userTransactionJNDIName;
        }
    }

    public boolean isCacheUserTransaction() {
        return this.cacheUserTransaction;
    }

    public void setCacheUserTransaction(Boolean cacheUserTransaction) {
        if (cacheUserTransaction != null) {
            this.cacheUserTransaction = cacheUserTransaction;
        }
    }

    public boolean isJmsSpec11() {
        return this.jmsSpec11;
    }

    public void setJmsSpec11(boolean jmsSpec11) {
        this.jmsSpec11 = jmsSpec11;
    }

    public Hashtable<String, String> getJmsProperties() {
        return this.jmsProperties;
    }

    public void addJmsProperties(Map<String, String> jmsProperties) {
        this.jmsProperties.putAll(jmsProperties);
    }

    public void removeJmsProperties(String key) {
        this.jmsProperties.remove(key);
    }

    public Context getContext() {
        return this.context;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.conFactory;
    }

    public List<MessageListenerTask> getPollingTasks() {
        return this.pollingTasks;
    }

    public void setJmsMessageReceiver(JMSMessageReceiver jmsMessageReceiver) {
        this.jmsMessageReceiver = jmsMessageReceiver;
    }

    public void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    public int getActiveTaskCount() {
        return this.activeTaskCount;
    }

    public void setServiceTaskManagerState(int serviceTaskManagerState) {
        this.serviceTaskManagerState = serviceTaskManagerState;
    }

    private class MessageListenerTask
    implements Runnable,
    ExceptionListener {
        private Connection connection = null;
        private Session session = null;
        private MessageConsumer consumer = null;
        private volatile int workerState = 0;
        private int idleExecutionCount = 0;
        private volatile boolean idle = false;
        private boolean connected = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MessageListenerTask() {
            List list = ServiceTaskManager.this.pollingTasks;
            synchronized (list) {
                ServiceTaskManager.this.pollingTasks.add(this);
            }
        }

        public void pause() {
            if (this.isActive()) {
                if (this.connection != null && ServiceTaskManager.this.cacheLevel < 1) {
                    try {
                        this.connection.stop();
                    }
                    catch (JMSException e) {
                        log.warn((Object)("Error pausing Message Listener task for service : " + ServiceTaskManager.this.serviceName));
                    }
                }
                this.workerState = 2;
            }
        }

        public void resume() {
            if (this.connection != null && ServiceTaskManager.this.cacheLevel < 1) {
                try {
                    this.connection.start();
                }
                catch (JMSException e) {
                    log.warn((Object)("Error resuming Message Listener task for service : " + ServiceTaskManager.this.serviceName));
                }
            }
            this.workerState = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.workerState = 1;
            ServiceTaskManager.this.activeTaskCount++;
            int messageCount = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)("New poll task starting : thread id = " + Thread.currentThread().getId()));
            }
            try {
                while (!(!this.isActive() || ServiceTaskManager.this.getMaxMessagesPerTask() >= 0 && messageCount >= ServiceTaskManager.this.getMaxMessagesPerTask() || ServiceTaskManager.this.getConcurrentConsumers() != 1 && this.idleExecutionCount >= ServiceTaskManager.this.getIdleTaskExecutionLimit())) {
                    UserTransaction ut = null;
                    try {
                        if (ServiceTaskManager.this.transactionality == 2 && (ut = ServiceTaskManager.this.getUserTransaction()).getStatus() == 6) {
                            ut.begin();
                        }
                    }
                    catch (NotSupportedException e) {
                        ServiceTaskManager.this.handleException("Listener Task is already associated with a transaction", (Exception)((Object)e));
                    }
                    catch (SystemException e) {
                        ServiceTaskManager.this.handleException("Error starting a JTA transaction", (Exception)((Object)e));
                    }
                    Message message = this.receiveMessage();
                    if (log.isTraceEnabled()) {
                        if (message != null) {
                            try {
                                log.trace((Object)("<<<<<<< READ message with Message ID : " + message.getJMSMessageID() + " from : " + ServiceTaskManager.this.destination + " by Thread ID : " + Thread.currentThread().getId()));
                            }
                            catch (JMSException ignore) {}
                        } else {
                            log.trace((Object)("No message received by Thread ID : " + Thread.currentThread().getId() + " for destination : " + ServiceTaskManager.this.destination));
                        }
                    }
                    if (message != null) {
                        this.idle = false;
                        this.idleExecutionCount = 0;
                        ++messageCount;
                        ServiceTaskManager.this.scheduleNewTaskIfAppropriate();
                        this.handleMessage(message, ut);
                        continue;
                    }
                    this.idle = true;
                    ++this.idleExecutionCount;
                }
            }
            finally {
                this.workerState = 0;
                ServiceTaskManager.this.activeTaskCount--;
                List list = ServiceTaskManager.this.pollingTasks;
                synchronized (list) {
                    ServiceTaskManager.this.pollingTasks.remove(this);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Listener task with Thread ID : " + Thread.currentThread().getId() + " is stopping after processing : " + messageCount + " messages :: " + " isActive : " + this.isActive() + " maxMessagesPerTask : " + ServiceTaskManager.this.getMaxMessagesPerTask() + " concurrentConsumers : " + ServiceTaskManager.this.getConcurrentConsumers() + " idleExecutionCount : " + this.idleExecutionCount + " idleTaskExecutionLimit : " + ServiceTaskManager.this.getIdleTaskExecutionLimit()));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Listener task with Thread ID : " + Thread.currentThread().getId() + " is stopping after processing : " + messageCount + " messages"));
            }
            this.closeConsumer(true);
            this.closeSession(true);
            this.closeConnection();
            ServiceTaskManager.this.scheduleNewTaskIfAppropriate();
        }

        private Message receiveMessage() {
            if (this.consumer == null) {
                this.connection = this.getConnection();
                this.session = this.getSession();
                this.consumer = this.getMessageConsumer();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Preparing a Connection, Session and Consumer to read messages");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Waiting for a message for service : " + ServiceTaskManager.this.serviceName + " - duration : " + (ServiceTaskManager.this.getReceiveTimeout() < 0 ? "unlimited" : ServiceTaskManager.this.getReceiveTimeout() + "ms")));
            }
            try {
                if (ServiceTaskManager.this.getReceiveTimeout() < 0) {
                    return this.consumer.receive();
                }
                return this.consumer.receive((long)ServiceTaskManager.this.getReceiveTimeout());
            }
            catch (IllegalStateException ignore) {
            }
            catch (JMSException e) {
                ServiceTaskManager.this.logError("Error receiving message for service : " + ServiceTaskManager.this.serviceName, (Exception)((Object)e));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(Message message, UserTransaction ut) {
            block38: {
                Throwable e22;
                boolean commitOrAck;
                String messageId;
                block36: {
                    messageId = null;
                    try {
                        messageId = message.getJMSMessageID();
                    }
                    catch (JMSException ignore) {
                        // empty catch block
                    }
                    commitOrAck = true;
                    try {
                        commitOrAck = ServiceTaskManager.this.jmsMessageReceiver.onMessage(message, ut);
                        Object var6_6 = null;
                        if (!commitOrAck || ServiceTaskManager.this.getSessionAckMode() != 2) break block36;
                    }
                    catch (Throwable throwable) {
                        Throwable e22;
                        Object var6_7 = null;
                        if (commitOrAck && ServiceTaskManager.this.getSessionAckMode() == 2) {
                            try {
                                message.acknowledge();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Message : " + messageId + " acknowledged"));
                                }
                            }
                            catch (JMSException e22) {
                                ServiceTaskManager.this.logError("Error acknowledging message : " + messageId, (Exception)e22);
                            }
                        }
                        this.closeConsumer(false);
                        try {
                            if (this.session.getTransacted()) {
                                if (commitOrAck) {
                                    this.session.commit();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Session for message : " + messageId + " committed"));
                                    }
                                } else {
                                    this.session.rollback();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Session for message : " + messageId + " rolled back"));
                                    }
                                }
                            }
                        }
                        catch (JMSException e22) {
                            ServiceTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " local session txn for message : " + messageId, (Exception)e22);
                        }
                        try {
                            if (ut != null) {
                                if (commitOrAck) {
                                    ut.commit();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("JTA txn for message : " + messageId + " committed"));
                                    }
                                } else {
                                    ut.rollback();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("JTA txn for message : " + messageId + " rolled back"));
                                    }
                                }
                            }
                        }
                        catch (Exception e22) {
                            ServiceTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " JTA txn for message : " + messageId + " from the session", (Exception)e22);
                        }
                        this.closeSession(false);
                        this.closeConnection();
                        throw throwable;
                    }
                    try {
                        message.acknowledge();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Message : " + messageId + " acknowledged"));
                        }
                    }
                    catch (JMSException e22) {
                        ServiceTaskManager.this.logError("Error acknowledging message : " + messageId, (Exception)e22);
                    }
                }
                this.closeConsumer(false);
                try {
                    if (this.session.getTransacted()) {
                        if (commitOrAck) {
                            this.session.commit();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Session for message : " + messageId + " committed"));
                            }
                        } else {
                            this.session.rollback();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Session for message : " + messageId + " rolled back"));
                            }
                        }
                    }
                }
                catch (JMSException e22) {
                    ServiceTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " local session txn for message : " + messageId, (Exception)e22);
                }
                try {
                    if (ut != null) {
                        if (commitOrAck) {
                            ut.commit();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("JTA txn for message : " + messageId + " committed"));
                            }
                        } else {
                            ut.rollback();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("JTA txn for message : " + messageId + " rolled back"));
                            }
                        }
                    }
                    break block38;
                }
                catch (Exception e22) {
                    ServiceTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " JTA txn for message : " + messageId + " from the session", (Exception)e22);
                }
                {
                }
            }
            this.closeSession(false);
            this.closeConnection();
        }

        public void onException(JMSException j) {
            if (!ServiceTaskManager.this.isSTMActive()) {
                this.requestShutdown();
                return;
            }
            log.warn((Object)("JMS Connection failure : " + j.getMessage()));
            this.setConnected(false);
            if (ServiceTaskManager.this.cacheLevel < 1) {
                this.requestShutdown();
                return;
            }
            ServiceTaskManager.this.setServiceTaskManagerState(4);
            log.error((Object)("JMS Connection failed : " + j.getMessage() + " - shutting down worker tasks"));
            int r = 1;
            long retryDuration = ServiceTaskManager.this.initialReconnectDuration;
            do {
                try {
                    log.info((Object)("Reconnection attempt : " + r + " for service : " + ServiceTaskManager.this.serviceName));
                    ServiceTaskManager.this.start();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                boolean connected = false;
                for (int i = 0; i < 5; ++i) {
                    if (ServiceTaskManager.this.getConnectedTaskCount() == ServiceTaskManager.this.concurrentConsumers) {
                        connected = true;
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                if (connected) continue;
                log.error((Object)("Reconnection attempt : " + r++ + " for service : " + ServiceTaskManager.this.serviceName + " failed. Next retry in " + retryDuration / 1000L + "seconds"));
                retryDuration = (long)((double)retryDuration * ServiceTaskManager.this.reconnectionProgressionFactor);
                if (retryDuration > ServiceTaskManager.this.maxReconnectDuration) {
                    retryDuration = ServiceTaskManager.this.maxReconnectDuration;
                }
                try {
                    Thread.sleep(retryDuration);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            } while (!ServiceTaskManager.this.isSTMActive() || ServiceTaskManager.this.getConnectedTaskCount() < ServiceTaskManager.this.concurrentConsumers);
        }

        protected void requestShutdown() {
            this.workerState = 3;
        }

        private boolean isActive() {
            return this.workerState == 1;
        }

        protected boolean isTaskIdle() {
            return this.idle;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public void setConnected(boolean connected) {
            this.connected = connected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection getConnection() {
            if (ServiceTaskManager.this.cacheLevel < 1) {
                if (this.connection == null) {
                    this.connection = this.createConnection();
                }
            } else if (ServiceTaskManager.this.sharedConnection != null) {
                this.connection = ServiceTaskManager.this.sharedConnection;
            } else {
                MessageListenerTask messageListenerTask = this;
                synchronized (messageListenerTask) {
                    if (ServiceTaskManager.this.sharedConnection == null) {
                        ServiceTaskManager.this.sharedConnection = this.createConnection();
                    }
                    this.connection = ServiceTaskManager.this.sharedConnection;
                }
            }
            this.setConnected(true);
            return this.connection;
        }

        private Session getSession() {
            if (this.session == null || ServiceTaskManager.this.cacheLevel < 2) {
                this.session = this.createSession();
            }
            return this.session;
        }

        private MessageConsumer getMessageConsumer() {
            if (this.consumer == null || ServiceTaskManager.this.cacheLevel < 3) {
                this.consumer = this.createConsumer();
            }
            return this.consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeConnection() {
            if (this.connection != null && ServiceTaskManager.this.cacheLevel < 1) {
                try {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Closing non-shared JMS connection for service : " + ServiceTaskManager.this.serviceName));
                        }
                        this.connection.close();
                    }
                    catch (JMSException e) {
                        ServiceTaskManager.this.logError("Error closing JMS connection", (Exception)((Object)e));
                        Object var3_2 = null;
                        this.connection = null;
                    }
                    Object var3_1 = null;
                    this.connection = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.connection = null;
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeSession(boolean forced) {
            if (this.session != null && (ServiceTaskManager.this.cacheLevel < 2 || forced)) {
                try {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Closing non-shared JMS session for service : " + ServiceTaskManager.this.serviceName));
                        }
                        this.session.close();
                    }
                    catch (JMSException e) {
                        ServiceTaskManager.this.logError("Error closing JMS session", (Exception)((Object)e));
                        Object var4_3 = null;
                        this.session = null;
                    }
                    Object var4_2 = null;
                    this.session = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.session = null;
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeConsumer(boolean forced) {
            if (this.consumer != null && (ServiceTaskManager.this.cacheLevel < 3 || forced)) {
                try {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Closing non-shared JMS consumer for service : " + ServiceTaskManager.this.serviceName));
                        }
                        this.consumer.close();
                    }
                    catch (JMSException e) {
                        ServiceTaskManager.this.logError("Error closing JMS consumer", (Exception)((Object)e));
                        Object var4_3 = null;
                        this.consumer = null;
                    }
                    Object var4_2 = null;
                    this.consumer = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.consumer = null;
                    throw throwable;
                }
            }
        }

        private Connection createConnection() {
            try {
                ServiceTaskManager.this.conFactory = JMSUtils.lookup(ServiceTaskManager.this.getInitialContext(), ConnectionFactory.class, ServiceTaskManager.this.getConnFactoryJNDIName());
                log.debug((Object)("Connected to the JMS connection factory : " + ServiceTaskManager.this.getConnFactoryJNDIName()));
            }
            catch (NamingException e) {
                ServiceTaskManager.this.handleException("Error looking up connection factory : " + ServiceTaskManager.this.getConnFactoryJNDIName() + " using JNDI properties : " + ServiceTaskManager.this.jmsProperties, e);
            }
            Connection connection = null;
            try {
                connection = JMSUtils.createConnection(ServiceTaskManager.this.conFactory, (String)ServiceTaskManager.this.jmsProperties.get("transport.jms.UserName"), (String)ServiceTaskManager.this.jmsProperties.get("transport.jms.Password"), ServiceTaskManager.this.isJmsSpec11(), ServiceTaskManager.this.isQueue());
                connection.setExceptionListener((ExceptionListener)this);
                connection.start();
                log.debug((Object)("JMS Connection for service : " + ServiceTaskManager.this.serviceName + " created and started"));
            }
            catch (JMSException e) {
                ServiceTaskManager.this.handleException("Error acquiring a JMS connection to : " + ServiceTaskManager.this.getConnFactoryJNDIName() + " using JNDI properties : " + ServiceTaskManager.this.jmsProperties, (Exception)((Object)e));
            }
            return connection;
        }

        private Session createSession() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new JMS Session for service : " + ServiceTaskManager.this.serviceName));
                }
                return JMSUtils.createSession(this.connection, ServiceTaskManager.this.isSessionTransacted(), ServiceTaskManager.this.getSessionAckMode(), ServiceTaskManager.this.isJmsSpec11(), ServiceTaskManager.this.isQueue());
            }
            catch (JMSException e) {
                ServiceTaskManager.this.handleException("Error creating JMS session for service : " + ServiceTaskManager.this.serviceName, (Exception)((Object)e));
                return null;
            }
        }

        private MessageConsumer createConsumer() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new JMS MessageConsumer for service : " + ServiceTaskManager.this.serviceName));
                }
                return JMSUtils.createConsumer(this.session, ServiceTaskManager.this.getDestination(this.session), ServiceTaskManager.this.isQueue(), ServiceTaskManager.this.isSubscriptionDurable() && ServiceTaskManager.this.getDurableSubscriberName() == null ? ServiceTaskManager.this.getDurableSubscriberName() : ServiceTaskManager.this.serviceName, ServiceTaskManager.this.getMessageSelector(), ServiceTaskManager.this.isPubSubNoLocal(), ServiceTaskManager.this.isSubscriptionDurable(), ServiceTaskManager.this.isJmsSpec11());
            }
            catch (JMSException e) {
                ServiceTaskManager.this.handleException("Error creating JMS consumer for service : " + ServiceTaskManager.this.serviceName, (Exception)((Object)e));
                return null;
            }
        }
    }
}

