/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSConnectionFactoryManager {
    private static final Log log = LogFactory.getLog(JMSConnectionFactoryManager.class);
    private final Map<String, JMSConnectionFactory> connectionFactories = new HashMap<String, JMSConnectionFactory>();

    public JMSConnectionFactoryManager(ParameterInclude trpInDesc) {
        this.loadConnectionFactoryDefinitions(trpInDesc);
    }

    private void loadConnectionFactoryDefinitions(ParameterInclude trpDesc) {
        for (Parameter p : trpDesc.getParameters()) {
            try {
                JMSConnectionFactory jmsConFactory = new JMSConnectionFactory(p);
                this.connectionFactories.put(jmsConFactory.getName(), jmsConFactory);
            }
            catch (AxisJMSException e) {
                log.error((Object)("Error setting up connection factory : " + p.getName()), (Throwable)e);
            }
        }
    }

    public JMSConnectionFactory getJMSConnectionFactory(String name) {
        return this.connectionFactories.get(name);
    }

    public JMSConnectionFactory getJMSConnectionFactory(Map<String, String> props) {
        for (JMSConnectionFactory cf : this.connectionFactories.values()) {
            Hashtable<String, String> cfProperties = cf.getParameters();
            if (!JMSConnectionFactoryManager.equals(props.get("transport.jms.ConnectionFactoryJNDIName"), cfProperties.get("transport.jms.ConnectionFactoryJNDIName")) || !JMSConnectionFactoryManager.equals(props.get("java.naming.factory.initial"), cfProperties.get("java.naming.factory.initial")) || !JMSConnectionFactoryManager.equals(props.get("java.naming.provider.url"), cfProperties.get("java.naming.provider.url")) || !JMSConnectionFactoryManager.equals(props.get("java.naming.security.principal"), cfProperties.get("java.naming.security.principal")) || !JMSConnectionFactoryManager.equals(props.get("java.naming.security.credentials"), cfProperties.get("java.naming.security.credentials"))) continue;
            return cf;
        }
        return null;
    }

    private static boolean equals(Object s1, Object s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    protected void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

