/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.migrator;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ConfigurationMigrator {
    private static final String MIGRATOR_XSLT_PATH = "modules/migrator/src/main/resources/synapse-configuration-migrator.xslt";

    public static void doTransform(String xmlFile, String xslFile, String outFile) throws TransformerException, IOException {
        FileReader xslFileReader = new FileReader(xslFile);
        StreamSource xslStreamSource = new StreamSource(xslFileReader);
        FileReader xmlFileReader = new FileReader(xmlFile);
        StreamSource xmlStreamSource = new StreamSource(xmlFileReader);
        FileWriter outFileWriter = new FileWriter(outFile);
        StreamResult outStreamResult = new StreamResult(outFileWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(xslStreamSource);
        transformer.transform(xmlStreamSource, outStreamResult);
        outFileWriter.flush();
    }

    public static void main(String[] arguments) {
        System.out.println("\n[INFO] Migration STARTED");
        try {
            if (arguments.length == 2) {
                System.out.println("[INFO] Migrating the synapse 1.x configuration '" + arguments[0] + "' into a new 2.x configuration at '" + arguments[1] + "'");
                ConfigurationMigrator.doTransform(arguments[0], MIGRATOR_XSLT_PATH, arguments[1]);
            } else if (arguments.length == 3) {
                System.out.println("[INFO] Migrating the synapse 1.x configuration '" + arguments[0] + "' into a new 2.x configuration at '" + arguments[1] + "' using the XSLT '" + arguments[2] + "'");
                ConfigurationMigrator.doTransform(arguments[0], arguments[2], arguments[1]);
            } else {
                System.out.println("[ERROR] Invalid arguments provided for migration");
            }
            System.out.println("[INFO] Migration SUCCESSFULLY COMPLETED");
            System.out.println("[INFO] Migrated 2.x configuration is available at '" + arguments[1] + "'");
        }
        catch (TransformerException e) {
            ConfigurationMigrator.handleException("Migration FAILED\n\t" + e.toString());
        }
        catch (IOException e) {
            ConfigurationMigrator.handleException("Migration FAILED\n\t" + e.toString());
        }
    }

    private static void handleException(String message) {
        System.out.println("[ERROR] " + message);
    }
}

