/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.security;

import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2AuthnRequestsSignedRule
implements SecurityPolicyRule {
    private final Logger log = LoggerFactory.getLogger(SAML2AuthnRequestsSignedRule.class);

    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        SPSSODescriptor spssoRole;
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.debug("Invalid message context type, this policy rule only supports SAMLMessageContext");
            return;
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        Object samlMessage = samlMsgCtx.getInboundSAMLMessage();
        if (!(samlMessage instanceof AuthnRequest)) {
            this.log.debug("Inbound message is not an instance of AuthnRequest, skipping evaluation...");
            return;
        }
        String messageIssuer = samlMsgCtx.getInboundMessageIssuer();
        if (DatatypeHelper.isEmpty((String)messageIssuer)) {
            this.log.warn("Inbound message issuer was empty, unable to evaluate rule");
            return;
        }
        MetadataProvider metadataProvider = samlMsgCtx.getMetadataProvider();
        if (metadataProvider == null) {
            this.log.warn("Message context did not contain a metadata provider, unable to evaluate rule");
            return;
        }
        try {
            spssoRole = (SPSSODescriptor)metadataProvider.getRole(messageIssuer, SPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
        }
        catch (MetadataProviderException e) {
            this.log.error("Error resolving SPSSODescriptor metadata for entityID '{}': {}", (Object)messageIssuer, (Object)e.getMessage());
            throw new SecurityPolicyException("Error resolving metadata for entity ID", (Exception)e);
        }
        if (spssoRole == null) {
            this.log.warn("SPSSODescriptor role metadata for entityID '{}' could not be resolved", (Object)messageIssuer);
            return;
        }
        if (spssoRole.isAuthnRequestsSigned() == Boolean.TRUE) {
            if (!this.isMessageSigned(samlMsgCtx)) {
                this.log.error("SPSSODescriptor for entity ID '{}' indicates AuthnRequests must be signed, but inbound message was not signed", (Object)messageIssuer);
                throw new SecurityPolicyException("Inbound AuthnRequest was required to be signed but was not");
            }
        } else {
            this.log.debug("SPSSODescriptor for entity ID '{}' does not require AuthnRequests to be signed", (Object)messageIssuer);
        }
    }

    protected boolean isMessageSigned(SAMLMessageContext messageContext) {
        SignableSAMLObject signableMessage;
        Object samlMessage = messageContext.getInboundSAMLMessage();
        if (samlMessage instanceof SignableSAMLObject && (signableMessage = (SignableSAMLObject)samlMessage).isSigned()) {
            return true;
        }
        HTTPInTransport inTransport = (HTTPInTransport)messageContext.getInboundMessageTransport();
        String sigParam = inTransport.getParameterValue("Signature");
        return !DatatypeHelper.isEmpty((String)sigParam);
    }
}

