/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.entity.ContentInputStream;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SharedInputBuffer;
import org.apache.http.nio.util.SharedOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EncodingUtils;
import org.apache.synapse.commons.evaluators.EvaluatorContext;
import org.apache.synapse.commons.evaluators.Parser;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.jmx.ThreadingView;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.ServerWorker;
import org.apache.synapse.transport.nhttp.debug.ServerConnectionDebug;
import org.apache.synapse.transport.nhttp.util.LatencyView;
import org.apache.synapse.transport.nhttp.util.NhttpMetricsCollector;

public class ServerHandler
implements NHttpServiceHandler {
    private static final Log log = LogFactory.getLog(ServerHandler.class);
    private final HttpParams params;
    private final HttpResponseFactory responseFactory;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    private final ByteBufferAllocator allocator;
    ConfigurationContext cfgCtx = null;
    private NHttpConfiguration cfg = null;
    private boolean isHttps = false;
    private WorkerPool workerPool = null;
    private NhttpMetricsCollector metrics = null;
    private volatile List<NHttpServerConnection> activeConnections = null;
    private Parser parser = null;
    private PriorityExecutor executor = null;
    private LatencyView latencyView = null;
    private ThreadingView threadingView = null;
    public static final String REQUEST_SINK_BUFFER = "synapse.request-sink-buffer";
    public static final String RESPONSE_SOURCE_BUFFER = "synapse.response-source-buffer";
    public static final String CONNECTION_CREATION_TIME = "synapse.connectionCreationTime";
    public static final String SERVER_CONNECTION_DEBUG = "synapse.server-connection-debug";

    public ServerHandler(ConfigurationContext cfgCtx, HttpParams params, boolean isHttps, NhttpMetricsCollector metrics, Parser parser, PriorityExecutor executor) {
        this.cfgCtx = cfgCtx;
        this.params = params;
        this.isHttps = isHttps;
        this.metrics = metrics;
        this.responseFactory = new DefaultHttpResponseFactory();
        this.httpProcessor = this.getHttpProcessor();
        this.connStrategy = new DefaultConnectionReuseStrategy();
        this.allocator = new HeapByteBufferAllocator();
        this.activeConnections = new ArrayList<NHttpServerConnection>();
        this.latencyView = new LatencyView(isHttps);
        this.threadingView = new ThreadingView("HttpServerWorker", true, 50.0);
        this.cfg = NHttpConfiguration.getInstance();
        if (executor == null) {
            this.workerPool = WorkerPoolFactory.getWorkerPool((int)this.cfg.getServerCoreThreads(), (int)this.cfg.getServerMaxThreads(), (int)this.cfg.getServerKeepalive(), (int)this.cfg.getServerQueueLen(), (String)"Server Worker thread group", (String)"HttpServerWorker");
        } else {
            this.executor = executor;
            this.parser = parser;
        }
    }

    public void requestReceived(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        context.setAttribute("REQ_ARRIVAL_TIME", (Object)System.currentTimeMillis());
        HttpRequest request = conn.getHttpRequest();
        context.setAttribute("http.request", (Object)request);
        context.setAttribute("message-in-flight", (Object)"true");
        conn.getContext().setAttribute(SERVER_CONNECTION_DEBUG, (Object)new ServerConnectionDebug(conn));
        try {
            ContentInputStream is;
            if (request instanceof HttpEntityEnclosingRequest) {
                conn.getContext().setAttribute("REQUEST_READ", (Object)Boolean.FALSE);
                SharedInputBuffer inputBuffer = new SharedInputBuffer(this.cfg.getBufferSize(), (IOControl)conn, this.allocator);
                context.setAttribute(REQUEST_SINK_BUFFER, (Object)inputBuffer);
                is = new ContentInputStream((ContentInputBuffer)inputBuffer);
            } else {
                is = null;
                conn.getContext().removeAttribute("REQUEST_READ");
            }
            SharedOutputBuffer outputBuffer = new SharedOutputBuffer(this.cfg.getBufferSize(), (IOControl)conn, this.allocator);
            context.setAttribute(RESPONSE_SOURCE_BUFFER, (Object)outputBuffer);
            ContentOutputStream os = new ContentOutputStream((ContentOutputBuffer)outputBuffer);
            ProtocolVersion httpVersion = request.getRequestLine().getProtocolVersion();
            HttpResponse response = this.responseFactory.newHttpResponse(httpVersion, 200, context);
            response.setParams(this.params);
            BasicHttpEntity entity = new BasicHttpEntity();
            if (httpVersion.greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                entity.setChunked(true);
            }
            response.setEntity((HttpEntity)entity);
            ServerWorker worker = new ServerWorker(this.cfgCtx, conn, this.isHttps, this.metrics, this, request, (InputStream)is, response, (OutputStream)os);
            if (this.workerPool != null) {
                this.workerPool.execute((Runnable)worker);
            } else if (this.executor != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Header header : request.getAllHeaders()) {
                    headers.put(header.getName(), header.getValue());
                }
                EvaluatorContext evaluatorContext = new EvaluatorContext(request.getRequestLine().getUri(), headers);
                int priority = this.parser.parse(evaluatorContext);
                this.executor.execute((Runnable)worker, priority);
            }
        }
        catch (Exception e) {
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
            this.handleException("Error processing request received for : " + request.getRequestLine().getUri(), e, conn);
        }
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        HttpContext context = conn.getContext();
        ContentInputBuffer inBuf = (ContentInputBuffer)context.getAttribute(REQUEST_SINK_BUFFER);
        try {
            int bytesRead = inBuf.consumeContent(decoder);
            if (this.metrics != null && bytesRead > 0) {
                this.metrics.incrementBytesReceived(bytesRead);
            }
            if (decoder.isCompleted()) {
                ((ServerConnectionDebug)conn.getContext().getAttribute(SERVER_CONNECTION_DEBUG)).recordRequestCompletionTime();
                if (this.metrics != null) {
                    this.metrics.incrementMessagesReceived();
                }
                context.setAttribute("REQUEST_READ", (Object)Boolean.TRUE);
            }
        }
        catch (IOException e) {
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
            this.handleException("I/O Error at inputReady : " + e.getMessage(), e, conn);
        }
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        HttpContext context = conn.getContext();
        HttpResponse response = conn.getHttpResponse();
        ContentOutputBuffer outBuf = (ContentOutputBuffer)context.getAttribute(RESPONSE_SOURCE_BUFFER);
        if (outBuf == null) {
            this.shutdownConnection(conn);
            return;
        }
        try {
            int bytesWritten = outBuf.produceContent(encoder);
            if (this.metrics != null && bytesWritten > 0) {
                this.metrics.incrementBytesSent(bytesWritten);
            }
            if (encoder.isCompleted()) {
                if (context.getAttribute("REQ_ARRIVAL_TIME") != null && context.getAttribute("REQ_DEPARTURE_TIME") != null && context.getAttribute("RES_ARRIVAL_TIME") != null) {
                    this.latencyView.notifyTimes((Long)context.getAttribute("REQ_ARRIVAL_TIME"), (Long)context.getAttribute("REQ_DEPARTURE_TIME"), (Long)context.getAttribute("RES_ARRIVAL_TIME"), System.currentTimeMillis());
                }
                context.removeAttribute("REQ_ARRIVAL_TIME");
                context.removeAttribute("REQ_DEPARTURE_TIME");
                context.removeAttribute("RES_ARRIVAL_TIME");
                ((ServerConnectionDebug)conn.getContext().getAttribute(SERVER_CONNECTION_DEBUG)).recordResponseCompletionTime();
                Boolean reqRead = (Boolean)conn.getContext().getAttribute("REQUEST_READ");
                if (reqRead != null && !reqRead.booleanValue()) {
                    try {
                        conn.close();
                    }
                    catch (Exception ignore) {}
                } else if (!this.connStrategy.keepAlive(response, context)) {
                    conn.close();
                } else {
                    conn.requestInput();
                }
            }
        }
        catch (IOException e) {
            if (this.metrics != null) {
                this.metrics.incrementFaultsSending();
            }
            this.handleException("I/O Error at outputReady : " + e.getMessage(), e, conn);
        }
    }

    public void commitResponseHideExceptions(NHttpServerConnection conn, HttpResponse response) {
        try {
            conn.suspendInput();
            this.httpProcessor.process(response, conn.getContext());
            conn.submitResponse(response);
        }
        catch (HttpException e) {
            this.handleException("Unexpected HTTP protocol error : " + e.getMessage(), (Exception)((Object)e), conn);
        }
        catch (IOException e) {
            this.handleException("IO error submiting response : " + e.getMessage(), e, conn);
        }
    }

    public void commitResponse(NHttpServerConnection conn, HttpResponse response) throws IOException, HttpException {
        try {
            conn.suspendInput();
            this.httpProcessor.process(response, conn.getContext());
            conn.submitResponse(response);
        }
        catch (HttpException e) {
            this.shutdownConnection(conn);
            throw e;
        }
        catch (IOException e) {
            this.shutdownConnection(conn);
            throw e;
        }
    }

    public void timeout(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        Boolean read = (Boolean)context.getAttribute("REQUEST_READ");
        if (read == null || read.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Keepalive connection was closed");
            }
        } else {
            log.error((Object)("Connection Timeout - before message body was fully read : " + conn));
            if (this.metrics != null) {
                this.metrics.incrementTimeoutsReceiving();
            }
        }
        this.shutdownConnection(conn);
    }

    public void connected(NHttpServerConnection conn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"New incoming connection");
        }
        this.metrics.connected();
        conn.getContext().setAttribute(CONNECTION_CREATION_TIME, (Object)System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding a connection : " + conn + " to the pool, existing pool size : " + this.activeConnections.size()));
        }
        this.activeConnections.add(conn);
    }

    public void responseReady(NHttpServerConnection conn) {
        if (JavaUtils.isTrueExplicitly((Object)conn.getContext().getAttribute("forceClosing")) && !JavaUtils.isTrueExplicitly((Object)conn.getContext().getAttribute("message-in-flight"))) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Closing a persisted connection since it is forced : " + conn));
                }
                conn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        this.metrics.notifyReceivedMessageSize(conn.getMetrics().getReceivedBytesCount());
        this.metrics.notifySentMessageSize(conn.getMetrics().getSentBytesCount());
        conn.getMetrics().reset();
        conn.getContext().removeAttribute("message-in-flight");
        if (log.isTraceEnabled()) {
            log.trace((Object)"Ready to send response");
        }
    }

    public void closed(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        this.shutdownConnection(conn);
        context.removeAttribute(REQUEST_SINK_BUFFER);
        context.removeAttribute(RESPONSE_SOURCE_BUFFER);
        context.removeAttribute(CONNECTION_CREATION_TIME);
        context.removeAttribute(SERVER_CONNECTION_DEBUG);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Connection closed");
        }
        this.metrics.disconnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markActiveConnectionsToBeClosed() {
        log.info((Object)("Marking the closing signal on the connection pool of size : " + this.activeConnections.size()));
        ServerHandler serverHandler = this;
        synchronized (serverHandler) {
            for (NHttpServerConnection conn : this.activeConnections) {
                conn.getContext().setAttribute("forceClosing", (Object)"true");
                conn.requestOutput();
            }
        }
    }

    public void exception(NHttpServerConnection conn, HttpException e) {
        if (this.metrics != null) {
            this.metrics.incrementFaultsReceiving();
        }
        HttpContext context = conn.getContext();
        HttpRequest request = conn.getHttpRequest();
        HttpVersion ver = HttpVersion.HTTP_1_0;
        if (request != null && request.getRequestLine() != null) {
            ver = request.getRequestLine().getProtocolVersion();
        }
        HttpResponse response = this.responseFactory.newHttpResponse((ProtocolVersion)ver, 400, context);
        byte[] msg = EncodingUtils.getAsciiBytes((String)("Malformed HTTP request: " + e.getMessage()));
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=US-ASCII");
        response.setEntity((HttpEntity)entity);
        this.commitResponseHideExceptions(conn, response);
    }

    public void exception(NHttpServerConnection conn, IOException e) {
        if (e instanceof ConnectionClosedException || e.getMessage() != null && e.getMessage().contains("Connection reset by peer") || e.getMessage().contains("forcibly closed")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("I/O error (Probably the keepalive connection was closed):" + e.getMessage()));
            }
        } else if (e.getMessage() != null) {
            String msg = e.getMessage().toLowerCase();
            if (msg.indexOf("broken") != -1) {
                log.warn((Object)("I/O error (Probably the connection was closed by the remote party):" + e.getMessage()));
            } else {
                log.error((Object)("I/O error: " + e.getMessage()), (Throwable)e);
            }
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
        } else {
            log.error((Object)("Unexpected I/O error: " + e.getClass().getName()), (Throwable)e);
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
        }
        this.shutdownConnection(conn);
    }

    private void handleException(String msg, Exception e, NHttpServerConnection conn) {
        log.error((Object)msg, (Throwable)e);
        if (conn != null) {
            this.shutdownConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownConnection(NHttpServerConnection conn) {
        SharedInputBuffer inputBuffer;
        SharedOutputBuffer outputBuffer = (SharedOutputBuffer)conn.getContext().getAttribute(RESPONSE_SOURCE_BUFFER);
        if (outputBuffer != null) {
            outputBuffer.close();
        }
        if ((inputBuffer = (SharedInputBuffer)conn.getContext().getAttribute(REQUEST_SINK_BUFFER)) != null) {
            inputBuffer.close();
        }
        ServerHandler serverHandler = this;
        synchronized (serverHandler) {
            if (this.activeConnections.remove(conn) && log.isDebugEnabled()) {
                log.debug((Object)("Removing the connection : " + conn + " from pool of size : " + this.activeConnections.size()));
            }
        }
        try {
            conn.shutdown();
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    public int getActiveConnectionsSize() {
        return this.activeConnections.size();
    }

    private HttpProcessor getHttpProcessor() {
        BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        return httpProcessor;
    }

    public int getActiveCount() {
        return this.workerPool.getActiveCount();
    }

    public int getQueueSize() {
        return this.workerPool.getQueueSize();
    }

    public MetricsCollector getMetrics() {
        return this.metrics;
    }

    public void stop() {
        this.latencyView.destroy();
        this.threadingView.destroy();
        try {
            if (this.workerPool != null) {
                this.workerPool.shutdown(1000);
            } else if (this.executor != null) {
                this.executor.destroy();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

