/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.TransportMBeanSupport;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.Parser;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorFactory;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.PlainServerIOEventDispatch;
import org.apache.synapse.transport.nhttp.ServerHandler;
import org.apache.synapse.transport.nhttp.util.NhttpMetricsCollector;

public class HttpCoreNIOListener
implements TransportListener,
ManagementSupport {
    private static final Log log = LogFactory.getLog(HttpCoreNIOListener.class);
    private ConfigurationContext cfgCtx;
    private TransportInDescription transportIn;
    private DefaultListeningIOReactor ioReactor = null;
    private String serviceEPRPrefix;
    private String customEPRPrefix;
    private Map<String, String> serviceNameToEPRMap = new HashMap<String, String>();
    private Map<String, String> eprToServiceNameMap = new HashMap<String, String>();
    private final AxisObserver axisObserver = new GenericAxisObserver();
    private int port = 8280;
    private String host = "localhost";
    private String bindAddress = null;
    private SSLContext sslContext = null;
    private SSLIOSessionHandler sslIOSessionHandler = null;
    private TransportMBeanSupport mbeanSupport;
    private NhttpMetricsCollector metrics = null;
    private volatile int state = 0;
    private ServerHandler handler = null;
    private PriorityExecutor executor = null;
    private Parser parser = null;

    protected IOEventDispatch getEventDispatch(NHttpServiceHandler handler, SSLContext sslContext, SSLIOSessionHandler sslioSessionHandler, HttpParams params) {
        return new PlainServerIOEventDispatch(handler, params);
    }

    private HttpParams getServerParameters() {
        BasicHttpParams params = new BasicHttpParams();
        NHttpConfiguration cfg = NHttpConfiguration.getInstance();
        params.setIntParameter("http.socket.timeout", cfg.getProperty("http.socket.timeout", 60000)).setIntParameter("http.socket.buffer-size", cfg.getProperty("http.socket.buffer-size", 8192)).setBooleanParameter("http.connection.stalecheck", cfg.getProperty("http.connection.stalecheck", 0) == 1).setBooleanParameter("http.tcp.nodelay", cfg.getProperty("http.tcp.nodelay", 1) == 1).setParameter("http.origin-server", (Object)"Synapse-HttpComponents-NIO");
        if (cfg.getBooleanValue("http.nio.interest-ops-queueing", false)) {
            params.setBooleanParameter("http.nio.interest-ops-queueing", true);
        }
        return params;
    }

    public void init(ConfigurationContext cfgCtx, TransportInDescription transprtIn) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.transportIn = transprtIn;
        cfgCtx.setProperty("service.epr.map", this.eprToServiceNameMap);
        Parameter param = transprtIn.getParameter("port");
        if (param != null) {
            this.port = Integer.parseInt((String)param.getValue());
        }
        if ((param = transprtIn.getParameter("bind-address")) != null) {
            this.bindAddress = ((String)param.getValue()).trim();
        }
        if ((param = transprtIn.getParameter("hostname")) != null) {
            this.host = ((String)param.getValue()).trim();
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.warn((Object)"Unable to lookup local host name, using 'localhost'");
            }
        }
        this.sslContext = this.getSSLContext(transprtIn);
        this.sslIOSessionHandler = this.getSSLIOSessionHandler(transprtIn);
        param = transprtIn.getParameter("WSDLEPRPrefix");
        if (param != null) {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(cfgCtx, (String)param.getValue());
            this.customEPRPrefix = (String)param.getValue();
        } else {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(cfgCtx, this.host, this.port);
            this.customEPRPrefix = transprtIn.getName() + "://" + this.host + ":" + (this.port == 80 ? "" : Integer.valueOf(this.port)) + "/";
        }
        cfgCtx.getAxisConfiguration().addObservers(this.axisObserver);
        this.mbeanSupport = new TransportMBeanSupport((TransportListener)this, "nio-http" + (this.sslContext == null ? "" : "s"));
        this.mbeanSupport.register();
        this.metrics = new NhttpMetricsCollector(true, this.sslContext != null);
        param = transprtIn.getParameter("priorityConfigFile");
        if (param != null && param.getValue() != null) {
            this.createPriorityConfiguration(param.getValue().toString());
        }
    }

    public int getActiveConnectionsSize() {
        return this.handler.getActiveConnectionsSize();
    }

    private void createPriorityConfiguration(String fileName) throws AxisFault {
        OMElement definitions = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            definitions = new StAXOMBuilder((InputStream)fis).getDocumentElement();
            assert (definitions != null);
            definitions.build();
        }
        catch (FileNotFoundException e) {
            this.handleException("Priority configuration file cannot be found : " + fileName, e);
        }
        catch (XMLStreamException e) {
            this.handleException("Error parsing priority configuration xml file " + fileName, e);
        }
        OMElement executorElem = definitions.getFirstChildWithName(new QName("priorityExecutor"));
        if (executorElem == null) {
            this.handleException("priorityExecutor configuration is mandatory for priority based routing");
        }
        this.executor = PriorityExecutorFactory.createExecutor(null, (OMElement)executorElem, (boolean)false, (Properties)new Properties());
        OMElement conditionsElem = definitions.getFirstChildWithName(new QName("conditions"));
        if (conditionsElem == null) {
            this.handleException("Conditions configuration is mandatory for priority based routing");
        }
        this.executor.init();
        assert (conditionsElem != null);
        OMAttribute defPriorityAttr = conditionsElem.getAttribute(new QName("defaultPriority"));
        this.parser = defPriorityAttr != null ? new Parser(Integer.parseInt(defPriorityAttr.getAttributeValue())) : new Parser();
        try {
            this.parser.init(conditionsElem);
        }
        catch (EvaluatorException e) {
            this.handleException("Invalid conditions configuration for priority based mediation", (Exception)((Object)e));
        }
        log.info((Object)("Created a priority based executor from the configuration: " + fileName));
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String host, int port) {
        return "http://" + host + (port == 80 ? "" : ":" + port) + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String wsdlEPRPrefix) {
        return wsdlEPRPrefix + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected SSLContext getSSLContext(TransportInDescription transportIn) throws AxisFault {
        return null;
    }

    protected SSLIOSessionHandler getSSLIOSessionHandler(TransportInDescription transportIn) throws AxisFault {
        return null;
    }

    public void start() throws AxisFault {
        ListenerEndpoint endpoint;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting Listener...");
        }
        HttpParams params = this.getServerParameters();
        try {
            String prefix = (this.sslContext == null ? "http" : "https") + "-Listener I/O dispatcher";
            this.ioReactor = new DefaultListeningIOReactor(NHttpConfiguration.getInstance().getServerIOWorkers(), (ThreadFactory)new NativeThreadFactory(new ThreadGroup(prefix + " thread group"), prefix), params);
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOException e) {
            this.handleException("Error starting the IOReactor", e);
        }
        for (AxisService obj : this.cfgCtx.getAxisConfiguration().getServices().values()) {
            this.addToServiceURIMap(obj);
        }
        this.handler = new ServerHandler(this.cfgCtx, params, this.sslContext != null, this.metrics, this.parser, this.executor);
        final IOEventDispatch ioEventDispatch = this.getEventDispatch(this.handler, this.sslContext, this.sslIOSessionHandler, params);
        this.state = 1;
        try {
            endpoint = this.bindAddress == null ? this.ioReactor.listen((SocketAddress)new InetSocketAddress(this.port)) : this.ioReactor.listen((SocketAddress)new InetSocketAddress(InetAddress.getByName(this.bindAddress), this.port));
        }
        catch (IOException e) {
            this.handleException("Encountered an I/O error: " + e.getMessage(), e);
            return;
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    HttpCoreNIOListener.this.ioReactor.execute(ioEventDispatch);
                }
                catch (InterruptedIOException ex) {
                    log.fatal((Object)"Reactor Interrupted", (Throwable)ex);
                }
                catch (IOException e) {
                    log.fatal((Object)("Encountered an I/O error: " + e.getMessage()), (Throwable)e);
                }
                catch (Exception e) {
                    log.fatal((Object)"Unexpected exception in I/O reactor", (Throwable)e);
                }
                log.info((Object)((HttpCoreNIOListener.this.sslContext == null ? "HTTP" : "HTTPS") + " Listener Shutdown"));
            }
        }, "HttpCoreNIOListener");
        t.start();
        try {
            endpoint.waitFor();
        }
        catch (InterruptedException e) {
            log.warn((Object)"HttpCoreNIOListener#start() was interrupted");
        }
        log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + " Listener started on" + (this.bindAddress != null ? " address : " + this.bindAddress : "") + " port : " + this.port));
    }

    private void addToServiceURIMap(AxisService service) {
        Parameter param = service.getParameter("ServiceURI");
        if (param != null) {
            String uriLocation = param.getValue().toString();
            if (uriLocation.startsWith("/")) {
                uriLocation = uriLocation.substring(1);
            }
            this.serviceNameToEPRMap.put(service.getName(), uriLocation);
            this.eprToServiceNameMap.put(uriLocation, service.getName());
        }
    }

    private void removeServiceFfromURIMap(AxisService service) {
        this.eprToServiceNameMap.remove(this.serviceNameToEPRMap.get(service.getName()));
        this.serviceNameToEPRMap.remove(service.getName());
    }

    public void stop() throws AxisFault {
        if (this.state == 0) {
            return;
        }
        try {
            this.ioReactor.shutdown();
            this.handler.stop();
            this.state = 0;
            for (AxisService obj : this.cfgCtx.getAxisConfiguration().getServices().values()) {
                this.removeServiceFfromURIMap(obj);
            }
        }
        catch (IOException e) {
            this.handleException("Error shutting down IOReactor", e);
        }
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            this.ioReactor.pause();
            this.handler.markActiveConnectionsToBeClosed();
            this.state = 2;
            log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + " Listener Paused"));
        }
        catch (IOException e) {
            this.handleException("Error pausing IOReactor", e);
        }
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        try {
            this.ioReactor.resume();
            this.state = 1;
            log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + "Listener Resumed"));
        }
        catch (IOException e) {
            this.handleException("Error resuming IOReactor", e);
        }
    }

    public int getActiveThreadCount() {
        return this.handler.getActiveCount();
    }

    public int getQueueSize() {
        return this.handler.getQueueSize();
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.ioReactor.pause();
            this.ioReactor.shutdown(millis);
            this.state = 0;
            log.info((Object)("Listener shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenence", e);
        }
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        String trailler = "";
        if (serviceName.indexOf(47) != -1) {
            trailler = trailler + serviceName.substring(serviceName.indexOf("/"));
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        if (serviceName.indexOf(46) != -1) {
            trailler = trailler + serviceName.substring(serviceName.indexOf("."));
            serviceName = serviceName.substring(0, serviceName.indexOf(46));
        }
        if (this.serviceNameToEPRMap.containsKey(serviceName)) {
            return new EndpointReference(this.customEPRPrefix + this.serviceNameToEPRMap.get(serviceName) + trailler);
        }
        return new EndpointReference(this.serviceEPRPrefix + serviceName + trailler);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String trailler = "";
        if (serviceName.indexOf(47) != -1) {
            trailler = trailler + serviceName.substring(serviceName.indexOf("/"));
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        if (serviceName.indexOf(46) != -1) {
            trailler = trailler + serviceName.substring(serviceName.indexOf("."));
            serviceName = serviceName.substring(0, serviceName.indexOf(46));
        }
        EndpointReference[] endpointReferences = new EndpointReference[]{this.serviceNameToEPRMap.containsKey(serviceName) ? new EndpointReference(this.customEPRPrefix + this.serviceNameToEPRMap.get(serviceName) + trailler) : new EndpointReference(this.serviceEPRPrefix + serviceName + trailler)};
        return endpointReferences;
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void destroy() {
        this.ioReactor = null;
        this.cfgCtx.getAxisConfiguration().getObserversList().remove(this.axisObserver);
        this.mbeanSupport.unregister();
        this.metrics.destroy();
    }

    private boolean ignoreService(AxisService service) {
        return service.getName().startsWith("__") || JavaUtils.isTrueExplicitly((Object)service.getParameter("hiddenService"));
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    public long getTimeoutsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsReceiving();
        }
        return -1L;
    }

    public long getTimeoutsSending() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsSending();
        }
        return -1L;
    }

    public long getMinSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeReceived();
        }
        return -1L;
    }

    public long getMaxSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeReceived();
        }
        return -1L;
    }

    public double getAvgSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeReceived();
        }
        return -1.0;
    }

    public long getMinSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeSent();
        }
        return -1L;
    }

    public long getMaxSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeSent();
        }
        return -1L;
    }

    public double getAvgSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeSent();
        }
        return -1.0;
    }

    public Map getResponseCodeTable() {
        if (this.metrics != null) {
            return this.metrics.getResponseCodeTable();
        }
        return null;
    }

    public void resetStatistics() {
        if (this.metrics != null) {
            this.metrics.reset();
        }
    }

    public long getLastResetTime() {
        if (this.metrics != null) {
            return this.metrics.getLastResetTime();
        }
        return -1L;
    }

    public long getMetricsWindow() {
        if (this.metrics != null) {
            return System.currentTimeMillis() - this.metrics.getLastResetTime();
        }
        return -1L;
    }

    class GenericAxisObserver
    implements AxisObserver {
        GenericAxisObserver() {
        }

        public void init(AxisConfiguration axisConfig) {
        }

        public void serviceUpdate(AxisEvent event, AxisService service) {
            if (!HttpCoreNIOListener.this.ignoreService(service) && BaseUtils.isUsingTransport((AxisService)service, (String)HttpCoreNIOListener.this.transportIn.getName())) {
                switch (event.getEventType()) {
                    case 1: {
                        HttpCoreNIOListener.this.addToServiceURIMap(service);
                        break;
                    }
                    case 0: {
                        HttpCoreNIOListener.this.removeServiceFfromURIMap(service);
                        break;
                    }
                    case 3: {
                        HttpCoreNIOListener.this.addToServiceURIMap(service);
                        break;
                    }
                    case 2: {
                        HttpCoreNIOListener.this.removeServiceFfromURIMap(service);
                    }
                }
            }
        }

        public void moduleUpdate(AxisEvent event, AxisModule module) {
        }

        public void addParameter(Parameter param) throws AxisFault {
        }

        public void removeParameter(Parameter param) throws AxisFault {
        }

        public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        }

        public Parameter getParameter(String name) {
            return null;
        }

        public ArrayList getParameters() {
            return null;
        }

        public boolean isParameterLocked(String parameterName) {
            return false;
        }

        public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
        }
    }
}

