/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.registry;

import java.util.Date;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.registry.RegistryEntry;

public class RegistryEntryImpl
implements RegistryEntry {
    private static final Log log = LogFactory.getLog(RegistryEntry.class);
    private String key = null;
    private String name = null;
    private long version = Long.MIN_VALUE;
    private String type = null;
    private String description;
    private long created;
    private long lastModified;
    private long cachableDuration;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        try {
            new ContentType(type);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Content type :" + type));
            }
            this.type = type;
        }
        catch (ParseException e) {
            String msg = "Invalid content-type ' " + type + " '";
            throw new SynapseException(msg, e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getCachableDuration() {
        return this.cachableDuration;
    }

    public void setCachableDuration(long cachableDuration) {
        this.cachableDuration = cachableDuration;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RegistryEntry {").append(" Key : ").append(this.key).append(" Name : ").append(this.name).append(" Version : ").append(this.version).append(" Type : ").append(this.type).append(" Description : ").append(this.description).append(" Created : ").append(new Date(this.created)).append(" Modified : ").append(new Date(this.lastModified)).append(" Cacheable for : ").append(this.cachableDuration / 1000L).append("sec").append("}");
        return sb.toString();
    }
}

