/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.filters.router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.evaluators.EvaluatorContext;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.filters.router.Route;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalRouterMediator
extends AbstractMediator {
    private List<Route> routes = new ArrayList<Route>();
    private boolean continueAfter;
    private boolean continueAfterExplicitlySet;

    @Override
    public boolean mediate(MessageContext synCtx) {
        Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
        org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
        Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
        HashMap<String, String> evaluatorHeaders = new HashMap<String, String>();
        if (headers != null && headers instanceof Map) {
            Map headersMap = (Map)headers;
            for (Map.Entry entryObj : headersMap.entrySet()) {
                Map.Entry entry = entryObj;
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                evaluatorHeaders.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        String restParams = (String)axis2MessageCtx.getProperty("REST_URL_POSTFIX");
        String url = synCtx.getTo().getAddress() + (restParams != null ? restParams : "");
        EvaluatorContext context = new EvaluatorContext(url, evaluatorHeaders);
        context.setProperties(((Axis2MessageContext)synCtx).getProperties());
        context.setMessageContext(((Axis2MessageContext)synCtx).getAxis2MessageContext());
        try {
            for (Route route : this.routes) {
                if (!route.getEvaluator().evaluate(context)) continue;
                route.getTarget().mediate(synCtx);
                if (!route.isBreakRoute()) continue;
                break;
            }
        }
        catch (EvaluatorException ee) {
            this.handleException("Couldn't evaluate the route condition", (Exception)((Object)ee), synCtx);
        }
        return this.continueAfter;
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public void addRoute(Route route) {
        this.routes.add(route);
    }

    public boolean isContinueAfter() {
        return this.continueAfter;
    }

    public void setContinueAfter(boolean continueAfter) {
        this.continueAfterExplicitlySet = true;
        this.continueAfter = continueAfter;
    }

    public boolean isContinueAfterExplicitlySet() {
        return this.continueAfterExplicitlySet;
    }
}

