/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.ListMediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListMediator
extends AbstractMediator
implements ListMediator {
    protected final List<Mediator> mediators = new ArrayList<Mediator>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        int parentsEffectiveTraceState = synCtx.getTracingState();
        this.setEffectiveTraceState(synCtx);
        int myEffectiveTraceState = synCtx.getTracingState();
        try {
            SynapseLog synLog = this.getLog(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Sequence <" + this.getType() + "> :: mediate()");
            }
            for (Mediator mediator : this.mediators) {
                synCtx.setTracingState(myEffectiveTraceState);
                if (mediator.mediate(synCtx)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            synCtx.setTracingState(parentsEffectiveTraceState);
        }
        return true;
    }

    @Override
    public List<Mediator> getList() {
        return this.mediators;
    }

    @Override
    public boolean addChild(Mediator m) {
        return this.mediators.add(m);
    }

    @Override
    public boolean addAll(List<Mediator> c) {
        return this.mediators.addAll(c);
    }

    @Override
    public Mediator getChild(int pos) {
        return this.mediators.get(pos);
    }

    @Override
    public boolean removeChild(Mediator m) {
        return this.mediators.remove(m);
    }

    @Override
    public Mediator removeChild(int pos) {
        return this.mediators.remove(pos);
    }

    @Override
    public void init(SynapseEnvironment se) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing child mediators of mediator : " + this.getType()));
        }
        for (Mediator mediator : this.mediators) {
            if (!(mediator instanceof ManagedLifecycle)) continue;
            ((ManagedLifecycle)((Object)mediator)).init(se);
        }
    }

    @Override
    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Destroying child mediators of mediator : " + this.getType()));
        }
        for (Mediator mediator : this.mediators) {
            if (!(mediator instanceof ManagedLifecycle)) continue;
            ((ManagedLifecycle)((Object)mediator)).destroy();
        }
    }
}

